package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditCruiseUI extends JPanel implements TuttiUI<EditCruiseUIModel, EditCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BEGIN_DATE_FIELD_DATE = "beginDateField.date";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_COUNTRY_COMBO_BOX_SELECTED_ITEM = "countryComboBox.selectedItem";
    public static final String BINDING_END_DATE_FIELD_DATE = "endDateField.date";
    public static final String BINDING_FILTER_VESSEL_ALL_BUTTON_SELECTED = "filterVesselAllButton.selected";
    public static final String BINDING_FILTER_VESSEL_FISHING_BUTTON_SELECTED = "filterVesselFishingButton.selected";
    public static final String BINDING_FILTER_VESSEL_SCIENTIFIC_BUTTON_SELECTED = "filterVesselScientificButton.selected";
    public static final String BINDING_GENERATE_NAME_BUTTON_ENABLED = "generateNameButton.enabled";
    public static final String BINDING_MULTIRIG_NUMBER_FIELD_MODEL = "multirigNumberField.model";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SURVEY_COMBO_BOX_SELECTED_ITEM = "surveyComboBox.selectedItem";
    public static final String BINDING_SURVEY_PART_FIELD_TEXT = "surveyPartField.text";
    public static final String BINDING_YEAR_FIELD_MODEL = "yearField.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVZz28cSRUuO/7tiRMnJOslCXhDNjhEtBMEEpAoxHYyiS07a3lmo+waYWqma8aV7eluqqudsUZB/An8CXDngoTgABfEgTMHLqv9FxDiwBXxqqu7q6uneqbb9mE07nrvq++9qn71vZrf/QtNBwx99Bb3+xYLXU57xNrZePPmk9Zb0ubPSNBm1OceQ/JvYhJNHqJFO30ecPStw13hvh67r295Pd9ziZvxfrSLFgJ+6pDgmBDO0S3dox0E6410+FHfD1mCmpIyof7mP/+e/LX9q99OItT3gd09CGV1nJeKZGoXTVKboysw0wled7DbBRqMul3ge1E823JwELzCPfIL9Es0u4tmfMwAjKPb5UOOMCL/vs/R/LHXI/vYJQ5HP+gwi3YY6RFm8ZBzaoXUCt7B/FbbcznAWW0W0oBYz23Kt6Kvn277foQ2w9HsMXZthzCOHp8J6aV0V4DTPc8WxH58Jrg94azALhHGPNbELYfsSdjH2tKcYIfaGDIVIzfE5+vk4R4JAtwlyl0Bz6eeHN2vAJlJ3J0I9wFHK5q/9IrGhOV86lDzmddluLeLWyKQK2Jv9GPzneihMFxJ7ZeCkJ2QU9gWLW/T6+d5SkcCuQOqLYJdaxM+Emsdav6UYJZOccswWKfEgV18t3iKV2GvRdjz6B8d4JIkuo8ZL5ojYxLPdF0Lv0n6ciBHzYXXppC3GEydvqMPXukSlzDMiXjxNmH7wZZDV7U55VPd7WovdDhltCujLZo6Z5aS+Fg3q7U9yCQ7LcxKPJ5dtNXcJmiRLnWfQSBFIMoizuyqx7rWW6iuX3DPl8H2rZ03wmKftr8gudWrEdcehZ+Mp0E+yY3f2WkQKGni7XiQX9d0RPe5fAJvJnHq1OGEiUKWfx2i4qb7LHci69eRp062nhpdyxptOE6y8isa+gG2qaeWX7nfzLo32hSKFO3QtjLd0+0/zNrXaXAM8IXGc3dkWA/E/y/14BZkQnZpAOfCd0u858+8EAqMsBcIB2qSrnjT48evc2MxgYcGAsvHBNufdPZoEFDP1QA+Uy+VNGpA0TzwvF6B1WLb6/Ugc3JdP9D3Q5t5jiNGht6UyCfewteGisMGI1jYHg1F8z1DNLU2dtvEUUsRhUxUugN8QgpHL2dXtXnqQxS3DUsiFI7EeMG80IeTgaEbmh1IEktJEqUZJg7RNAvhMWzMw2EVcwBDUr+s5PSLAIxG/3f96j///NUf6olouQ9zXzOaZjQXiAk4gnw466mY+pJULCGnzvoe9h8donmIFwRbJMhuGog14mEgB/MtC3dLuFsvcXAMENOzX/71b9d//o8LaLKOFhwP23Us7LfRPD9mkAXPsfv+T55GjGrv5uDzsuAGtbwD1lycmSAgOtgJSB/Cv2kIP+XQmv/7f682fv80ScEEUPqw0FylYfpzNENdh7okUm6xKDMqtUU/IKHtKfFlkmMIBNncTtPznE2cyAM5+G4o0gscTYlXGNTDIJJJ72Ev0oc/dPcZ6VA44i9JpRQv06kFmYGsvTsggVC8U5yFkBiBPYgiFt/eCwK17Nk/hsTEEAkj5JJeZsaAThkim8ch9/Y9PwS09UGsM60u4Vue26HdtXsWDTYSk6y8WLv33hC4UBHwKLJO6vqDAtgGGGYRpT3gmrOXNR0T6CSstiNOn7qQjouDVIS8FzShUkHJk4sYWSUaV5gNz51VOH6JZZP4yzLDImSxWY1RZeXROOR8SKkeHB2SMDNOnIrNcRNPqW4hE9Nn4B7tgItutCz7mEM1hsW+Pth+1Tz6/tGz7RfbzcbR/kaz+fzgFRjOhQGpiwKSFA94lLxCEMJIomfI0PIgp2ZVnm4Z8qSMTSTy4rn8NvhApayRYhRshrz+rhpwTqiqgL9uCDg2NvHQFHEJEjV5IhF7m5MeR19TIW9JoGijZBZ7dsTkebldLQmXB3o/NjoHca9nzEG2DzxXDvYl0FAORkyeayqrpkDvNVQKbhpSkNoaeeh9TZldD/03EUUgDX8zgSjY9LnOqFqsS4Ns3zN6sWNL42Jnu6vyUWYW+bkEKIhR686qRXhtYOhiVaAfGQLVHUx8TA10hWPghop7TwMacSA8rHogLFUOo1R2QdzVjgLOPLcbif5UtpjekeEWYwGkMrRe2+JyDM3IcRO14T54HLFpiD6pIdCzximmgZodOuUowTHT1VFMLezAQi22VOdj7JimT7Ajgr8gzTno4yb1mxH+nXH4Fqe+KXZze18t/lVD/KrVz6bh2yNpBqlPhWwsaF5aUu6XnK0oNyPvLqql6JYhRfHtRjY/o5exIx0qJGdWuWiZWSszT1Faiq9oylRLVTRm5A0NfGl5zBb35U8Hm9E32eOeQo0kUIiblDvEliNrR2u3s9wd6KMsiXP7nrmeZy6CqvGbEhc/GXZPzsZOoBRxS++WqjG7qF0tZSi+OBtFDa6I6/B9VjXSS/pVV4b1y/OwTvCKaBtu2EqIhpTb48rc4nu3Ij7Zu7zynYkm0yP/IvWSvfYrsUCzxBV3RFCiPk5L1J5n0w70Aat3766mZUv8XBOVqtpRFO1GdLZytDJo4BMif2ySz6y2uMsxv4vqlrBE7LmZvjHYiu4g1Y9bY+fTbi1LqA2VjRtpNmDSF5lfPrLlOhZ0UmZYye8jW7jnY9p1hXVOhMwlNsadOvwDS5md6uBTD4zR0mMQuni1RV0bCvKToRkmxOdCCcQ5ceskDgKwmPiTGeebY3GE819GIPyoFMIfRyA0zs3h03MjvDl3FJ+fm8NPz43ws3NH0QGE/wN8jSJitSAAAA==";
    private static final Log log = LogFactory.getLog(EditCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "beginDate",  editorName = "beginDateField")
    protected JXDatePicker beginDateField;
    protected JLabel beginDateLabel;
    protected JButton cancelButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    @ValidatorField( validatorId = "validator",  propertyName = "country",  editorName = "countryComboBox")
    protected BeanComboBox<Country> countryComboBox;
    protected JLabel countryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "endDate",  editorName = "endDateField")
    protected JXDatePicker endDateField;
    protected JLabel endDateLabel;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JRadioButton filterVesselAllButton;
    protected JRadioButton filterVesselFishingButton;
    protected JLabel filterVesselLabel;
    protected JRadioButton filterVesselScientificButton;
    protected JAXXButtonGroup filterVesselType;
    @ValidatorField( validatorId = "validator",  propertyName = "gear",  editorName = "gearList")
    protected BeanDoubleList<Gear> gearList;
    protected JButton generateNameButton;
    protected EditCruiseUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfMission",  editorName = "headOfMissionList")
    protected BeanDoubleList<Person> headOfMissionList;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfSortRoom",  editorName = "headOfSortRoomList")
    protected BeanDoubleList<Person> headOfSortRoomList;
    protected EditCruiseUI homePanel = this;
    protected EditCruiseUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "multirigNumber",  editorName = "multirigNumberField")
    protected NumberEditor multirigNumberField;
    protected JLabel multirigNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    protected JLabel programLabel;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "surveyComboBox")
    protected BeanComboBox<Program> surveyComboBox;
    @ValidatorField( validatorId = "validator",  propertyName = "surveyPart",  editorName = "surveyPartField")
    protected JTextField surveyPartField;
    protected JLabel surveyPartLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JPanel vesselFilterPane;
    @ValidatorField( validatorId = "validator",  propertyName = "vessel",  editorName = "vesselList")
    protected BeanDoubleList<Vessel> vesselList;
    @ValidatorField( validatorId = "validator",  propertyName = "year",  editorName = "yearField")
    protected NumberEditor yearField;
    protected JLabel yearLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JSeparator $JSeparator0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCruiseUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  EditCruiseUIHandler handler = new EditCruiseUIHandler(parentUI, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public EditCruiseUI() {
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__beginDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "beginDate");
    }

    public void doActionPerformed__on__endDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "endDate");
    }

    public void doActionPerformed__on__filterVesselAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.ALL);
    }

    public void doActionPerformed__on__filterVesselFishingButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.FISHING);
    }

    public void doActionPerformed__on__filterVesselScientificButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.SCIENTIFIC);
    }

    public void doActionPerformed__on__generateNameButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.generateCampaignName();
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doKeyReleased__on__surveyPartField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "surveyPart");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXDatePicker getBeginDateField() {
        return beginDateField;
    }

    public JLabel getBeginDateLabel() {
        return beginDateLabel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public BeanComboBox<Country> getCountryComboBox() {
        return countryComboBox;
    }

    public JLabel getCountryLabel() {
        return countryLabel;
    }

    public JXDatePicker getEndDateField() {
        return endDateField;
    }

    public JLabel getEndDateLabel() {
        return endDateLabel;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public JRadioButton getFilterVesselAllButton() {
        return filterVesselAllButton;
    }

    public JRadioButton getFilterVesselFishingButton() {
        return filterVesselFishingButton;
    }

    public JLabel getFilterVesselLabel() {
        return filterVesselLabel;
    }

    public JRadioButton getFilterVesselScientificButton() {
        return filterVesselScientificButton;
    }

    public JAXXButtonGroup getFilterVesselType() {
        return filterVesselType;
    }

    public BeanDoubleList<Gear> getGearList() {
        return gearList;
    }

    public JButton getGenerateNameButton() {
        return generateNameButton;
    }

    public EditCruiseUIHandler getHandler() {
        return handler;
    }

    public BeanDoubleList<Person> getHeadOfMissionList() {
        return headOfMissionList;
    }

    public BeanDoubleList<Person> getHeadOfSortRoomList() {
        return headOfSortRoomList;
    }

    public EditCruiseUIModel getModel() {
        return model;
    }

    public NumberEditor getMultirigNumberField() {
        return multirigNumberField;
    }

    public JLabel getMultirigNumberLabel() {
        return multirigNumberLabel;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public BeanComboBox<Program> getSurveyComboBox() {
        return surveyComboBox;
    }

    public JTextField getSurveyPartField() {
        return surveyPartField;
    }

    public JLabel getSurveyPartLabel() {
        return surveyPartLabel;
    }

    public SwingValidator<EditCruiseUIModel> getValidator() {
        return validator;
    }

    public JPanel getVesselFilterPane() {
        return vesselFilterPane;
    }

    public BeanDoubleList<Vessel> getVesselList() {
        return vesselList;
    }

    public NumberEditor getYearField() {
        return yearField;
    }

    public JLabel getYearLabel() {
        return yearLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToFilterVesselAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselAllButton); }
    }

    protected void addChildrenToFilterVesselFishingButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselFishingButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselFishingButton); }
    }

    protected void addChildrenToFilterVesselScientificButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselScientificButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselScientificButton); }
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToVesselFilterPane() {
        if (!allComponentsCreated) {
            return;
        }
        vesselFilterPane.add(filterVesselLabel);
        vesselFilterPane.add(filterVesselAllButton);
        vesselFilterPane.add(filterVesselScientificButton);
        vesselFilterPane.add(filterVesselFishingButton);
    }

    protected void createBeginDateField() {
        $objectMap.put("beginDateField", beginDateField = new JXDatePicker());
        
        beginDateField.setName("beginDateField");
        beginDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__beginDateField"));
    }

    protected void createBeginDateLabel() {
        $objectMap.put("beginDateLabel", beginDateLabel = new JLabel());
        
        beginDateLabel.setName("beginDateLabel");
        beginDateLabel.setText(_("tutti.label.cruise.beginDate"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.putClientProperty("tuttiAction", CancelEditCruiseAction.class);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
    }

    protected void createCountryComboBox() {
        $objectMap.put("countryComboBox", countryComboBox = new BeanComboBox<Country>(this));
        
        countryComboBox.setName("countryComboBox");
        countryComboBox.setI18nPrefix("tutti.property.");
        countryComboBox.setProperty("country");
        countryComboBox.setShowReset(true);
    }

    protected void createCountryLabel() {
        $objectMap.put("countryLabel", countryLabel = new JLabel());
        
        countryLabel.setName("countryLabel");
        countryLabel.setText(_("tutti.label.cruise.country"));
    }

    protected void createEndDateField() {
        $objectMap.put("endDateField", endDateField = new JXDatePicker());
        
        endDateField.setName("endDateField");
        endDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__endDateField"));
    }

    protected void createEndDateLabel() {
        $objectMap.put("endDateLabel", endDateLabel = new JLabel());
        
        endDateLabel.setName("endDateLabel");
        endDateLabel.setText(_("tutti.label.cruise.endDate"));
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createFilterVesselAllButton() {
        $objectMap.put("filterVesselAllButton", filterVesselAllButton = new JRadioButton());
        
        filterVesselAllButton.setName("filterVesselAllButton");
        filterVesselAllButton.setText(_("tutti.label.filterVesselType.all"));
        { filterVesselAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterVesselAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselAllButton.setToolTipText(_("tutti.label.filterVesselType.all.tip"));
        filterVesselAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselAllButton"));
    }

    protected void createFilterVesselFishingButton() {
        $objectMap.put("filterVesselFishingButton", filterVesselFishingButton = new JRadioButton());
        
        filterVesselFishingButton.setName("filterVesselFishingButton");
        filterVesselFishingButton.setText(_("tutti.label.filterVesselType.fishing"));
        { filterVesselFishingButton.putClientProperty("$value", "fishing");  Object $buttonGroup = filterVesselFishingButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselFishingButton.setToolTipText(_("tutti.label.filterVesselType.fishing.tip"));
        filterVesselFishingButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselFishingButton"));
    }

    protected void createFilterVesselLabel() {
        $objectMap.put("filterVesselLabel", filterVesselLabel = new JLabel());
        
        filterVesselLabel.setName("filterVesselLabel");
        filterVesselLabel.setText(_("tutti.label.filterVesselType"));
        filterVesselLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterVesselScientificButton() {
        $objectMap.put("filterVesselScientificButton", filterVesselScientificButton = new JRadioButton());
        
        filterVesselScientificButton.setName("filterVesselScientificButton");
        filterVesselScientificButton.setText(_("tutti.label.filterVesselType.scientific"));
        { filterVesselScientificButton.putClientProperty("$value", "scientific");  Object $buttonGroup = filterVesselScientificButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselScientificButton.setToolTipText(_("tutti.label.filterVesselType.scientific.tip"));
        filterVesselScientificButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselScientificButton"));
    }

    protected void createFilterVesselType() {
        $objectMap.put("filterVesselType", filterVesselType = new JAXXButtonGroup());
    }

    protected void createGearList() {
        $objectMap.put("gearList", gearList = new BeanDoubleList<Gear>());
        
        gearList.setName("gearList");
        gearList.setProperty("gear");
    }

    protected void createGenerateNameButton() {
        $objectMap.put("generateNameButton", generateNameButton = new JButton());
        
        generateNameButton.setName("generateNameButton");
        generateNameButton.setText(_("tutti.action.generateCampaignName"));
        generateNameButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__generateNameButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditCruiseUIHandler.class));
    }

    protected void createHeadOfMissionList() {
        $objectMap.put("headOfMissionList", headOfMissionList = new BeanDoubleList<Person>());
        
        headOfMissionList.setName("headOfMissionList");
        headOfMissionList.setProperty("headOfMission");
    }

    protected void createHeadOfSortRoomList() {
        $objectMap.put("headOfSortRoomList", headOfSortRoomList = new BeanDoubleList<Person>());
        
        headOfSortRoomList.setName("headOfSortRoomList");
        headOfSortRoomList.setProperty("headOfSortRoom");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCruiseUIModel.class));
    }

    protected void createMultirigNumberField() {
        $objectMap.put("multirigNumberField", multirigNumberField = new NumberEditor(this));
        
        multirigNumberField.setName("multirigNumberField");
        multirigNumberField.setProperty("multirigNumber");
        multirigNumberField.setUseFloat(false);
        multirigNumberField.setShowReset(true);
    }

    protected void createMultirigNumberLabel() {
        $objectMap.put("multirigNumberLabel", multirigNumberLabel = new JLabel());
        
        multirigNumberLabel.setName("multirigNumberLabel");
        multirigNumberLabel.setText(_("tutti.label.cruise.multirigNumber"));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(_("tutti.label.cruise.name"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(_("tutti.label.cruise.program"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.putClientProperty("tuttiAction", SaveCruiseAction.class);
    }

    protected void createSurveyComboBox() {
        $objectMap.put("surveyComboBox", surveyComboBox = new BeanComboBox<Program>(this));
        
        surveyComboBox.setName("surveyComboBox");
        surveyComboBox.setI18nPrefix("tutti.property.");
        surveyComboBox.setProperty("program");
        surveyComboBox.setShowReset(true);
    }

    protected void createSurveyPartField() {
        $objectMap.put("surveyPartField", surveyPartField = new JTextField());
        
        surveyPartField.setName("surveyPartField");
        surveyPartField.setColumns(15);
        surveyPartField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__surveyPartField"));
    }

    protected void createSurveyPartLabel() {
        $objectMap.put("surveyPartLabel", surveyPartLabel = new JLabel());
        
        surveyPartLabel.setName("surveyPartLabel");
        surveyPartLabel.setText(_("tutti.label.cruise.surveyPart"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCruiseUIModel.class, null));
    }

    protected void createVesselFilterPane() {
        $objectMap.put("vesselFilterPane", vesselFilterPane = new JPanel());
        
        vesselFilterPane.setName("vesselFilterPane");
    }

    protected void createVesselList() {
        $objectMap.put("vesselList", vesselList = new BeanDoubleList<Vessel>());
        
        vesselList.setName("vesselList");
        vesselList.setProperty("vessel");
    }

    protected void createYearField() {
        $objectMap.put("yearField", yearField = new NumberEditor(this));
        
        yearField.setName("yearField");
        yearField.setProperty("year");
        yearField.setUseFloat(false);
        yearField.setShowReset(true);
    }

    protected void createYearLabel() {
        $objectMap.put("yearLabel", yearLabel = new JLabel());
        
        yearLabel.setName("yearLabel");
        yearLabel.setText(_("tutti.label.cruise.year"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add(programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(surveyComboBox), new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(yearLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(yearField), new GridBagConstraints(3, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(surveyPartLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(surveyPartField), new GridBagConstraints(5, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(generateNameButton, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(multirigNumberLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(multirigNumberField), new GridBagConstraints(5, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(countryLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(countryComboBox), new GridBagConstraints(1, 2, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDateLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(beginDateField), new GridBagConstraints(3, 2, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDateLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(endDateField), new GridBagConstraints(5, 2, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator0, new GridBagConstraints(0, 3, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselFilterPane, new GridBagConstraints(0, 4, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 5, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 6, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 7, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 8, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToVesselFilterPane();
        addChildrenToFilterVesselAllButton();
        addChildrenToFilterVesselScientificButton();
        addChildrenToFilterVesselFishingButton();
        // inline complete setup of $JPanel0
        $JPanel0.add(SwingUtil.boxComponentWithJxLayer(vesselList));
        $JPanel0.add(SwingUtil.boxComponentWithJxLayer(gearList));
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(headOfMissionList));
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(headOfSortRoomList));
        addChildrenToCommentPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(cancelButton);
        $JPanel2.add(saveButton);
        
        // apply 14 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 39 property setters
        surveyComboBox.setBeanType(Program.class);
        countryComboBox.setBeanType(Country.class);
        vesselList.setBeanType(Vessel.class);
        gearList.setBeanType(Gear.class);
        headOfMissionList.setBeanType(Person.class);
        headOfSortRoomList.setBeanType(Person.class);
        programLabel.setLabelFor(surveyComboBox);
        surveyComboBox.setBean(model);
        yearLabel.setLabelFor(yearField);
        yearField.setBean(model);
        yearField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        yearField.setNumberPattern(INT_4_DIGITS_PATTERN);
        yearField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        surveyPartLabel.setLabelFor(surveyPartField);
        nameLabel.setLabelFor(nameField);
        generateNameButton.setIcon(SwingUtil.createActionIcon("generate"));
        multirigNumberLabel.setLabelFor(multirigNumberField);
        multirigNumberField.setBean(model);
        multirigNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        multirigNumberField.setNumberPattern(INT_1_DIGITS_PATTERN);
        multirigNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        countryLabel.setLabelFor(countryComboBox);
        countryComboBox.setBean(model);
        beginDateLabel.setLabelFor(beginDateField);
        endDateLabel.setLabelFor(endDateField);
        filterVesselLabel.setIcon(SwingUtil.createActionIcon("filter"));
        vesselList.setBean(model);
        vesselList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.list.vessel")));
        gearList.setBean(model);
        gearList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.list.gear")));
        headOfMissionList.setBean(model);
        headOfMissionList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.list.headOfMission")));
        headOfSortRoomList.setBean(model);
        headOfSortRoomList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.list.headOfSortRoom")));
        commentPane.setBorder(BorderFactory.createTitledBorder(_("tutti.label.comment")));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createProgramLabel();
        createSurveyComboBox();
        createYearLabel();
        createYearField();
        createSurveyPartLabel();
        createSurveyPartField();
        createNameLabel();
        createNameField();
        createGenerateNameButton();
        createMultirigNumberLabel();
        createMultirigNumberField();
        createCountryLabel();
        createCountryComboBox();
        createBeginDateLabel();
        createBeginDateField();
        createEndDateLabel();
        createEndDateField();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator(SwingConstants.HORIZONTAL));
        
        $JSeparator0.setName("$JSeparator0");
        createVesselFilterPane();
        createFilterVesselLabel();
        createFilterVesselAllButton();
        createFilterVesselScientificButton();
        createFilterVesselFishingButton();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createVesselList();
        createGearList();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createHeadOfMissionList();
        createHeadOfSortRoomList();
        createCommentPane();
        createCommentField();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        createFilterVesselType();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 14 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 14 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SURVEY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    surveyComboBox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_YEAR_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("year", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    yearField.setModel(model.getYear());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("year", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SURVEY_PART_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("surveyPart", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(surveyPartField, model.getSurveyPart());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("surveyPart", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_NAME_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerateName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateNameButton.setEnabled(model.isCanGenerateName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerateName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MULTIRIG_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("multirigNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    multirigNumberField.setModel(model.getMultirigNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("multirigNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COUNTRY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("country", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    countryComboBox.setSelectedItem(model.getCountry());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("country", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BEGIN_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("beginDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    beginDateField.setDate(model.getBeginDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("beginDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("endDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    endDateField.setDate(model.getEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("endDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselAllButton.setSelected(model.isVesselTypeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_SCIENTIFIC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeScientific", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselScientificButton.setSelected(model.isVesselTypeScientific());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeScientific", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_FISHING_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeFishing", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselFishingButton.setSelected(model.isVesselTypeFishing());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeFishing", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}