/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.editor;

import fr.ifremer.tutti.ui.swing.util.TuttiComputedOrNotData;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.NumberEditorHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuttiComputedOrNotDataEditorHandler
extends NumberEditorHandler {
    private static final Log log = LogFactory.getLog(TuttiComputedOrNotDataEditorHandler.class);
    protected Integer decimalNumber;

    public TuttiComputedOrNotDataEditorHandler(TuttiComputedOrNotDataEditor ui) {
        super((NumberEditor)ui);
    }

    public void init() {
        final PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiComputedOrNotDataEditorHandler.this.setComputedTextIfNullModel();
            }
        };
        TuttiComputedOrNotData bean = (TuttiComputedOrNotData)((Object)this.editor.getBean());
        if (bean != null) {
            bean.addPropertyChangeListener(l);
        }
        this.editor.addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiComputedOrNotData bean = (TuttiComputedOrNotData)((Object)evt.getOldValue());
                if (bean != null) {
                    bean.removePropertyChangeListener(l);
                }
                if ((bean = (TuttiComputedOrNotData)((Object)evt.getNewValue())) != null) {
                    bean.addPropertyChangeListener(l);
                }
            }
        });
        this.editor.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextField tf = TuttiComputedOrNotDataEditorHandler.this.editor.getTextField();
                tf.setFont(TuttiUI.TEXTFIELD_NORMAL_FONT);
                tf.setForeground(Color.BLACK);
                if (TuttiComputedOrNotDataEditorHandler.this.editor.getModel() == null) {
                    tf.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                TuttiComputedOrNotDataEditorHandler.this.setComputedTextIfNullModel();
            }
        });
        this.editor.addPropertyChangeListener("decimalNumber", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiComputedOrNotDataEditorHandler.this.decimalNumber = (Integer)evt.getNewValue();
            }
        });
        this.decimalNumber = ((TuttiComputedOrNotDataEditor)this.editor).getDecimalNumber();
        super.init();
    }

    protected void setComputedTextIfNullModel() {
        TuttiComputedOrNotData bean = (TuttiComputedOrNotData)((Object)this.editor.getBean());
        if (bean != null && this.editor.getModel() == null) {
            JTextField tf = this.editor.getTextField();
            tf.setFont(TuttiUI.TEXTFIELD_COMPUTED_FONT);
            tf.setForeground(((TuttiComputedOrNotDataEditor)this.editor).getComputedDataColor());
            Object computedData = bean.getComputedData();
            String modelText = this.editor.isUseFloat() != false && this.decimalNumber != null && computedData != null ? String.format("%." + this.decimalNumber + "f", computedData) : JAXXUtil.getStringValue(computedData);
            tf.setText(modelText);
        }
    }
}

