/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.classreading.RecursiveAnnotationAttributesVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationAttributesReadingVisitor
extends RecursiveAnnotationAttributesVisitor {
    private final String annotationType;
    private final Map<String, AnnotationAttributes> attributesMap;
    private final Map<String, Set<String>> metaAnnotationMap;

    public AnnotationAttributesReadingVisitor(String annotationType, Map<String, AnnotationAttributes> attributesMap, Map<String, Set<String>> metaAnnotationMap, ClassLoader classLoader) {
        super(annotationType, new AnnotationAttributes(), classLoader);
        this.annotationType = annotationType;
        this.attributesMap = attributesMap;
        this.metaAnnotationMap = metaAnnotationMap;
    }

    @Override
    public void doVisitEnd(Class<?> annotationClass) {
        super.doVisitEnd(annotationClass);
        this.attributesMap.put(this.annotationType, this.attributes);
        this.registerMetaAnnotations(annotationClass);
    }

    private void registerMetaAnnotations(Class<?> annotationClass) {
        LinkedHashSet<String> metaAnnotationTypeNames = new LinkedHashSet<String>();
        Annotation[] annotationArray = annotationClass.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation metaAnnotation = annotationArray[n2];
            metaAnnotationTypeNames.add(metaAnnotation.annotationType().getName());
            if (!this.attributesMap.containsKey(metaAnnotation.annotationType().getName())) {
                this.attributesMap.put(metaAnnotation.annotationType().getName(), AnnotationUtils.getAnnotationAttributes(metaAnnotation, true, true));
            }
            Annotation[] annotationArray2 = metaAnnotation.annotationType().getAnnotations();
            int n3 = annotationArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation metaMetaAnnotation = annotationArray2[n4];
                metaAnnotationTypeNames.add(metaMetaAnnotation.annotationType().getName());
                ++n4;
            }
            ++n2;
        }
        if (this.metaAnnotationMap != null) {
            this.metaAnnotationMap.put(annotationClass.getName(), metaAnnotationTypeNames);
        }
    }
}

