/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment;

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.swing.ComponentResizer;
import jaxx.runtime.swing.HBox;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class AttachmentEditorUIHandler {
    private static final Log log = LogFactory.getLog(AttachmentEditorUIHandler.class);
    public static final String CLOSE_DIALOG_ACTION = "closeDialog";
    public static final String SHOW_DIALOG_ACTION = "showDialog";
    protected final AttachmentEditorUI ui;
    protected final PersistenceService persistenceService;
    protected final TuttiUIContext context;
    protected Action closeAction;
    protected Action openAction;

    public AttachmentEditorUIHandler(TuttiUIContext context, AttachmentEditorUI ui) {
        this.context = context;
        this.ui = ui;
        this.persistenceService = context.getPersistenceService();
    }

    protected void beforeInitUI() {
    }

    protected void afterInitUI() {
        this.ui.getFile().setDialogOwner((JDialog)this.ui);
        this.ui.pack();
        this.ui.setResizable(true);
        ComponentResizer cr = new ComponentResizer();
        cr.registerComponent(new Component[]{this.ui});
        ComponentMover cm = new ComponentMover();
        cm.setDragInsets(cr.getDragInsets());
        cm.registerComponent(new Component[]{this.ui});
        JRootPane rootPane = this.ui.getRootPane();
        KeyStroke shortcutClosePopup = KeyStroke.getKeyStroke(27, 0);
        rootPane.getInputMap(2).put(shortcutClosePopup, CLOSE_DIALOG_ACTION);
        this.closeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentEditorUIHandler.this.ui.dispose();
                AttachmentEditorUIHandler.this.ui.setVisible(false);
            }
        };
        this.openAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentEditorUIHandler.this.ui.setVisible(true);
            }
        };
        ImageIcon actionIcon = SwingUtil.createActionIcon((String)"close-dialog");
        this.closeAction.putValue("SmallIcon", actionIcon);
        this.closeAction.putValue("SwingLargeIconKey", actionIcon);
        this.closeAction.putValue("ActionCommandKey", "close");
        this.closeAction.putValue("Name", "close");
        this.closeAction.putValue("ShortDescription", I18n._((String)"tutti.action.closeAttachment.tip", (Object[])new Object[0]));
        rootPane.getActionMap().put(CLOSE_DIALOG_ACTION, this.closeAction);
        rootPane.getActionMap().put(SHOW_DIALOG_ACTION, this.openAction);
        JButton closeButton = new JButton(this.closeAction);
        closeButton.setText(null);
        closeButton.setFocusPainted(false);
        closeButton.setRequestFocusEnabled(false);
        closeButton.setFocusable(false);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOpaque(false);
        jToolBar.add(this.closeAction);
        jToolBar.setBorderPainted(false);
        jToolBar.setFloatable(false);
        this.ui.getAttachmentBody().setRightDecoration((JComponent)jToolBar);
    }

    public void closeEditor() {
        this.closeAction.actionPerformed(null);
    }

    public void openEditor(JComponent component) {
        if (component != null) {
            this.place(component);
        }
        this.openAction.actionPerformed(null);
    }

    public void init() {
        List<Attachment> list;
        this.resetFields();
        this.ui.getAttachments().removeAll();
        AttachmentModelAware bean = this.ui.getBean();
        if (bean != null && (list = bean.getAttachment()) != null) {
            for (Attachment attachment : list) {
                this.addAttachment(attachment);
            }
        }
    }

    public void place(JComponent component) {
        int x = 0;
        int y = component.getHeight();
        for (Container comp = component; comp != null; comp = comp.getParent()) {
            x += ((Component)comp).getX();
            y += ((Component)comp).getY();
        }
        this.ui.pack();
        if (x + this.ui.getWidth() > this.ui.getOwner().getX() + this.ui.getOwner().getWidth()) {
            x = x - this.ui.getWidth() + component.getWidth();
        }
        this.ui.setLocation(x, y);
    }

    public void addAttachment() {
        AttachmentModelAware bean = this.ui.getBean();
        Attachment attachment = new Attachment();
        File file = this.ui.getFile().getSelectedFile();
        if (file != null) {
            String name = this.ui.getFileName().getText();
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = file.getName();
            }
            attachment.setObjectType(bean.getObjectType());
            attachment.setObjectId(Integer.valueOf(bean.getObjectId()));
            attachment.setName(name);
            attachment.setComment(this.ui.getFileComment().getText());
            attachment = this.persistenceService.createAttachment(attachment, file);
            bean.addAttachment(attachment);
            this.resetFields();
            this.addAttachment(attachment);
            this.ui.pack();
        }
    }

    protected void addAttachment(final Attachment attachment) {
        final HBox hbox = new HBox();
        hbox.setVerticalAlignment(0);
        JButton deleteButton = new JButton(SwingUtil.createActionIcon((String)"delete"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentModelAware bean = AttachmentEditorUIHandler.this.ui.getBean();
                AttachmentEditorUIHandler.this.persistenceService.deleteAttachment(attachment.getId());
                bean.removeAttachment(attachment);
                AttachmentEditorUIHandler.this.ui.getAttachments().remove((Component)hbox);
                AttachmentEditorUIHandler.this.ui.pack();
            }
        });
        hbox.add((Component)deleteButton);
        final JLabel label = new JLabel("<html><body><a href=''>" + attachment.getName() + "</a></body></html>");
        label.setToolTipText(attachment.getComment());
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                File file = AttachmentEditorUIHandler.this.persistenceService.getAttachmentFile(attachment.getId());
                SwingUtil.openLink((String)("file://" + file.getAbsolutePath()));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setCursor(Cursor.getDefaultCursor());
            }
        });
        hbox.add((Component)label);
        this.ui.getAttachments().add((Component)hbox);
    }

    protected void resetFields() {
        this.ui.getFile().setSelectedFile((File)null);
        this.ui.getFile().setSelectedFile((String)null);
        this.ui.getFileName().setText("");
        this.ui.getFileComment().setText("");
    }
}

