/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategory;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategoryComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategoryType;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SelectSpeciesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.TableViewMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.FrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextCellComponent;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataTableCell;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class SpeciesBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<SpeciesBatchRowModel, SpeciesBatchUIModel, SpeciesBatchUI> {
    private static final Log log = LogFactory.getLog(SpeciesBatchUIHandler.class);
    public static JAXXContextEntryDef<List<Caracteristic>> FREQUENCY_LENGTH_CONTEXT_ENTRY = JAXXUtil.newListContextEntryDef((String)"frequencyLength");
    public static JAXXContextEntryDef<List<Species>> SPECIES_REFERENT_CONTEXT_ENTRY = JAXXUtil.newListContextEntryDef((String)"speciesReferent");
    public static final Set<String> SAMPLING_PROPERTIES = Sets.newHashSet((Object[])new String[]{"sampleCategory", "species", "sortedUnsortedCategory", "sizeCategory", "sexCategory", "maturityCategory", "ageCategory", "sortedUnsortedCategoryWeight", "sizeCategoryWeight", "sexCategoryWeight", "maturityCategoryWeight", "ageCategoryWeight"});
    private final EnumMap<TableViewMode, RowFilter<SpeciesBatchTableModel, Integer>> tableFilters = new EnumMap(TableViewMode.class);

    public SpeciesBatchUIHandler(TuttiUI<?, ?> parentUi, SpeciesBatchUI ui) {
        super(parentUi, ui, "species", "sortedUnsortedCategory", "sortedUnsortedCategoryWeight", "sizeCategory", "sizeCategoryWeight", "sexCategory", "sexCategoryWeight", "maturityCategory", "maturityCategoryWeight", "ageCategory", "ageCategoryWeight", "weight", "number", "comment", "attachment", "frequency", "speciesToConfirm");
        this.tableFilters.put(TableViewMode.ALL, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                return true;
            }
        });
        this.tableFilters.put(TableViewMode.ROOT, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    SpeciesBatchTableModel model = entry.getModel();
                    SpeciesBatchRowModel row = (SpeciesBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchRoot();
                }
                return result;
            }
        });
        this.tableFilters.put(TableViewMode.LEAF, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    SpeciesBatchTableModel model = entry.getModel();
                    SpeciesBatchRowModel row = (SpeciesBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchLeaf();
                }
                return result;
            }
        });
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Get species batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            model.removeAllAttachment(model.getAttachment());
            if (!TuttiEntities.isNew(bean)) {
                BatchContainer rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(bean.getId());
                model.setRootBatchId(rootSpeciesBatch.getId());
                List attachments = this.persistenceService.getAllAttachments(Integer.valueOf(model.getObjectId()));
                model.addAllAttachment(attachments);
                if (log.isInfoEnabled()) {
                    log.info((Object)("species root batch id: " + model.getRootBatchId()));
                }
                List catches = rootSpeciesBatch.getChildren();
                for (SpeciesBatch aBatch : catches) {
                    Preconditions.checkState((aBatch.getSampleCategoryType() == SampleCategoryEnum.sortedUnsorted ? 1 : 0) != 0, (Object)("Root species batch must be a sortedUnsorted sample category but was:" + aBatch.getSampleCategoryType()));
                    SpeciesBatchRowModel rootRow = this.loadSpeciesBatch(aBatch, null, rows);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Loaded root batch " + this.decorate(rootRow.getSpecies()) + " - " + this.decorate(rootRow.getSortedUnsortedCategoryValue())));
                }
            }
        }
        model.setRows(rows);
        this.recomputeBatchActionEnable();
    }

    public SpeciesBatchTableModel getTableModel() {
        return (SpeciesBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((SpeciesBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SpeciesBatchRowModel row) {
        boolean result = row.getSpecies() != null;
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        if (SAMPLING_PROPERTIES.contains(propertyName)) {
            this.recomputeRowValidState(row);
        }
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesBatchRowModel> rowMonitor, SpeciesBatchRowModel row) {
        if (row.isValid()) {
            if (rowMonitor.wasModified()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Row " + row + " was modified, will save it"));
                }
                this.showInformationMessage("[ Captures - Esp\u00e8ces ] Sauvegarde des modifications de " + row + '.');
                this.saveRow(row);
                rowMonitor.clearModified();
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Will not remove not valid speciesBatch: " + row.getId()));
        }
    }

    @Override
    protected void onModelRowsChanged(List<SpeciesBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.getSpeciesUsed().clear();
        model.setRootNumber(0);
        for (SpeciesBatchRowModel row : rows) {
            this.updateTotalFromFrequencies(row);
            if (!row.isBatchRoot()) continue;
            this.addToSpeciesUsed(row);
        }
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, SpeciesBatchRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, SpeciesBatchRowModel oldRow, int newRowIndex, SpeciesBatchRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        this.recomputeBatchActionEnable();
    }

    @Override
    public SwingValidator<SpeciesBatchUIModel> getValidator() {
        return ((SpeciesBatchUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        ArrayList lengthCaracterics;
        if (log.isDebugEnabled()) {
            log.debug((Object)("beforeInit: " + this.ui));
        }
        EditCatchesUIModel catchesUIModel = ((SpeciesBatchUI)this.ui).getContextValue(EditCatchesUIModel.class);
        SpeciesBatchUIModel model = new SpeciesBatchUIModel(catchesUIModel);
        model.setTableViewMode(TableViewMode.ALL);
        ((SpeciesBatchUI)this.ui).setContextValue(model);
        if (this.context.isProtocolFilled()) {
            TuttiProtocol protocol = this.getDataContext().getProtocol();
            lengthCaracterics = Lists.newArrayListWithCapacity((int)protocol.sizeLengthClassesPmfmId());
            Map<String, Caracteristic> allCaractericsById = TuttiEntities.splitById(this.getDataContext().getCaracteristics());
            if (!protocol.isLengthClassesPmfmIdEmpty()) {
                for (String id : protocol.getLengthClassesPmfmId()) {
                    lengthCaracterics.add(allCaractericsById.get(id));
                }
            }
        } else {
            lengthCaracterics = Lists.newArrayList(this.getDataContext().getCaracteristics());
        }
        List<Species> speciesList = this.getDataContext().getReferentSpecies();
        SPECIES_REFERENT_CONTEXT_ENTRY.setContextValue((JAXXContext)this.ui, speciesList);
        FREQUENCY_LENGTH_CONTEXT_ENTRY.setContextValue((JAXXContext)this.ui, (Object)lengthCaracterics);
    }

    @Override
    public void afterInitUI() {
        ArrayList allSpecies;
        ArrayList samplingOrder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        List speciesUniverse = (List)SPECIES_REFERENT_CONTEXT_ENTRY.getContextValue((JAXXContext)this.ui);
        HashMultimap speciesSampleCategories = HashMultimap.create();
        boolean protocolFilled = this.context.isProtocolFilled();
        if (protocolFilled) {
            TuttiProtocol protocol = this.getDataContext().getProtocol();
            Preconditions.checkNotNull((Object)protocol, (Object)"Could not find protocol in ui context");
            samplingOrder = Lists.newArrayList((Object[])new SampleCategoryType[]{SampleCategoryType.sortedUnsorted, SampleCategoryType.size, SampleCategoryType.sex, SampleCategoryType.maturity, SampleCategoryType.age});
            allSpecies = Lists.newArrayList();
            if (!protocol.isSpeciesEmpty()) {
                Map<String, Species> map = TuttiEntities.splitByTaxonId(speciesUniverse);
                for (SpeciesProtocol protocolSpecy : protocol.getSpecies()) {
                    String taxonId = String.valueOf(protocolSpecy.getSpeciesReferenceTaxonId());
                    Species species = map.get(taxonId);
                    allSpecies.add(species);
                    speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.sortedUnsorted);
                    speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.size);
                    speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.sex);
                    speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.maturity);
                    speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.age);
                }
            }
        } else {
            samplingOrder = Lists.newArrayList((Object[])new SampleCategoryType[]{SampleCategoryType.sortedUnsorted, SampleCategoryType.size, SampleCategoryType.sex, SampleCategoryType.maturity, SampleCategoryType.age});
            allSpecies = Lists.newArrayList((Iterable)speciesUniverse);
            for (Species species : allSpecies) {
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.sortedUnsorted);
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.size);
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.sex);
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.maturity);
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.age);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use sampling order: " + samplingOrder));
            log.info((Object)("Will use " + allSpecies.size() + " species."));
        }
        ((SpeciesBatchUIModel)this.getModel()).setSamplingOrder(samplingOrder);
        ((SpeciesBatchUIModel)this.getModel()).setAllSpecies(allSpecies);
        JXTable table = this.getTable();
        table.setColumnControlVisible(true);
        TableCellRenderer defaultRenderer = table.getDefaultRenderer(Object.class);
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<CaracteristicQualitativeValue> caracteristicDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        Color computedDataColor = this.getConfig().getColorComputedWeights();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class), SpeciesBatchTableModel.SPECIES);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SORTED_UNSORTED_CATEGORY, caracteristicDecorator, defaultRenderer);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SIZE_CATEGORY, caracteristicDecorator, defaultRenderer);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SEX_CATEGORY, caracteristicDecorator, defaultRenderer);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.MATURITY_CATEGORY, caracteristicDecorator, defaultRenderer);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.AGE_CATEGORY, this.getDecorator(Float.class, null), defaultRenderer);
        this.addColumnToModel((TableColumnModel)columnModel, TuttiComputedOrNotDataTableCell.newEditor(Float.class, false, true, 3, computedDataColor), TuttiComputedOrNotDataTableCell.newRender(defaultRenderer, true, 3, computedDataColor), SpeciesBatchTableModel.WEIGHT);
        this.addColumnToModel((TableColumnModel)columnModel, FrequencyCellComponent.newEditor((SpeciesBatchUI)this.ui, computedDataColor), FrequencyCellComponent.newRender(computedDataColor), SpeciesBatchTableModel.COMPUTED_NUMBER);
        this.addColumnToModel((TableColumnModel)columnModel, LongTextCellComponent.newEditor(((SpeciesBatchUI)this.ui).getLongTextEditor()), LongTextCellComponent.newRender(I18n.n_((String)"tutti.tooltip.comment.none", (Object[])new Object[0])), SpeciesBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(this.ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), SpeciesBatchTableModel.ATTACHMENT);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SPECIES_TO_CONFIRM, (JTable)this.getTable());
        SpeciesBatchTableModel tableModel = new SpeciesBatchTableModel((TableColumnModelExt)columnModel, (Multimap<Species, SampleCategoryType>)speciesSampleCategories);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        Color toConfirmColor = this.getConfig().getColorRowToConfirm();
        Highlighter attachmentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                SpeciesBatchRowModel row = (SpeciesBatchRowModel)SpeciesBatchUIHandler.this.getTableModel().getEntry(adapter.row);
                return row.getSpeciesToConfirm();
            }
        }, toConfirmColor);
        table.addHighlighter(attachmentHighlighter);
        this.initBatchTable(table, (TableColumnModel)columnModel, tableModel);
        Highlighter selectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.IS_SELECTED, new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{SpeciesBatchTableModel.SPECIES})}), UIManager.getColor("Table[Enabled+Selected].textBackground"));
        table.addHighlighter(selectedHighlighter);
        attachmentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                SpeciesBatchRowModel row = (SpeciesBatchRowModel)SpeciesBatchUIHandler.this.getTableModel().getEntry(adapter.row);
                return row.getSpeciesToConfirm() != false && !adapter.isEditable();
            }
        }, toConfirmColor.darker());
        table.addHighlighter(attachmentHighlighter);
        ((SpeciesBatchUIModel)this.getModel()).addPropertyChangeListener("tableViewMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableViewMode tableViewMode = (TableViewMode)((Object)evt.getNewValue());
                if (tableViewMode == null) {
                    tableViewMode = TableViewMode.ALL;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will use rowfilter for viewMode: " + (Object)((Object)tableViewMode)));
                }
                RowFilter filter = (RowFilter)SpeciesBatchUIHandler.this.tableFilters.get((Object)tableViewMode);
                SpeciesBatchUIHandler.this.getTable().setRowFilter(filter);
            }
        });
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing: " + this.ui));
        }
        ((SpeciesBatchUI)this.ui).getSpeciesBatchAttachmentsButton().onCloseUI();
    }

    public void createSpeciesBatch() {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        CreateSpeciesBatchUI createBatchEditor = parent.getSpeciesTabCreateBatch();
        createBatchEditor.getHandler().openUI((SpeciesBatchUIModel)this.getModel());
        parent.getHandler().setSpeciesSelectedCard("createBatch");
    }

    public void addSpeciesBatch(CreateSpeciesBatchUIModel createModel) {
        if (createModel.isValid()) {
            SpeciesBatchTableModel tableModel = this.getTableModel();
            SpeciesBatchRowModel newRow = tableModel.createNewRow();
            Species species = createModel.getSpecies();
            newRow.setSpecies(species);
            CaracteristicQualitativeValue sortedUnsortedCategory = createModel.getSortedUnsortedCategory();
            SampleCategory<CaracteristicQualitativeValue> category = newRow.getSortedUnsortedCategory();
            category.setCategoryValue(sortedUnsortedCategory);
            category.setCategoryWeight(createModel.getBatchWeight());
            newRow.setSampleCategory(category);
            this.recomputeRowValidState(newRow);
            tableModel.addNewRow(newRow);
            AbstractSelectTableAction.doSelectCell((JTable)this.getTable(), tableModel.getRowCount() - 1, 0);
            this.saveRow(newRow);
            this.addToSpeciesUsed(newRow);
        }
        this.recomputeBatchActionEnable();
    }

    public void splitSpeciesBatch() {
        JXTable table = this.getTable();
        int rowIndex = table.getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant split batch if no batch selected");
        SpeciesBatchTableModel tableModel = this.getTableModel();
        SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
        boolean split = true;
        if (parentBatch.getWeight() != null) {
            int i = JOptionPane.showConfirmDialog((Component)((Object)this.ui), I18n._((String)"tutti.dialog.catches.species.split.weightNotNull.message", (Object[])new Object[0]), I18n._((String)"tutti.dialog.catches.species.split.weightNotNull.title", (Object[])new Object[0]), 2);
            if (i == 0) {
                parentBatch.setWeight(null);
            } else {
                split = false;
            }
        }
        if (split) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Open split batch ui for row [" + rowIndex + ']'));
            }
            EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
            SplitSpeciesBatchUI splitBatchEditor = parent.getSpeciesTabSplitBatch();
            splitBatchEditor.getHandler().editBatch(parentBatch);
            parent.getHandler().setSpeciesSelectedCard("splitBatch");
        }
    }

    public void splitBatch(SplitSpeciesBatchUIModel splitModel) {
        if (splitModel.isValid()) {
            JXTable table = this.getTable();
            int insertRow = table.getSelectedRow();
            SpeciesBatchTableModel tableModel = this.getTableModel();
            SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)tableModel.getEntry(insertRow);
            SampleCategoryType selectedCategory = splitModel.getSelectedCategory();
            SampleCategoryEnum sampleCategoryEnum = selectedCategory.getType();
            ArrayList newBatches = Lists.newArrayList();
            for (SplitSpeciesBatchRowModel row : splitModel.getRows()) {
                if (!row.isValid()) continue;
                SpeciesBatchRowModel newBatch = tableModel.createNewRow();
                this.loadBatchRow(parentBatch, newBatch, sampleCategoryEnum, row.getCategoryValue(), row.getWeight());
                this.recomputeRowValidState(newBatch);
                newBatches.add(newBatch);
                tableModel.addNewRow(++insertRow, newBatch);
            }
            parentBatch.setChildBatch(newBatches);
            this.saveRows(newBatches);
            SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
            model.setLeafNumber(model.getLeafNumber() + newBatches.size() - 1);
        }
        this.recomputeBatchActionEnable();
    }

    public void updateTotalFromFrequencies(SpeciesBatchRowModel row) {
        List<SpeciesFrequencyRowModel> frequency = row.getFrequency();
        if (CollectionUtils.isNotEmpty(frequency)) {
            Integer totalNumber = 0;
            for (SpeciesFrequencyRowModel frequencyModel : frequency) {
                if (frequencyModel.getNumber() == null) continue;
                totalNumber = totalNumber + frequencyModel.getNumber();
            }
            row.setComputedNumber(totalNumber);
            row.getFinestCategory().setOnlyOneFrequency(frequency.size() == 1);
        }
    }

    public void saveRows(Iterable<SpeciesBatchRowModel> rows) {
        for (SpeciesBatchRowModel row : rows) {
            this.saveRow(row);
        }
    }

    protected void saveRow(SpeciesBatchRowModel row) {
        FishingOperation fishingOperation = ((SpeciesBatchUIModel)this.getModel()).getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory<?> sampleCategory = row.getSampleCategory();
        Preconditions.checkNotNull(sampleCategory);
        Preconditions.checkNotNull((Object)((Object)sampleCategory.getCategoryType()));
        Preconditions.checkNotNull(sampleCategory.getCategoryValue());
        SpeciesBatch catchBean = (SpeciesBatch)row.toBean();
        catchBean.setFishingOperation(fishingOperation);
        SpeciesBatchRowModel parent = row.getParentBatch();
        if (parent != null) {
            catchBean.setParentBatch((SpeciesBatch)parent.toBean());
        }
        catchBean.setSampleCategoryType(sampleCategory.getCategoryType().getType());
        catchBean.setSampleCategoryValue((Serializable)sampleCategory.getCategoryValue());
        catchBean.setSampleCategoryWeight(sampleCategory.getCategoryWeight());
        if (TuttiEntities.isNew(catchBean)) {
            SpeciesBatchRowModel batchParent = row.getParentBatch();
            String parentBatchId = null;
            if (batchParent != null) {
                parentBatchId = batchParent.getId();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Persist new species batch with parentId: " + parentBatchId));
            }
            catchBean = this.persistenceService.createSpeciesBatch(catchBean, parentBatchId);
            row.setId(catchBean.getId());
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Persist existing species batch: " + catchBean.getId() + " (parent : " + catchBean.getParentBatch() + ")"));
            }
            this.persistenceService.saveSpeciesBatch(catchBean);
        }
        List<SpeciesFrequencyRowModel> frequencyRows = row.getFrequency();
        List frequency = SpeciesFrequencyRowModel.toBeans(frequencyRows, catchBean);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save " + frequency.size() + " frequencies."));
        }
        frequency = this.persistenceService.saveSpeciesBatchFrequency(catchBean.getId(), frequency);
        frequencyRows = SpeciesFrequencyRowModel.fromBeans(frequency);
        row.setFrequency(frequencyRows);
    }

    public String getFilterSpeciesBatchRootButtonText(int rootNumber) {
        return I18n._((String)"tutti.label.filterSpeciesBatchMode.mode.root", (Object[])new Object[]{rootNumber});
    }

    protected void recomputeBatchActionEnable() {
        int rowIndex = this.getTable().getSelectedRow();
        boolean enableAdd = true;
        boolean enableRename = false;
        boolean enableSplit = false;
        boolean enableRemove = false;
        boolean enableRemoveSub = false;
        boolean enableCreateMelag = false;
        if (rowIndex != -1) {
            SpeciesBatchTableModel tableModel = this.getTableModel();
            SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
            int selectedRowCount = this.getTable().getSelectedRowCount();
            if (row.isValid()) {
                enableSplit = true;
                enableRemove = true;
                enableRemoveSub = true;
                enableRename = true;
                enableCreateMelag = true;
            }
            if (enableSplit) {
                boolean bl = enableSplit = row.isBatchLeaf() && selectedRowCount == 1 && row.getComputedNumber() == null;
            }
            if (enableRename) {
                boolean bl = enableRename = row.isBatchRoot() && selectedRowCount == 1;
            }
            if (enableRemove) {
                boolean bl = enableRemove = selectedRowCount == 1;
            }
            if (enableRemoveSub) {
                boolean bl = enableRemoveSub = !row.isBatchLeaf() && selectedRowCount == 1;
            }
            if (enableCreateMelag) {
                JXTable table = this.getTable();
                if (selectedRowCount < 2) {
                    enableCreateMelag = false;
                } else {
                    int[] selectedRows;
                    for (int selectedRowIndex : selectedRows = table.getSelectedRows()) {
                        SpeciesBatchRowModel selectedRow = (SpeciesBatchRowModel)tableModel.getEntry(selectedRowIndex);
                        if (selectedRow.isBatchRoot()) continue;
                        enableCreateMelag = false;
                        break;
                    }
                }
            }
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setCreateSpeciesBatchEnabled(enableAdd);
        model.setSplitSpeciesBatchEnabled(enableSplit);
        model.setRemoveSpeciesBatchEnabled(enableRemove);
        model.setRemoveSpeciesSubBatchEnabled(enableRemoveSub);
        model.setRenameSpeciesBatchEnabled(enableRename);
        model.setCreateMelagEnabled(enableCreateMelag);
    }

    public void collectChilds(SpeciesBatchRowModel row, Set<SpeciesBatchRowModel> collectedRows) {
        if (!row.isBatchLeaf()) {
            for (SpeciesBatchRowModel batchChild : row.getChildBatch()) {
                collectedRows.add(batchChild);
                this.collectChilds(batchChild, collectedRows);
            }
        }
    }

    protected SpeciesBatchRowModel loadSpeciesBatch(SpeciesBatch aBatch, SpeciesBatchRowModel parentRow, List<SpeciesBatchRowModel> rows) {
        String id = aBatch.getId();
        List frequencies = this.persistenceService.getAllSpeciesBatchFrequency(id);
        List attachments = this.persistenceService.getAllAttachments(Integer.valueOf(id));
        SpeciesBatchRowModel newRow = new SpeciesBatchRowModel(aBatch, frequencies, attachments);
        SampleCategoryEnum sampleCategoryEnum = aBatch.getSampleCategoryType();
        Preconditions.checkNotNull((Object)sampleCategoryEnum, (Object)("Can't have a batch with no sample category, but was: " + aBatch));
        this.loadBatchRow(parentRow, newRow, sampleCategoryEnum, aBatch.getSampleCategoryValue(), aBatch.getSampleCategoryWeight());
        rows.add(newRow);
        if (!aBatch.isChildBatchsEmpty()) {
            ArrayList batchChilds = Lists.newArrayListWithCapacity((int)aBatch.sizeChildBatchs());
            for (SpeciesBatch childBatch : aBatch.getChildBatchs()) {
                SpeciesBatchRowModel childRow = this.loadSpeciesBatch(childBatch, newRow, rows);
                batchChilds.add(childRow);
            }
            newRow.setChildBatch(batchChilds);
        }
        return newRow;
    }

    protected void loadBatchRow(SpeciesBatchRowModel parentRow, SpeciesBatchRowModel newRow, SampleCategoryEnum sampleCategoryEnum, Serializable categoryValue, Float categoryWeight) {
        SampleCategory<?> sampleCategory = newRow.getSampleCategory(sampleCategoryEnum);
        sampleCategory.setCategoryValue(categoryValue);
        sampleCategory.setCategoryWeight(categoryWeight);
        newRow.setSampleCategory(sampleCategory);
        if (parentRow != null) {
            newRow.setSpecies(parentRow.getSpecies());
            newRow.setSpeciesToConfirm(parentRow.getSpeciesToConfirm());
            newRow.setParentBatch(parentRow);
            newRow.setSpecies(parentRow.getSpecies());
            if (sampleCategoryEnum != SampleCategoryEnum.sortedUnsorted) {
                newRow.setSortedUnsortedCategory(parentRow.getSortedUnsortedCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.size) {
                newRow.setSizeCategory(parentRow.getSizeCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.sex) {
                newRow.setSexCategory(parentRow.getSexCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.maturity) {
                newRow.setMaturityCategory(parentRow.getMaturityCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.age) {
                newRow.setAgeCategory(parentRow.getAgeCategory());
            }
        }
    }

    protected <C extends Serializable> void addSampleCategoryColumnToModel(TableColumnModel columnModel, ColumnIdentifier<SpeciesBatchRowModel> columnIdentifier, Decorator<C> decorator, TableCellRenderer defaultRenderer) {
        this.addColumnToModel(columnModel, SampleCategoryComponent.newEditor(decorator), SampleCategoryComponent.newRender(defaultRenderer, decorator, this.getConfig().getColorComputedWeights()), columnIdentifier);
    }

    public void removeFromSpeciesUsed(SpeciesBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        Preconditions.checkNotNull((Object)row.getSortedUnsortedCategoryValue());
        if (log.isInfoEnabled()) {
            log.info((Object)("Remove from speciesUsed: " + this.decorate(row.getSortedUnsortedCategoryValue()) + " - " + this.decorate(row.getSpecies())));
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.getSpeciesUsed().remove((Object)row.getSortedUnsortedCategoryValue(), (Object)row.getSpecies());
        if (row.isBatchRoot()) {
            model.setRootNumber(model.getRootNumber() - 1);
        }
    }

    protected void addToSpeciesUsed(SpeciesBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        Preconditions.checkNotNull((Object)row.getSortedUnsortedCategoryValue());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add to speciesUsed: " + this.decorate(row.getSortedUnsortedCategoryValue()) + " - " + this.decorate(row.getSpecies())));
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.getSpeciesUsed().put((Object)row.getSortedUnsortedCategoryValue(), (Object)row.getSpecies());
        model.setRootNumber(model.getRootNumber() + 1);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(this.ui);
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);
        this.openDialog(dialogContent, title, new Dimension(400, 130));
        return model.getSelectedSpecies();
    }
}

