package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental;

/*
 * #%L
 * Tutti :: UI
 * $Id: AccidentalBatchRowModel.java 512 2013-03-01 20:37:07Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/accidental/AccidentalBatchRowModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.List;

/**
 * Define a benthos batch row.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class AccidentalBatchRowModel extends AbstractTuttiBeanUIModel<AccidentalBatch, AccidentalBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_SPECIES = "species";

    public static final String PROPERTY_WEIGHT = "weight";

    public static final String PROPERTY_COMMENT = "comment";

    public static final String PROPERTY_ATTACHMENTS = "attachments";

    /**
     * Species observed.
     *
     * @since 0.2
     */
    protected Species species;

    /**
     * Observed weight.
     *
     * @since 0.2
     */
    protected Float weight;

    /**
     * Comment on this catches.
     *
     * @since 0.2
     */
    protected String comment;

    /**
     * Attachments
     *
     * @since 0.2
     */
    protected List<Attachment> attachments;

    protected static final Binder<AccidentalBatch, AccidentalBatchRowModel> fromBeanBinder =
            BinderFactory.newBinder(AccidentalBatch.class,
                                    AccidentalBatchRowModel.class);

    protected static final Binder<AccidentalBatchRowModel, AccidentalBatch> toBeanBinder =
            BinderFactory.newBinder(AccidentalBatchRowModel.class,
                                    AccidentalBatch.class);

    public AccidentalBatchRowModel() {
        super(AccidentalBatch.class, fromBeanBinder, toBeanBinder);
    }

    public AccidentalBatchRowModel(AccidentalBatch aBatch) {
        this();
        fromBean(aBatch);
    }

    public Species getSpecies() {
        return species;
    }

    public void setSpecies(Species species) {
        Object oldValue = getSpecies();
        this.species = species;
        firePropertyChange(PROPERTY_SPECIES, oldValue, species);
    }

    public Float getWeight() {
        return weight;
    }

    public void setWeight(Float weight) {
        Object oldValue = getWeight();
        this.weight = weight;
        firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        Object oldValue = getComment();
        this.comment = comment;
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public List<Attachment> getAttachments() {
        return attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        Object oldValue = getAttachments();
        this.attachments = attachments;
        firePropertyChange(PROPERTY_ATTACHMENTS, oldValue, attachments);
    }
}
