
package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: ComputeWeightsAction.java 572 2013-03-11 10:01:36Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/ComputeWeightsAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategory;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import org.apache.commons.collections.CollectionUtils;

import javax.swing.JOptionPane;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class ComputeWeightsAction extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {

    protected String errorMessage;

    public ComputeWeightsAction(EditCatchesUIHandler handler) {
        super(handler, false);
    }

    //FIXME Non, y'a des trucs qui vont pas du tout
    //FIXME  1) eviter de faire des repaint (surtout dans ce thread)
    //FIXME  2) pas gestion à la mimine des exceptions avec un new Exception(XXX) c moche :(
    //FIXME  3) le releaseAction c'est pas trop le moment pour envoyer des exception non plus :(

    @Override
    protected void doAction() throws Exception {
        EditCatchesUIModel model = getModel();

        computeSpeciesBatches();

        if (errorMessage == null) {
            Float speciesTotalSortedWeight = model.getSpeciesTotalSortedWeight();
            if (speciesTotalSortedWeight == null) {
                speciesTotalSortedWeight = model.getSpeciesTotalSortedComputedWeight();
            }
            Float speciesTotalUnsortedWeight = model.getSpeciesTotalUnsortedComputedWeight();

            model.setCatchTotalSortedComputedWeight(speciesTotalSortedWeight);
            model.setCatchTotalUnsortedComputedWeight(speciesTotalUnsortedWeight);

            Float totalWeight = model.getCatchTotalWeight();
            Float rejectedWeight = model.getCatchTotalRejectedWeight();

            if (rejectedWeight == null && totalWeight != null) {
                if (!totalWeight.equals(speciesTotalUnsortedWeight
                                        + speciesTotalSortedWeight)) {
                    errorMessage = _("tutti.action.computeWeights.error.incoherentTotal");

                } else {

                    model.setCatchTotalRejectedComputedWeight(totalWeight
                                                              - speciesTotalUnsortedWeight
                                                              - speciesTotalSortedWeight);
                }

            } else if (totalWeight == null) {
                if (rejectedWeight == null) {
                    rejectedWeight = 0f;
                    model.setCatchTotalRejectedComputedWeight(0f);
                }
                model.setCatchTotalComputedWeight(speciesTotalUnsortedWeight
                                                  + speciesTotalSortedWeight
                                                  + rejectedWeight);

            } else if (rejectedWeight != null
                       && !totalWeight.equals(speciesTotalUnsortedWeight
                                              + speciesTotalSortedWeight
                                              + rejectedWeight)) {
                errorMessage = _("tutti.action.computeWeights.error.incoherentTotal");
            }
        }

        if (errorMessage != null) {
            throw new TuttiBusinessException(errorMessage);
        }

    }

    //------------------------------------------------------------------------//
    //-- Internal methods                                                   --//
    //------------------------------------------------------------------------//

    protected void computeSpeciesBatches() {
        PersistenceService persistenceService =
                getContext().getPersistenceService();
        EditCatchesUIModel model = getModel();

        Float totalSortedWeight = 0f;
        Float totalUnsortedWeight = 0f;
        SpeciesBatchUI speciesUI = getUI().getSpeciesTabContent();
        EditCatchesUI ui = getUI();

        List<SpeciesBatchRowModel> roots = getUI().getSpeciesTabContent().getModel().getRows();
        for (int i = 0; i < roots.size(); i++) {
            SpeciesBatchRowModel row = roots.get(i);
            if (row.isBatchRoot()) {
                Float weight = computeSpeciesBatch(row);
                if (weight == null) {
                    errorMessage = _("tutti.action.computeWeights.error.noWeight");
                    AbstractSelectTableAction.doSelectCell(speciesUI.getTable(), i, 1);
                    break;
                }
                if (persistenceService.isSortedQualitativeValue(row.getSortedUnsortedCategory().getCategoryValue())) {
                    totalSortedWeight += weight;
                } else {
                    totalUnsortedWeight += weight;
                }
            }
        }

        if (errorMessage == null) {
            Number inertWeight = model.getSpeciesTotalInertWeight();
            if (inertWeight != null) {
                totalSortedWeight += inertWeight.floatValue();
            } else {
                model.setSpeciesTotalInertComputedWeight(0f);
            }

            Number livingNotItemizedWeight = model.getSpeciesTotalLivingNotItemizedWeight();
            if (livingNotItemizedWeight != null) {
                totalSortedWeight += livingNotItemizedWeight.floatValue();
            } else {
                model.setSpeciesTotalLivingNotItemizedComputedWeight(0f);
            }

            model.setSpeciesTotalSampleSortedComputedWeight(totalSortedWeight);

            Float speciesTotalSortedWeight = model.getSpeciesTotalSortedWeight();
            Float rate = getConfig().getDifferenceRateBetweenSortedAndTotalWeights();
            if (speciesTotalSortedWeight == null) {
                speciesTotalSortedWeight = totalSortedWeight;
                model.setSpeciesTotalSortedComputedWeight(totalSortedWeight);

            } else if (speciesTotalSortedWeight < totalSortedWeight) {
                errorMessage = _("tutti.action.computeWeights.error.incoherentSpeciesTotalSorted");

            } else if (speciesTotalSortedWeight < (1 + rate / 100) * totalSortedWeight) {
                // Si  le "Poids total VRAC" est saisi est que sa valeur
                // est supérieure de moins de x% (x en configuration)
                // du "Poids total Vrac trié", demander confirmation que
                // le "Poids total VRAC" est bien une valeur observée
                // sinon la remplacer par le "Poids total Vrac trié"
                int answer = JOptionPane.showConfirmDialog(getContext().getActionUI(),
                                                           _("tutti.action.computeWeights.replaceTotalSortedWeight.message", rate),
                                                           _("tutti.action.computeWeights.replaceTotalSortedWeight.title"),
                                                           JOptionPane.YES_NO_OPTION,
                                                           JOptionPane.QUESTION_MESSAGE);

                if (answer == JOptionPane.NO_OPTION) {
                    model.setSpeciesTotalSortedWeight(null);
                    speciesTotalSortedWeight = totalSortedWeight;
                    model.setSpeciesTotalSortedComputedWeight(totalSortedWeight);
                }
            }

            model.setSpeciesTotalUnsortedComputedWeight(totalUnsortedWeight);

            Float totalWeight = totalUnsortedWeight + speciesTotalSortedWeight;
            model.setSpeciesTotalComputedWeight(totalWeight);
        }

        speciesUI.getTable().repaint();
    }

    protected Float computeSpeciesBatch(SpeciesBatchRowModel row) {
        SampleCategory finestCategory = row.getFinestCategory();

        Float result = null;
        Float categoryWeight = finestCategory.getCategoryWeight();
        Float rowWeight = row.getWeight();

        List<SpeciesBatchRowModel> children = row.getChildBatch();
        // if the row is not a leaf
        if (!row.isBatchLeaf()) {
            Float sum = 0f;
            // make the sum of the children weights
            for (SpeciesBatchRowModel child : children) {
                Float weight = computeSpeciesBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum += weight;
            }

            if (sum != null) {
                if (categoryWeight == null) {
                    finestCategory.setComputedWeight(sum);
                    for (SpeciesBatchRowModel child : children) {
                        child.getFinestCategory().setSubSample(false);
                    }

                } else if (categoryWeight < sum) {
                    errorMessage = _("tutti.action.computeWeights.error.incoherentParentCategoryWeight");

                } else {
                    boolean subSample = categoryWeight > sum;
                    for (SpeciesBatchRowModel child : children) {
                        child.getFinestCategory().setSubSample(subSample);
                    }
                }
                result = sum;
            }

        } else {// the row is a leaf
            row.setComputedWeight(null);

            List<SpeciesFrequencyRowModel> frequency = row.getFrequency();

            if (CollectionUtils.isNotEmpty(frequency)) {
                // if there are frequencies, then compute their weight
                Float frequencyWeight = 0f;
                for (SpeciesFrequencyRowModel frequencyModel : frequency) {
                    Float w = frequencyModel.getWeight();
                    if (w == null) {

                        // can't sum when a null value appears
                        frequencyWeight = null;
                        break;

                    } else if (frequencyWeight != null) {

                        // still can sum weights
                        frequencyWeight += w;
                    }
                }

                if (categoryWeight == null && rowWeight != null) {
                    errorMessage = _("tutti.action.computeWeights.error.incoherentRowWeightCategory");

                } else if (categoryWeight == null && frequencyWeight != null) {
                    // if the category weight is null and the frequencies have a weight,
                    // then this weight is the result
                    finestCategory.setComputedWeight(frequencyWeight);
                    result = frequencyWeight;

                } else if (frequencyWeight != null
                           && !frequencyWeight.equals(categoryWeight)) {

                    // if the weight of the frequencies is different from the category
                    // weight, then set the weight of the sample
                    if (frequencyWeight > categoryWeight) {
                        errorMessage = _("tutti.action.computeWeights.error.incoherentCategoryWeight");

                    } else if (rowWeight == null) {
                        row.setComputedWeight(frequencyWeight);

                    } else if (!rowWeight.equals(frequencyWeight)) {
                        errorMessage = _("tutti.action.computeWeights.error.incoherentRowWeightFrequency");
                    }
                    result = categoryWeight;

                } else {
                    result = categoryWeight;
                }

            } else {
                result = categoryWeight;
            }
        }

        return result;
    }

//    @Override
//    protected void releaseAction() {
//        if (errorMessage != null) {
//            error = new Exception(errorMessage);
//        } else {
//            super.releaseAction();
//        }
//        errorMessage = null;
//    }

}
