package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.UpdateReferentialAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class DbManagerUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<TuttiUIContext, DbManagerUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLOSE_DB_BUTTON_ENABLED = "closeDbButton.enabled";
    public static final String BINDING_EXPORT_DB_BUTTON_ENABLED = "exportDbButton.enabled";
    public static final String BINDING_INFORMATION_LABEL_TEXT = "informationLabel.text";
    public static final String BINDING_NO_DB_ACTIONS_VISIBLE = "noDbActions.visible";
    public static final String BINDING_OPEN_DB_BUTTON_ENABLED = "openDbButton.enabled";
    public static final String BINDING_UPGRADE_DB_BUTTON_ENABLED = "upgradeDbButton.enabled";
    public static final String BINDING_WITH_DB_ACTIONS_VISIBLE = "withDbActions.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WzW/cRBSfbJvdfDZtvkhpUJMgIIHGi8ShQkGl6SZRtto0KB9S1RzKeD3JTvHOmPFs42IF8SfwJ8CdC1I5cUIcOHPggvgXEOLAteLN2GuvvV5v0nYPo/X4vd9783vv/cY//I0GXYEWn2DPM0SLSdokxv31hw93zSekLjeIWxfUkVyg4DdQQIUjNGpF+65Ebx/VlHs5dC9XeNPhjLAO77UaGnHlM5u4DUKkRG8lPequW96PXq95Tku0UaOkslC/+/efwrfWN98XEPIcyG4cjrLQzys+yeUaKlBLokmI9BSXbcxOIA1B2QnkO672KjZ23Qe4Sb5EX6NSDRUdLABMoqXzH1ljaH/PkeiaZe5ghk+IOODOZ5gRW6IPj4VBjwVpEmHIlpTUaFHDPYU8jDpnEmANyzQ22o6HVcfRgEWJSg3MLJsIiW5fFGQ78IyxBpvcUuks90Y6UI+H1YoC9GTsWjQF/0JlsdLHd5vYzj1tGztfpeyYiyaWlLMaNlUKk4p8L3S8rzeV8XDkM1qHAxEREpg015spc8Y3zPW6iqC33lTLXPR6gjJXYtveMO9BknA4NJVADHaV8Y3IZ/yUykYe6Bh3CGsjqr2balmIg7acE4EtkmNyhXgOFzLHYrxuczcTQqAbiUmAGTPiGYuHYOAIDYoWbEs0d9Q9lnvwKhjIudRAKkD99sXs1B8///V8q3MKZzJNO0QEpsMRwJCQVIWeCEawJald3sHO2hEadokNCqQVZj4jsf3wNSQH8a4pd0O5G9vYbQDEYOnPX36d/fz3S6iwhUZsjq0trOyraFg2BLDAbctzPr2rMxo7HYL1qsoN5uBxA7oUovpLuoXVkxGNraEel848YGQ+g5EoLXP4t/+m9n+822ZlALK83tM8ZmbwESpSZlNGtDqFwpOpRqOOS1oWjwUmS3JQluY44fSV9fpRFwuXYAIaXNCvYBawvW7TE9bUujfhB9NoVDYfHGzunUl0WSmBRHf8UImMlmNhSXaI60LEZa0pBnU3zE2PunJ55dZCvFWDqhBreWUFcEawnqSqEis02iEJXkvleFtTqP59jDIko9+BoKylp9Slpg29P+0vdqV1lhWmUzb6RShGVMwGwhecx4ikRaKhJiNNzmhdooFq6sQjod2qBYZjjzVEEFmiN/xqGyTYMuqqwEDaqOTcPqDOgQ68nNWu6TQMCddT1OOr2T3e5dRu+m6O0tp5oUpM+ecrRFJs+4UoQQjCMESAy32ms9jthov7dipRrECyk5XaTVWqpIyyyjTt72r33Bq9k0N3ED1ZoPdzCxR69K5O4hK6EG/Tfh5tyR6PbrIkc4cp5iYDaVgV5JiozyiK7S4Sb/qH2mgvtnnpno/SukjPx045PZ+6ul8jsdMJYsPbPUlrJUXrkLbK6sgZvxIA5FL4bg4bYQJJAj/IJbDt0pu+5EfLayRvJkFe++Mpyd5mir3hwCyLvll/M4TI5e+9HDLaOSQJvJVLYOTTm8HUh+E5NLdo42ccjNGVT2C88IJJmQXftne60AfUOtIXUW0/V8tP2QjXXxlh/pURFgHhf6mVBjzhDgAA";
    private static final Log log = LogFactory.getLog(DbManagerUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JPanel centerPanel;
    protected JButton closeDbButton;
    protected DbManagerUI dbManagerTopPanel = this;
    protected JButton exportDbButton;
    protected DbManagerUIHandler handler;
    protected JLabel informationLabel;
    protected JButton installDbButton;
    protected TuttiUIContext model;
    protected JPanel noDbActions;
    protected JButton openDbButton;
    protected JButton upgradeDbButton;
    protected JPanel withDbActions;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DbManagerUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                DbManagerUIHandler handler = new DbManagerUIHandler(parentUI.getHandler().getContext(), this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public DbManagerUI() {
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JPanel getCenterPanel() {
        return centerPanel;
    }

    public JButton getCloseDbButton() {
        return closeDbButton;
    }

    public JButton getExportDbButton() {
        return exportDbButton;
    }

    public DbManagerUIHandler getHandler() {
        return handler;
    }

    public JLabel getInformationLabel() {
        return informationLabel;
    }

    public JButton getInstallDbButton() {
        return installDbButton;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JPanel getNoDbActions() {
        return noDbActions;
    }

    public JButton getOpenDbButton() {
        return openDbButton;
    }

    public JButton getUpgradeDbButton() {
        return upgradeDbButton;
    }

    public JPanel getWithDbActions() {
        return withDbActions;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCenterPanel() {
        if (!allComponentsCreated) {
            return;
        }
        centerPanel.add(noDbActions, BorderLayout.CENTER);
        centerPanel.add(withDbActions, BorderLayout.SOUTH);
    }

    protected void addChildrenToDbManagerTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(informationLabel, BorderLayout.CENTER);
        add(centerPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToNoDbActions() {
        if (!allComponentsCreated) {
            return;
        }
        noDbActions.add(installDbButton);
    }

    protected void addChildrenToWithDbActions() {
        if (!allComponentsCreated) {
            return;
        }
        withDbActions.add(openDbButton);
        withDbActions.add(upgradeDbButton);
        withDbActions.add(exportDbButton);
        withDbActions.add(closeDbButton);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.dbManager.help"));
    }

    protected void createCenterPanel() {
        $objectMap.put("centerPanel", centerPanel = new JPanel());
        
        centerPanel.setName("centerPanel");
        centerPanel.setLayout(new BorderLayout());
    }

    protected void createCloseDbButton() {
        $objectMap.put("closeDbButton", closeDbButton = new JButton());
        
        closeDbButton.setName("closeDbButton");
        closeDbButton.setText(_("tutti.action.closeDb"));
        closeDbButton.setMnemonic(67);
        closeDbButton.setToolTipText(_("tuttihelp.dbManager.action.closeDb.tip"));
        closeDbButton.putClientProperty("help", "tuttihelp.dbManager.action.closeDb.help");
        closeDbButton.putClientProperty("tuttiAction", CloseDbAction.class);
    }

    protected void createExportDbButton() {
        $objectMap.put("exportDbButton", exportDbButton = new JButton());
        
        exportDbButton.setName("exportDbButton");
        exportDbButton.setText(_("tutti.action.exportDb"));
        exportDbButton.setMnemonic(69);
        exportDbButton.setToolTipText(_("tuttihelp.dbManager.action.exportDb.tip"));
        exportDbButton.putClientProperty("help", "tuttihelp.dbManager.action.exportDb.help");
        exportDbButton.putClientProperty("tuttiAction", ExportDbAction.class);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(DbManagerUIHandler.class));
    }

    protected void createInformationLabel() {
        $objectMap.put("informationLabel", informationLabel = new JLabel());
        
        informationLabel.setName("informationLabel");
    }

    protected void createInstallDbButton() {
        $objectMap.put("installDbButton", installDbButton = new JButton());
        
        installDbButton.setName("installDbButton");
        installDbButton.setText(_("tutti.action.installDb"));
        installDbButton.setMnemonic(73);
        installDbButton.setToolTipText(_("tuttihelp.dbManager.action.installDb.tip"));
        installDbButton.putClientProperty("help", "tuttihelp.dbManager.action.installDb.help");
        installDbButton.putClientProperty("tuttiAction", InstallDbAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createNoDbActions() {
        $objectMap.put("noDbActions", noDbActions = new JPanel());
        
        noDbActions.setName("noDbActions");
        noDbActions.setLayout(new GridLayout(0, 1));
    }

    protected void createOpenDbButton() {
        $objectMap.put("openDbButton", openDbButton = new JButton());
        
        openDbButton.setName("openDbButton");
        openDbButton.setText(_("tutti.action.openDb"));
        openDbButton.setMnemonic(79);
        openDbButton.setToolTipText(_("tuttihelp.dbManager.action.openDb.tip"));
        openDbButton.putClientProperty("help", "tuttihelp.dbManager.action.openDb.help");
        openDbButton.putClientProperty("tuttiAction", OpenDbAction.class);
    }

    protected void createUpgradeDbButton() {
        $objectMap.put("upgradeDbButton", upgradeDbButton = new JButton());
        
        upgradeDbButton.setName("upgradeDbButton");
        upgradeDbButton.setText(_("tutti.action.upgradeDb"));
        upgradeDbButton.setMnemonic(85);
        upgradeDbButton.setToolTipText(_("tuttihelp.dbManager.action.upgradeDb.tip"));
        upgradeDbButton.putClientProperty("help", "tuttihelp.dbManager.action.upgradeDb.help");
        upgradeDbButton.putClientProperty("tuttiAction", UpdateReferentialAction.class);
    }

    protected void createWithDbActions() {
        $objectMap.put("withDbActions", withDbActions = new JPanel());
        
        withDbActions.setName("withDbActions");
        withDbActions.setLayout(new GridLayout(0, 1));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDbManagerTopPanel();
        addChildrenToCenterPanel();
        addChildrenToNoDbActions();
        addChildrenToWithDbActions();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 11 property setters
        informationLabel.setHorizontalAlignment(JLabel.CENTER);
        informationLabel.setIcon(SwingUtil.createActionIcon("information"));
        installDbButton.setIcon(SwingUtil.createActionIcon("install-db"));
        openDbButton.setIcon(SwingUtil.createActionIcon("open-db"));
        upgradeDbButton.setIcon(SwingUtil.createActionIcon("update-referential"));
        exportDbButton.setIcon(SwingUtil.createActionIcon("export-db"));
        closeDbButton.setIcon(SwingUtil.createActionIcon("close-db"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, dbManagerTopPanel, "tuttihelp.dbManager.help");
        registerHelpId(_broker, installDbButton, "tuttihelp.dbManager.action.installDb.help");
        registerHelpId(_broker, openDbButton, "tuttihelp.dbManager.action.openDb.help");
        registerHelpId(_broker, upgradeDbButton, "tuttihelp.dbManager.action.upgradeDb.help");
        registerHelpId(_broker, exportDbButton, "tuttihelp.dbManager.action.exportDb.help");
        registerHelpId(_broker, closeDbButton, "tuttihelp.dbManager.action.closeDb.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("dbManagerTopPanel", dbManagerTopPanel);
        createHandler();
        createModel();
        createBroker();
        createInformationLabel();
        createCenterPanel();
        createNoDbActions();
        createInstallDbButton();
        createWithDbActions();
        createOpenDbButton();
        createUpgradeDbButton();
        createExportDbButton();
        createCloseDbButton();
        // inline creation of dbManagerTopPanel
        setName("dbManagerTopPanel");
        setLayout(new BorderLayout());
        dbManagerTopPanel.putClientProperty("help", "tuttihelp.dbManager.help");
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INFORMATION_LABEL_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    informationLabel.setText(_(handler.updateMessage(model.isDbExist(), model.isDbLoaded())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NO_DB_ACTIONS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    noDbActions.setVisible(!model.isDbExist());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WITH_DB_ACTIONS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    withDbActions.setVisible(model.isDbExist());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OPEN_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    openDbButton.setEnabled(!model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UPGRADE_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    upgradeDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLOSE_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    closeDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
    }

}