package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidatorMessageWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class MainUI extends JFrame implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<TuttiUIContext, MainUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUSY_BLOCK_LAYER_UI_BLOCK = "busyBlockLayerUI.block";
    public static final String BINDING_BUSY_BLOCK_LAYER_UI_BLOCKING_COLOR = "busyBlockLayerUI.blockingColor";
    public static final String BINDING_MENU_ACTIONS_ENABLED = "menuActions.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_CATCHES_ENABLED = "menuActionEditCatches.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_CRUISE_ENABLED = "menuActionEditCruise.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_PROGRAM_ENABLED = "menuActionEditProgram.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_PROTOCOL_ENABLED = "menuActionEditProtocol.enabled";
    public static final String BINDING_MENU_ACTION_MANAGE_DB_ENABLED = "menuActionManageDb.enabled";
    public static final String BINDING_MENU_ACTION_SELECT_CRUISE_ENABLED = "menuActionSelectCruise.enabled";
    public static final String BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED = "menuActionValidateCatches.enabled";
    public static final String BINDING_MENU_ADMINISTRATION_ENABLED = "menuAdministration.enabled";
    public static final String BINDING_MENU_CHANGE_LOCALE_FR_ENABLED = "menuChangeLocaleFR.enabled";
    public static final String BINDING_MENU_CHANGE_LOCALE_UK_ENABLED = "menuChangeLocaleUK.enabled";
    public static final String BINDING_MENU_IMPORT_TEMPORARY_REFERENTIAL_ENABLED = "menuImportTemporaryReferential.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(MainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTitledPanel body;
    protected JToolBar bottomBar;
    protected TuttiHelpBroker broker;
    protected BlockingLayerUI busyBlockLayerUI;
    protected MainUIHandler handler;
    protected MainUI mainFrame = this;
    protected JMenuBar menu;
    protected JMenuItem menuActionEditCatches;
    protected JMenuItem menuActionEditCruise;
    protected JMenuItem menuActionEditProgram;
    protected JMenuItem menuActionEditProtocol;
    protected JMenuItem menuActionManageDb;
    protected JMenuItem menuActionSelectCruise;
    protected JMenuItem menuActionUpdate;
    protected JMenuItem menuActionValidateCatches;
    protected JMenu menuActions;
    protected JMenu menuAdministration;
    protected JMenu menuChangeLocale;
    protected JMenuItem menuChangeLocaleFR;
    protected JMenuItem menuChangeLocaleUK;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileExit;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpSite;
    protected JMenuItem menuImportTemporaryReferential;
    protected JMenuItem menuShowHelp;
    protected TuttiUIContext model;
    protected JButton showHelp;
    protected StatusMessagePanel status;
    protected SwingValidatorMessageWidget validatorMessageWidget;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainUI(TuttiUIContext context) {
        setContextValue(context);
                MainUIHandler handler = new MainUIHandler(context, this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public MainUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI() {
        $initialize();
    }

    public MainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuFileConfiguration(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showConfig();
    }

    public void doActionPerformed__on__menuHelpAbout(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showAbout();
    }

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.gotoSite();
    }

    public void doActionPerformed__on__menuShowHelp(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showHelp();
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        menuFileExit.getAction().actionPerformed(null);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTitledPanel getBody() {
        return body;
    }

    public JToolBar getBottomBar() {
        return bottomBar;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public BlockingLayerUI getBusyBlockLayerUI() {
        return busyBlockLayerUI;
    }

    public MainUIHandler getHandler() {
        return handler;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenuItem getMenuActionEditCatches() {
        return menuActionEditCatches;
    }

    public JMenuItem getMenuActionEditCruise() {
        return menuActionEditCruise;
    }

    public JMenuItem getMenuActionEditProgram() {
        return menuActionEditProgram;
    }

    public JMenuItem getMenuActionEditProtocol() {
        return menuActionEditProtocol;
    }

    public JMenuItem getMenuActionManageDb() {
        return menuActionManageDb;
    }

    public JMenuItem getMenuActionSelectCruise() {
        return menuActionSelectCruise;
    }

    public JMenuItem getMenuActionUpdate() {
        return menuActionUpdate;
    }

    public JMenuItem getMenuActionValidateCatches() {
        return menuActionValidateCatches;
    }

    public JMenu getMenuActions() {
        return menuActions;
    }

    public JMenu getMenuAdministration() {
        return menuAdministration;
    }

    public JMenu getMenuChangeLocale() {
        return menuChangeLocale;
    }

    public JMenuItem getMenuChangeLocaleFR() {
        return menuChangeLocaleFR;
    }

    public JMenuItem getMenuChangeLocaleUK() {
        return menuChangeLocaleUK;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JMenuItem getMenuImportTemporaryReferential() {
        return menuImportTemporaryReferential;
    }

    public JMenuItem getMenuShowHelp() {
        return menuShowHelp;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JButton getShowHelp() {
        return showHelp;
    }

    public StatusMessagePanel getStatus() {
        return status;
    }

    public SwingValidatorMessageWidget getValidatorMessageWidget() {
        return validatorMessageWidget;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBottomBar() {
        if (!allComponentsCreated) {
            return;
        }
        bottomBar.add(validatorMessageWidget);
    }

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(bottomBar);
        add(showHelp);
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuActions);
        menu.add(menuAdministration);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuActions() {
        if (!allComponentsCreated) {
            return;
        }
        menuActions.add(menuActionSelectCruise);
        menuActions.add(menuActionEditProgram);
        menuActions.add(menuActionEditCruise);
        menuActions.add(menuActionEditProtocol);
        menuActions.add(menuActionEditCatches);
        menuActions.add(menuActionValidateCatches);
    }

    protected void addChildrenToMenuAdministration() {
        if (!allComponentsCreated) {
            return;
        }
        menuAdministration.add(menuImportTemporaryReferential);
    }

    protected void addChildrenToMenuChangeLocale() {
        if (!allComponentsCreated) {
            return;
        }
        menuChangeLocale.add(menuChangeLocaleUK);
        menuChangeLocale.add(menuChangeLocaleFR);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuActionUpdate);
        menuFile.add($JSeparator0);
        menuFile.add(menuActionManageDb);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuShowHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
        menuHelp.add(menuChangeLocale);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JXTitledPanel());
        
        body.setName("body");
        body.putClientProperty("help", "tuttihelp.main.help");
    }

    protected void createBottomBar() {
        $objectMap.put("bottomBar", bottomBar = new JToolBar());
        
        bottomBar.setName("bottomBar");
        bottomBar.setFloatable(false);
        bottomBar.setBorderPainted(false);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.main.help"));
    }

    protected void createBusyBlockLayerUI() {
        $objectMap.put("busyBlockLayerUI", busyBlockLayerUI = new BlockingLayerUI());
        
        busyBlockLayerUI.setUseIcon(false);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(MainUIHandler.class));
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuActionEditCatches() {
        $objectMap.put("menuActionEditCatches", menuActionEditCatches = new JMenuItem());
        
        menuActionEditCatches.setName("menuActionEditCatches");
        menuActionEditCatches.setText(_("tutti.action.editCatches"));
        menuActionEditCatches.setMnemonic(97);
        menuActionEditCatches.setToolTipText(_("tuttihelp.main.action.editCatches.tip"));
        menuActionEditCatches.putClientProperty("help", "tuttihelp.main.menu.action.editCatches.help");
        menuActionEditCatches.putClientProperty("tuttiAction", EditSelectedCruiseCatchesAction.class);
    }

    protected void createMenuActionEditCruise() {
        $objectMap.put("menuActionEditCruise", menuActionEditCruise = new JMenuItem());
        
        menuActionEditCruise.setName("menuActionEditCruise");
        menuActionEditCruise.setText(_("tutti.action.editSelectedCruise"));
        menuActionEditCruise.setMnemonic(67);
        menuActionEditCruise.setToolTipText(_("tuttihelp.main.action.editSelectedCruise.tip"));
        menuActionEditCruise.putClientProperty("help", "tuttihelp.main.menu.action.editCruise.help");
        menuActionEditCruise.putClientProperty("tuttiAction", EditSelectedCruiseAction.class);
    }

    protected void createMenuActionEditProgram() {
        $objectMap.put("menuActionEditProgram", menuActionEditProgram = new JMenuItem());
        
        menuActionEditProgram.setName("menuActionEditProgram");
        menuActionEditProgram.setText(_("tutti.action.editSelectedProgram"));
        menuActionEditProgram.setMnemonic(100);
        menuActionEditProgram.setToolTipText(_("tuttihelp.main.action.editProgram.tip"));
        menuActionEditProgram.putClientProperty("help", "tuttihelp.main.menu.action.editProgram.help");
        menuActionEditProgram.putClientProperty("tuttiAction", EditSelectedProgramAction.class);
    }

    protected void createMenuActionEditProtocol() {
        $objectMap.put("menuActionEditProtocol", menuActionEditProtocol = new JMenuItem());
        
        menuActionEditProtocol.setName("menuActionEditProtocol");
        menuActionEditProtocol.setText(_("tutti.action.editSelectedProtocol"));
        menuActionEditProtocol.setMnemonic(80);
        menuActionEditProtocol.setToolTipText(_("tuttihelp.main.action.editSelectedProtocol.tip"));
        menuActionEditProtocol.putClientProperty("help", "tuttihelp.main.menu.action.editProtocol.help");
        menuActionEditProtocol.putClientProperty("tuttiAction", EditSelectedProtocolAction.class);
    }

    protected void createMenuActionManageDb() {
        $objectMap.put("menuActionManageDb", menuActionManageDb = new JMenuItem());
        
        menuActionManageDb.setName("menuActionManageDb");
        menuActionManageDb.setText(_("tutti.action.manageDb"));
        menuActionManageDb.setMnemonic(68);
        menuActionManageDb.setToolTipText(_("tuttihelp.main.action.manageDb.tip"));
        menuActionManageDb.putClientProperty("help", "tuttihelp.main.menu.action.manageDb.help");
        menuActionManageDb.putClientProperty("tuttiAction", ManageDbAction.class);
    }

    protected void createMenuActionSelectCruise() {
        $objectMap.put("menuActionSelectCruise", menuActionSelectCruise = new JMenuItem());
        
        menuActionSelectCruise.setName("menuActionSelectCruise");
        menuActionSelectCruise.setText(_("tutti.action.selectCruise"));
        menuActionSelectCruise.setMnemonic(83);
        menuActionSelectCruise.setToolTipText(_("tuttihelp.main.action.selectCruise.tip"));
        menuActionSelectCruise.putClientProperty("help", "tuttihelp.main.menu.action.selectCruise.help");
        menuActionSelectCruise.putClientProperty("tuttiAction", SelectCruiseAction.class);
    }

    protected void createMenuActionUpdate() {
        $objectMap.put("menuActionUpdate", menuActionUpdate = new JMenuItem());
        
        menuActionUpdate.setName("menuActionUpdate");
        menuActionUpdate.setText(_("tutti.action.updateApplication"));
        menuActionUpdate.setMnemonic(77);
        menuActionUpdate.setToolTipText(_("tuttihelp.main.action.updateApplication.tip"));
        menuActionUpdate.putClientProperty("help", "tuttihelp.main.menu.action.updateApplication.help");
        menuActionUpdate.putClientProperty("tuttiAction", UpdateApplicationAction.class);
    }

    protected void createMenuActionValidateCatches() {
        $objectMap.put("menuActionValidateCatches", menuActionValidateCatches = new JMenuItem());
        
        menuActionValidateCatches.setName("menuActionValidateCatches");
        menuActionValidateCatches.setText(_("tutti.action.validateCatches"));
        menuActionValidateCatches.setMnemonic(86);
        menuActionValidateCatches.setToolTipText(_("tuttihelp.main.action.validateCatches.tip"));
        menuActionValidateCatches.putClientProperty("help", "tuttihelp.main.menu.action.validateCatches.help");
        menuActionValidateCatches.putClientProperty("tuttiAction", ValidateSelectedCruiseCatchesAction.class);
    }

    protected void createMenuActions() {
        $objectMap.put("menuActions", menuActions = new JMenu());
        
        menuActions.setName("menuActions");
        menuActions.setText(_("tutti.menu.actions"));
        menuActions.setMnemonic(65);
        menuActions.setToolTipText(_("tuttihelp.main.action.actions.tip"));
    }

    protected void createMenuAdministration() {
        $objectMap.put("menuAdministration", menuAdministration = new JMenu());
        
        menuAdministration.setName("menuAdministration");
        menuAdministration.setText(_("tutti.menu.administration"));
        menuAdministration.setMnemonic(65);
        menuAdministration.setToolTipText(_("tuttihelp.main.action.administration.tip"));
    }

    protected void createMenuChangeLocale() {
        $objectMap.put("menuChangeLocale", menuChangeLocale = new JMenu());
        
        menuChangeLocale.setName("menuChangeLocale");
        menuChangeLocale.setText(_("tutti.menu.changeLocale"));
        menuChangeLocale.setMnemonic(65);
        menuChangeLocale.setToolTipText(_("tuttihelp.main.action.changeLocale.tip"));
        menuChangeLocale.putClientProperty("help", "tuttihelp.main.action.changeLocale.help");
    }

    protected void createMenuChangeLocaleFR() {
        $objectMap.put("menuChangeLocaleFR", menuChangeLocaleFR = new JMenuItem());
        
        menuChangeLocaleFR.setName("menuChangeLocaleFR");
        menuChangeLocaleFR.setText(_("tutti.action.changeLocaleFR"));
        menuChangeLocaleFR.setMnemonic(70);
        menuChangeLocaleFR.setToolTipText(_("tuttihelp.main.action.changeLocaleFR.tip"));
        menuChangeLocaleFR.putClientProperty("help", "tuttihelp.main.action.changeLocaleFR.help");
        menuChangeLocaleFR.putClientProperty("tuttiAction", ChangeToLocaleFRAction.class);
    }

    protected void createMenuChangeLocaleUK() {
        $objectMap.put("menuChangeLocaleUK", menuChangeLocaleUK = new JMenuItem());
        
        menuChangeLocaleUK.setName("menuChangeLocaleUK");
        menuChangeLocaleUK.setText(_("tutti.action.changeLocaleUK"));
        menuChangeLocaleUK.setMnemonic(110);
        menuChangeLocaleUK.setToolTipText(_("tuttihelp.main.action.changeLocaleUK.tip"));
        menuChangeLocaleUK.putClientProperty("help", "tuttihelp.main.action.changeLocaleUK.help");
        menuChangeLocaleUK.putClientProperty("tuttiAction", ChangeToLocaleUKAction.class);
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("tutti.menu.file"));
        menuFile.setMnemonic(70);
        menuFile.setToolTipText(_("tuttihelp.main.action.file.tip"));
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("tutti.action.configuration"));
        menuFileConfiguration.setMnemonic(67);
        menuFileConfiguration.setToolTipText(_("tuttihelp.main.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", "tuttihelp.main.menu.action.configuration.help");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("tutti.action.exit"));
        menuFileExit.setMnemonic(81);
        menuFileExit.setToolTipText(_("tuttihelp.main.action.exit.tip"));
        menuFileExit.putClientProperty("help", "tuttihelp.main.menu.action.exit.help");
        menuFileExit.putClientProperty("tuttiAction", CloseApplicationAction.class);
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("tutti.menu.help"));
        menuHelp.setMnemonic(69);
        menuHelp.setToolTipText(_("tuttihelp.main.action.help.tip"));
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("tutti.action.about"));
        menuHelpAbout.setMnemonic(65);
        menuHelpAbout.setToolTipText(_("tuttihelp.main.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", "tuttihelp.main.menu.action.about.help");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("tutti.action.site"));
        menuHelpSite.setMnemonic(83);
        menuHelpSite.setToolTipText(_("tuttihelp.main.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "tuttihelp.main.menu.action.site.help");
    }

    protected void createMenuImportTemporaryReferential() {
        $objectMap.put("menuImportTemporaryReferential", menuImportTemporaryReferential = new JMenuItem());
        
        menuImportTemporaryReferential.setName("menuImportTemporaryReferential");
        menuImportTemporaryReferential.setText(_("tutti.action.importTemporaryReferential"));
        menuImportTemporaryReferential.setMnemonic(73);
        menuImportTemporaryReferential.setToolTipText(_("tuttihelp.main.action.importTemporaryReferential.tip"));
        menuImportTemporaryReferential.putClientProperty("help", "tuttihelp.main.menu.action.importTemporaryReferential.help");
        menuImportTemporaryReferential.putClientProperty("tuttiAction", ImportTemporaryReferentialAction.class);
    }

    protected void createMenuShowHelp() {
        $objectMap.put("menuShowHelp", menuShowHelp = new JMenuItem());
        
        menuShowHelp.setName("menuShowHelp");
        menuShowHelp.setText(_("tutti.action.showHelp"));
        menuShowHelp.setMnemonic(101);
        menuShowHelp.setToolTipText(_("tuttihelp.main.action.showHelp.tip"));
        menuShowHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuShowHelp"));
        menuShowHelp.putClientProperty("help", "tuttihelp.main.action.showHelp.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createShowHelp() {
        $objectMap.put("showHelp", showHelp = new JButton());
        
        showHelp.setName("showHelp");
        showHelp.setToolTipText(_("tuttihelp.main.action.showHelp.tip"));
        showHelp.putClientProperty("help", "tuttihelp.main.menu.action.showHelp.help");
    }

    protected void createStatus() {
        $objectMap.put("status", status = new StatusMessagePanel());
        
        status.setName("status");
    }

    protected void createValidatorMessageWidget() {
        $objectMap.put("validatorMessageWidget", validatorMessageWidget = new SwingValidatorMessageWidget());
        
        validatorMessageWidget.setName("validatorMessageWidget");
        validatorMessageWidget.setFocusPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuActions();
        addChildrenToMenuAdministration();
        addChildrenToMenuHelp();
        addChildrenToMenuChangeLocale();
        addChildrenToBottomBar();
        
        // apply 14 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 20 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuActionUpdate.setIcon(SwingUtil.createActionIcon("update-application"));
        menuActionManageDb.setIcon(SwingUtil.createActionIcon("manage-db"));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        menuActionSelectCruise.setIcon(SwingUtil.createActionIcon("home"));
        menuActionEditProgram.setIcon(SwingUtil.createActionIcon("program"));
        menuActionEditCruise.setIcon(SwingUtil.createActionIcon("cruise"));
        menuActionEditProtocol.setIcon(SwingUtil.createActionIcon("protocol"));
        menuActionEditCatches.setIcon(SwingUtil.createActionIcon("edit"));
        menuActionValidateCatches.setIcon(SwingUtil.createActionIcon("validate"));
        menuImportTemporaryReferential.setIcon(SwingUtil.createActionIcon("temporary-referential-import"));
        menuShowHelp.setIcon(SwingUtil.createActionIcon("help"));
        menuHelpSite.setIcon(SwingUtil.createActionIcon("site"));
        menuHelpAbout.setIcon(SwingUtil.createActionIcon("about"));
        menuChangeLocale.setIcon(SwingUtil.createActionIcon("translate"));
        menuChangeLocaleUK.setIcon(SwingUtil.createActionIcon("i18n-uk"));
        menuChangeLocaleFR.setIcon(SwingUtil.createActionIcon("i18n-fr"));
        bottomBar.setMargin(new java.awt.Insets(0, 0, 0, 5));
        showHelp.setIcon(SwingUtil.createActionIcon("show-help"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, menuFileConfiguration, "tuttihelp.main.menu.action.configuration.help");
        registerHelpId(_broker, menuActionUpdate, "tuttihelp.main.menu.action.updateApplication.help");
        registerHelpId(_broker, menuActionManageDb, "tuttihelp.main.menu.action.manageDb.help");
        registerHelpId(_broker, menuFileExit, "tuttihelp.main.menu.action.exit.help");
        registerHelpId(_broker, menuActionSelectCruise, "tuttihelp.main.menu.action.selectCruise.help");
        registerHelpId(_broker, menuActionEditProgram, "tuttihelp.main.menu.action.editProgram.help");
        registerHelpId(_broker, menuActionEditCruise, "tuttihelp.main.menu.action.editCruise.help");
        registerHelpId(_broker, menuActionEditProtocol, "tuttihelp.main.menu.action.editProtocol.help");
        registerHelpId(_broker, menuActionEditCatches, "tuttihelp.main.menu.action.editCatches.help");
        registerHelpId(_broker, menuActionValidateCatches, "tuttihelp.main.menu.action.validateCatches.help");
        registerHelpId(_broker, menuImportTemporaryReferential, "tuttihelp.main.menu.action.importTemporaryReferential.help");
        registerHelpId(_broker, menuShowHelp, "tuttihelp.main.action.showHelp.help");
        registerHelpId(_broker, menuHelpSite, "tuttihelp.main.menu.action.site.help");
        registerHelpId(_broker, menuHelpAbout, "tuttihelp.main.menu.action.about.help");
        registerHelpId(_broker, menuChangeLocale, "tuttihelp.main.action.changeLocale.help");
        registerHelpId(_broker, menuChangeLocaleUK, "tuttihelp.main.action.changeLocaleUK.help");
        registerHelpId(_broker, menuChangeLocaleFR, "tuttihelp.main.action.changeLocaleFR.help");
        registerHelpId(_broker, showHelp, "tuttihelp.main.menu.action.showHelp.help");
        registerHelpId(_broker, body, "tuttihelp.main.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainFrame", mainFrame);
        createModel();
        createHandler();
        createBroker();
        createBusyBlockLayerUI();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuActionUpdate();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuActionManageDb();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuActions();
        createMenuActionSelectCruise();
        createMenuActionEditProgram();
        createMenuActionEditCruise();
        createMenuActionEditProtocol();
        createMenuActionEditCatches();
        createMenuActionValidateCatches();
        createMenuAdministration();
        createMenuImportTemporaryReferential();
        createMenuHelp();
        createMenuShowHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createMenuChangeLocale();
        createMenuChangeLocaleUK();
        createMenuChangeLocaleFR();
        createBottomBar();
        createValidatorMessageWidget();
        createShowHelp();
        createBody();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,600);
        SwingUtil.setComponentWidth(mainFrame,800);
        setTitle(_("tutti.application.name"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 14 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 14 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUSY_BLOCK_LAYER_UI_BLOCKING_COLOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("config", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getConfig() != null) {
                    busyBlockLayerUI.setBlockingColor(model.getConfig().getColorBlockingLayer());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("config", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUSY_BLOCK_LAYER_UI_BLOCK, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("busy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    busyBlockLayerUI.setBlock(model.isBusy());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("busy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_MANAGE_DB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionManageDb.setEnabled(model.getScreen() != TuttiScreen.MANAGE_DB);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTIONS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActions.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_SELECT_CRUISE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionSelectCruise.setEnabled(model.getScreen() != TuttiScreen.SELECT_CRUISE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_PROGRAM_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("programFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditProgram.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROGRAM && model.isProgramFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("programFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_CRUISE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditCruise.setEnabled(model.getScreen() != TuttiScreen.EDIT_CRUISE && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_PROTOCOL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("protocolFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditProtocol.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROTOCOL && model.isProtocolFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("protocolFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("validationContext", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditCatches.setEnabled((
                                  !TuttiUIContext.VALIDATION_CONTEXT_EDIT.equals(model.getValidationContext())
                                  || model.getScreen() != TuttiScreen.EDIT_FISHING_OPERATION
                                  ) && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("validationContext", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("validationContext", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionValidateCatches.setEnabled((
                      !TuttiUIContext.VALIDATION_CONTEXT_VALIDATE.equals(model.getValidationContext())
                      || model.getScreen() != TuttiScreen.EDIT_FISHING_OPERATION
                      ) && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("validationContext", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ADMINISTRATION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuAdministration.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_IMPORT_TEMPORARY_REFERENTIAL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuImportTemporaryReferential.setEnabled(model.getScreen() != TuttiScreen.IMPORT_TEMPORARY_REFERENTIAL);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_CHANGE_LOCALE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuChangeLocaleUK.setEnabled(!handler.acceptLocale(model.getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_CHANGE_LOCALE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuChangeLocaleFR.setEnabled(!handler.acceptLocale(model.getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("locale", this);
                }
            }
        });
    }

}