/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextCellComponent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class BenthosBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<BenthosBatchRowModel, BenthosBatchUIModel, BenthosBatchUI> {
    private static final Log log = LogFactory.getLog(BenthosBatchUIHandler.class);

    public BenthosBatchUIHandler(TuttiUI<?, ?> parentUi, BenthosBatchUI ui) {
        super(parentUi, ui, "speciesToConfirm", "species", "weight", "number", "sampleWeight", "comment");
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        BenthosBatchUIModel model = (BenthosBatchUIModel)((Object)this.getModel());
        if (empty) {
            rows = null;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Get benthos batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew((IdAware)bean)) {
                List catches = this.persistenceService.getAllRootBenthosBatch(bean.getId());
                for (SpeciesBatch aBatch : catches) {
                    BenthosBatchRowModel entry = new BenthosBatchRowModel(aBatch);
                    rows.add(entry);
                }
            }
        }
        model.setRows(rows);
    }

    public BenthosBatchTableModel getTableModel() {
        return (BenthosBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((BenthosBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(BenthosBatchRowModel row) {
        boolean result = row.getSpecies() != null && row.getWeight() != null;
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, BenthosBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<BenthosBatchRowModel> rowMonitor, BenthosBatchRowModel row) {
        if (row.isValid()) {
            if (rowMonitor.wasModified()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Row " + row + " was modified, will save it"));
                }
                this.saveRow(row);
                rowMonitor.clearModified();
            }
        } else {
            SpeciesBatch catchBean = (SpeciesBatch)row.toBean();
            if (!TuttiEntities.isNew((IdAware)catchBean)) {
                this.persistenceService.deleteBenthosBatch(catchBean.getId());
            }
        }
    }

    @Override
    public SwingValidator<BenthosBatchUIModel> getValidator() {
        return ((BenthosBatchUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("beforeInit: " + this.ui));
        }
        EditCatchesUIModel catchesUIModel = ((BenthosBatchUI)this.ui).getContextValue(EditCatchesUIModel.class);
        BenthosBatchUIModel model = new BenthosBatchUIModel(catchesUIModel);
        ((BenthosBatchUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        List allSpecies = this.persistenceService.getAllSpecies();
        Decorator<Species> decorator = this.getDecorator(Species.class, "byRefTaxCode");
        this.addComboDataColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.SPECIES_BY_CODE, decorator, allSpecies);
        decorator = this.getDecorator(Species.class, "byGenus");
        this.addComboDataColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.SPECIES_BY_GENUS_CODE, decorator, allSpecies);
        this.addFloatColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}\\.\\d{0,3}");
        this.addIntegerColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.NUMBER, "\\d{0,3}");
        this.addFloatColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.SAMPLE_WEIGHT, "\\d{0,6}|\\d{1,6}\\.\\d{0,3}");
        this.addColumnToModel((TableColumnModel)columnModel, LongTextCellComponent.newEditor(((BenthosBatchUI)this.ui).getLongTextEditor()), LongTextCellComponent.newRender(I18n.n_((String)"tutti.tooltip.comment.none", (Object[])new Object[0])), BenthosBatchTableModel.COMMENT);
        AttachmentCellRenderer renderer = AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null), I18n.n_((String)"tutti.tooltip.attachment.none", (Object[])new Object[0]));
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(this.ui, renderer, AttachementObjectTypeEnum.SAMPLE), renderer, BenthosBatchTableModel.ATTACHMENT);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, BenthosBatchTableModel.SPECIES_TO_CONFIRM, (JTable)this.getTable());
        BenthosBatchTableModel tableModel = new BenthosBatchTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModel)columnModel, tableModel);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
    }

    protected void saveRow(BenthosBatchRowModel row) {
        SpeciesBatch catchBean = (SpeciesBatch)row.toBean();
        FishingOperation fishingOperation = ((BenthosBatchUIModel)((Object)this.getModel())).getFishingOperation();
        catchBean.setFishingOperation(fishingOperation);
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected fishingOperation: " + fishingOperation.getId()));
        }
        if (TuttiEntities.isNew((IdAware)catchBean)) {
            BenthosBatchRowModel batchParent = row.getParentBatch();
            String parentBatchId = null;
            if (batchParent != null) {
                parentBatchId = batchParent.getId();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Persist new benthos batch with parentId: " + parentBatchId));
            }
            catchBean = this.persistenceService.createBenthosBatch(catchBean, parentBatchId);
            row.setId(catchBean.getId());
        } else {
            this.persistenceService.saveBenthosBatch(catchBean);
        }
    }
}

