/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.KeyStroke;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.collections.EnumerationUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.RecursiveProperties;
import org.nuiton.util.SortedProperties;
import org.nuiton.util.StringUtil;
import org.nuiton.util.Version;
import org.nuiton.util.converter.ConverterUtil;

@Deprecated
public class ApplicationConfig {
    private static Log log = LogFactory.getLog(ApplicationConfig.class);
    private static final String CLASS_METHOD_SEPARATOR = "#";
    public static final String LIST_SEPARATOR = ",";
    public static final String CONFIG_FILE_NAME = "config.file";
    public static final String CONFIG_ENCODING = "config.encoding";
    public static final String APP_NAME = "app.name";
    public static final String ADJUSTING_PROPERTY = "adjusting";
    public static final String CONFIG_PATH = "config.path";
    protected String osName;
    protected boolean useOnlyAliases;
    @Deprecated
    protected String userPath = ApplicationConfig.getUserHome() + File.separator + ".";
    protected boolean inParseOptionPhase;
    protected Properties defaults = new Properties();
    protected Properties classpath = new Properties(this.defaults);
    protected Properties etcfile = new Properties(this.classpath);
    protected Properties homefile = new Properties(this.etcfile);
    protected Properties curfile = new Properties(this.homefile);
    protected Properties env = new Properties(this.curfile){

        @Override
        public synchronized Object get(Object key) {
            Object result = super.get(key);
            if (result == null && key instanceof String) {
                String skey = (String)key;
                skey = skey.replace(".", "_");
                result = super.get(skey);
            }
            return result;
        }

        @Override
        public String getProperty(String key) {
            Object oval = this.get(key);
            String sval = oval instanceof String ? (String)oval : null;
            return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
        }
    };
    protected Properties jvm = new Properties(this.env);
    protected Properties line = new Properties(this.jvm);
    protected Properties options = new Properties(this.line);
    protected Map<String, CacheItem<?>> cacheOption = new HashMap();
    protected Map<Class<?>, Object> cacheAction = new HashMap();
    protected List<String> unparsed = new ArrayList<String>();
    protected Map<String, List<String>> aliases = new HashMap<String, List<String>>();
    protected Map<Integer, List<Action>> actions = new HashMap<Integer, List<Action>>();
    private boolean adjusting;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected transient Map<String, Object> context = new HashMap<String, Object>();
    private final PropertyChangeListener saveUserAction = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (ApplicationConfig.this.isAdjusting()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Skip save while adjusting");
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving configuration fired by property [" + evt.getPropertyName() + "] at " + new Date()));
            }
            ApplicationConfig.this.saveForUser(new String[0]);
        }
    };

    public ApplicationConfig() {
        this(null, null);
    }

    public ApplicationConfig(String configFilename) {
        this(null, configFilename);
    }

    public ApplicationConfig(Properties defaults) {
        this(defaults, null);
    }

    public ApplicationConfig(Properties defaults, String configFilename) {
        this.init(defaults, configFilename);
    }

    protected void init(Properties defaults, String configFilename) {
        if (defaults != null) {
            for (String key : defaults.stringPropertyNames()) {
                this.setDefaultOption(key, defaults.getProperty(key));
            }
        }
        this.setEncoding("UTF-8");
        if (configFilename == null) {
            this.setConfigFileName(this.getClass().getSimpleName());
        } else {
            this.setDefaultOption(CONFIG_FILE_NAME, configFilename);
        }
        ConverterUtil.initConverters();
        this.osName = System.getProperty("os.name");
    }

    @Deprecated
    public <O extends OptionDef, A extends ActionDef> ApplicationConfig(Class<O> optionClass, Class<A> actionClass, Properties defaults, String configFilename) {
        this(defaults, configFilename);
        if (optionClass != null) {
            this.loadDefaultOptions(optionClass);
        }
        if (actionClass != null) {
            this.loadActions(actionClass);
        }
    }

    public static String getUserHome() {
        String result = System.getProperty("user.home");
        return result;
    }

    public String getUsername() {
        String result = this.getOption("user.name");
        return result;
    }

    public String getOsName() {
        String result = this.getOption("os.name");
        return result;
    }

    public String getOsArch() {
        String result = this.getOption("os.arch");
        return result;
    }

    @Deprecated
    public <O extends OptionDef> void loadDefaultOptions(Class<O> optionClass) {
        this.loadDefaultOptions((OptionDef[])optionClass.getEnumConstants());
    }

    public <O extends OptionDef> void loadDefaultOptions(O[] options) {
        for (O o : options) {
            if (o.getDefaultValue() == null) continue;
            this.setDefaultOption(o.getKey(), o.getDefaultValue());
        }
    }

    @Deprecated
    public <A extends ActionDef> void loadActions(Class<A> actionClass) {
        this.loadActions((ActionDef[])actionClass.getEnumConstants());
    }

    public <A extends ActionDef> void loadActions(A[] actions) {
        for (A a : actions) {
            for (String alias : a.getAliases()) {
                this.addActionAlias(alias, a.getAction());
            }
        }
    }

    public void setDefaultOption(String key, String value) {
        this.defaults.setProperty(key, value);
    }

    public void save(File file, boolean forceAll, String ... excludeKeys) throws IOException {
        SortedProperties prop = new SortedProperties();
        if (forceAll) {
            prop.putAll((Map<?, ?>)this.defaults);
            prop.putAll((Map<?, ?>)this.classpath);
        }
        prop.putAll((Map<?, ?>)this.etcfile);
        prop.putAll((Map<?, ?>)this.homefile);
        prop.putAll((Map<?, ?>)this.curfile);
        if (forceAll) {
            prop.putAll((Map<?, ?>)this.jvm);
            prop.putAll((Map<?, ?>)this.env);
            prop.putAll((Map<?, ?>)this.line);
        }
        prop.putAll((Map<?, ?>)this.options);
        for (String excludeKey : excludeKeys) {
            prop.remove(excludeKey);
        }
        boolean dirCreated = FileUtil.createDirectoryIfNecessary(file.getParentFile());
        if (dirCreated && log.isDebugEnabled()) {
            log.debug((Object)("Creation of config directory " + file.getParent()));
        }
        this.saveResource(file, prop, "Last saved " + new Date());
    }

    public void saveForSystem(String ... excludeKeys) {
        block3: {
            File file = this.getSystemConfigFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("will save system configuration in " + file));
            }
            try {
                this.save(file, false, excludeKeys);
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)I18n._((String)"nuitonutil.error.applicationconfig.save", (Object[])new Object[]{file}), (Throwable)eee);
            }
        }
    }

    public void saveForUser(String ... excludeKeys) {
        block3: {
            File file = this.getUserConfigFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("will save user configuration in " + file));
            }
            try {
                this.save(file, false, excludeKeys);
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)I18n._((String)"nuitonutil.error.applicationconfig.save", (Object[])new Object[]{file}), (Throwable)eee);
            }
        }
    }

    public void cleanUserConfig(String ... excludeKeys) {
        HashSet<String> keys = new HashSet<String>(this.homefile.stringPropertyNames());
        List<String> toExclude = Arrays.asList(excludeKeys);
        for (String key : keys) {
            String property;
            if (toExclude.contains(key) || !StringUtils.isBlank((CharSequence)(property = this.homefile.getProperty(key)))) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)("Remove blank property: " + key));
            }
            this.homefile.remove(key);
        }
        this.saveForUser(excludeKeys);
    }

    public File getSystemConfigFile() {
        File file = new File(this.getConfigPath(), this.getConfigFileName());
        return file;
    }

    public File getUserConfigFile() {
        return new File(this.getUserConfigDirectory(), this.getConfigFileName());
    }

    public List<String> getUnparsed() {
        return this.unparsed;
    }

    public void addAction(Action action) {
        if (action != null) {
            Integer step = action.step;
            List<Action> list = this.actions.get(step);
            if (list == null) {
                list = new LinkedList<Action>();
                this.actions.put(step, list);
            }
            list.add(action);
        }
    }

    public List<Integer> getActionStep() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.actions.keySet());
        Collections.sort(result);
        return result;
    }

    public void doAllAction() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        for (int step : this.getActionStep()) {
            this.doAction(step);
        }
    }

    public void doAction(int step) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        List<Action> list = this.actions.get(step);
        if (list != null) {
            for (Action a : list) {
                a.doAction();
            }
        }
    }

    public void setUseOnlyAliases(boolean useOnlyAliases) {
        this.useOnlyAliases = useOnlyAliases;
    }

    public boolean isUseOnlyAliases() {
        return this.useOnlyAliases;
    }

    public String getEncoding() {
        return this.getOption(this.getEncodingOption());
    }

    public void setEncoding(String encoding) {
        this.setDefaultOption(this.getEncodingOption(), encoding);
    }

    public void addAlias(String alias, String ... target) {
        this.aliases.put(alias, Arrays.asList(target));
    }

    public void addActionAlias(String alias, String actionMethod) {
        this.addAlias(alias, "--" + actionMethod);
    }

    public void setConfigFileName(String name) {
        this.setDefaultOption(this.getConfigFileNameOption(), name);
    }

    public String getConfigFileName() {
        String result = this.getOption(this.getConfigFileNameOption());
        return result;
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public void setAdjusting(boolean adjusting) {
        boolean oldvalue = this.adjusting;
        this.adjusting = adjusting;
        this.firePropertyChange(ADJUSTING_PROPERTY, oldvalue, adjusting);
    }

    protected String getConfigFileNameOption() {
        String optionName = CONFIG_FILE_NAME;
        if (this.getOption(APP_NAME) != null) {
            optionName = this.getOption(APP_NAME) + "." + optionName;
        }
        return optionName;
    }

    protected String getEncodingOption() {
        String optionName = CONFIG_ENCODING;
        if (this.getOption(APP_NAME) != null) {
            optionName = this.getOption(APP_NAME) + "." + optionName;
        }
        return optionName;
    }

    public void setAppName(String appName) {
        this.setDefaultOption(APP_NAME, appName);
    }

    public String getConfigPath() {
        String appName = this.getOption(APP_NAME) != null ? this.getOption(APP_NAME) + "." : "";
        String result = this.getOption(appName + CONFIG_PATH);
        if (result == null) {
            result = this.getSystemConfigurationPath();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuration path used : " + result));
        }
        return result;
    }

    protected String getSystemConfigurationPath() {
        String systemPath;
        block12: {
            systemPath = null;
            if (this.osName.toLowerCase().contains("windows")) {
                block11: {
                    try {
                        String systemDirectory = System.getenv("SystemDirectory");
                        if (systemDirectory != null && systemDirectory.length() > 0) {
                            systemPath = systemDirectory;
                        }
                    }
                    catch (SecurityException eee) {
                        if (!log.isErrorEnabled()) break block11;
                        log.error((Object)"Can't read env property", (Throwable)eee);
                    }
                }
                if (systemPath != null) {
                    try {
                        String systemRoot = System.getenv("SystemRoot");
                        if (systemRoot != null && systemRoot.length() > 0) {
                            systemPath = systemRoot + "\\System32";
                        }
                        break block12;
                    }
                    catch (SecurityException eee) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Can't read env property", (Throwable)eee);
                        }
                        break block12;
                    }
                }
                systemPath = "C:\\Windows\\System32";
            } else {
                systemPath = File.separator + "etc" + File.separator;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)systemPath);
        }
        return systemPath;
    }

    public String getUserConfigDirectory() {
        String userPath = null;
        String userHome = null;
        try {
            userHome = ApplicationConfig.getUserHome();
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        if (userHome != null) {
            if (this.osName.toLowerCase().contains("windows")) {
                try {
                    String appDataEV = System.getenv("APPDATA");
                    if (appDataEV != null && appDataEV.length() > 0) {
                        userPath = appDataEV;
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (userPath == null || userPath.isEmpty()) {
                    userPath = userHome + File.separator + "Application Data";
                }
            } else {
                userPath = this.osName.toLowerCase().contains("mac os x") ? userHome + File.separator + "/Library/Application Support" : userHome + "/.config";
            }
        }
        return userPath;
    }

    public boolean hasOption(String key) {
        boolean result = this.options.getProperty(key) != null;
        return result;
    }

    public boolean hasOption(OptionDef key) {
        boolean result = this.hasOption(key.getKey());
        return result;
    }

    public void putObject(Object o) {
        this.putObject(o.getClass().getName(), o);
    }

    public void putObject(String name, Object o) {
        this.context.put(name, o);
    }

    public <E> E getObject(Class<E> clazz) {
        E result = this.getObject(clazz, clazz.getName());
        return result;
    }

    public <E> E getObject(Class<E> clazz, String name) {
        E result = clazz.cast(this.context.get(name));
        if (result == null) {
            result = ObjectUtil.newInstance(clazz, Collections.singleton(this), true);
            this.putObject(name, result);
        }
        return result;
    }

    public Object getOptionAsObject(String key) {
        Object result = null;
        if (this.hasOption(key)) {
            Class<?> clazz = this.getOptionAsClass(key);
            result = ObjectUtil.newInstance(clazz, Collections.singleton(this), true);
        }
        return result;
    }

    public <E> E getOptionAsObject(Class<E> clazz, String key) {
        E result = clazz.cast(this.getOptionAsObject(key));
        return result;
    }

    public Object getOptionAsSingleton(String key) {
        Object result = this.context.get(key);
        if (result == null) {
            result = this.getOptionAsObject(key);
            this.putObject(key, result);
        }
        return result;
    }

    public <E> E getOptionAsSingleton(Class<E> clazz, String key) {
        E result = clazz.cast(this.getOptionAsSingleton(key));
        return result;
    }

    public void setOption(String key, String value) {
        if (this.inParseOptionPhase) {
            this.line.setProperty(key, value);
        } else {
            this.options.setProperty(key, value);
        }
    }

    public String getOption(String key) {
        String value = this.options.getProperty(key);
        value = this.replaceRecursiveOptions(value);
        return value;
    }

    protected String replaceRecursiveOptions(String option) {
        String result = option;
        if (result == null) {
            return null;
        }
        int pos = result.indexOf("${", 0);
        while (pos != -1) {
            int posEnd = result.indexOf("}", pos + 1);
            if (posEnd == -1) continue;
            String value = this.getOption(result.substring(pos + 2, posEnd));
            if (value != null) {
                result = result.substring(0, pos) + value + result.substring(posEnd + 1);
                pos = result.indexOf("${", pos + value.length());
                continue;
            }
            pos = result.indexOf("${", posEnd + 1);
        }
        return result;
    }

    public SubApplicationConfig getSubConfig(String prefix) {
        SubApplicationConfig result = new SubApplicationConfig(this, prefix);
        return result;
    }

    public Properties getOptionStartsWith(String prefix) {
        Properties result = new Properties();
        for (String key : this.options.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            result.setProperty(key, this.options.getProperty(key));
        }
        return result;
    }

    public Object getOption(OptionDef key) {
        Object result = this.getOption(key.getType(), key.getKey());
        return result;
    }

    public <T> T getOption(Class<T> clazz, String key) {
        String value = this.getOption(key);
        Object result = null;
        if (value != null) {
            result = this.convertOption(clazz, key, value, false);
        }
        return (T)result;
    }

    protected <T> Object convertOption(Class<T> clazz, String key, String value, boolean asList) {
        CacheItem<Object> cacheItem;
        String cacheKey = key + "-" + asList + "-" + clazz.getName();
        int hash = 0;
        if (value != null) {
            hash = value.hashCode();
        }
        if ((cacheItem = this.cacheOption.get(cacheKey)) == null || cacheItem.hash != hash) {
            if (asList) {
                ArrayList<T> list = new ArrayList<T>();
                if (value != null) {
                    String[] values;
                    for (String valueString : values = StringUtil.split(value, LIST_SEPARATOR)) {
                        T v = ConverterUtil.convert(clazz, valueString);
                        list.add(v);
                    }
                }
                cacheItem = new CacheItem(list, hash);
            } else {
                T v = ConverterUtil.convert(clazz, value);
                cacheItem = new CacheItem<T>(v, hash);
            }
            this.cacheOption.put(cacheKey, cacheItem);
        }
        Object result = cacheItem.item;
        return result;
    }

    public OptionList getOptionAsList(String key) {
        String value = this.getOption(key);
        OptionList result = new OptionList(this, key, value);
        return result;
    }

    public File getOptionAsFile(String key) {
        File result = this.getOption(File.class, key);
        if (result != null) {
            result = result.getAbsoluteFile();
        }
        return result;
    }

    public Color getOptionAsColor(String key) {
        Color color = this.getOption(Color.class, key);
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getOptionAsProperties(String key) throws IOException {
        File file = this.getOptionAsFile(key);
        RecursiveProperties prop = new RecursiveProperties();
        FileReader reader = new FileReader(file);
        try {
            prop.load(reader);
        }
        finally {
            reader.close();
        }
        return prop;
    }

    public URL getOptionAsURL(String key) {
        URL result = this.getOption(URL.class, key);
        return result;
    }

    public Class<?> getOptionAsClass(String key) {
        Class result = this.getOption(Class.class, key);
        return result;
    }

    public Date getOptionAsDate(String key) {
        Date result = this.getOption(Date.class, key);
        return result;
    }

    public Time getOptionAsTime(String key) {
        Time result = this.getOption(Time.class, key);
        return result;
    }

    public Timestamp getOptionAsTimestamp(String key) {
        Timestamp result = this.getOption(Timestamp.class, key);
        return result;
    }

    public int getOptionAsInt(String key) {
        Integer result = this.getOption(Integer.class, key);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public long getOptionAsLong(String key) {
        Long result = this.getOption(Long.class, key);
        if (result == null) {
            result = 0L;
        }
        return result;
    }

    public float getOptionAsFloat(String key) {
        Float result = this.getOption(Float.class, key);
        if (result == null) {
            result = Float.valueOf(0.0f);
        }
        return result.floatValue();
    }

    public double getOptionAsDouble(String key) {
        Double result = this.getOption(Double.class, key);
        if (result == null) {
            result = 0.0;
        }
        return result;
    }

    public boolean getOptionAsBoolean(String key) {
        Boolean result = this.getOption(Boolean.class, key);
        if (result == null) {
            result = false;
        }
        return result;
    }

    public Locale getOptionAsLocale(String key) {
        Locale result = this.getOption(Locale.class, key);
        return result;
    }

    public Version getOptionAsVersion(String key) {
        Version result = this.getOption(Version.class, key);
        return result;
    }

    public KeyStroke getOptionAsKeyStroke(String key) {
        KeyStroke result = this.getOption(KeyStroke.class, key);
        return result;
    }

    public Properties getOptions() {
        return this.options;
    }

    public void setOptions(Properties options) {
        this.options = options;
    }

    public Properties getFlatOptions() {
        return this.getFlatOptions(true);
    }

    public Properties getFlatOptions(boolean replaceInner) {
        Properties props = new Properties();
        for (String propertyKey : this.options.stringPropertyNames()) {
            String propertyValue = replaceInner ? this.getOption(propertyKey) : this.options.getProperty(propertyKey);
            props.setProperty(propertyKey, propertyValue);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installSaveUserAction(String ... properties) {
        this.setAdjusting(true);
        try {
            for (String propertyKey : properties) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("register saveUserAction on property [" + propertyKey + ']'));
                }
                this.addPropertyChangeListener(propertyKey, this.saveUserAction);
            }
        }
        finally {
            this.setAdjusting(false);
        }
    }

    protected Map<String, Method> getMethods() {
        Method[] allMethods = this.getClass().getMethods();
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method m : allMethods) {
            String methodName = m.getName();
            if (!methodName.startsWith("set")) continue;
            methodName = methodName.substring(3).toLowerCase();
            methods.put(methodName, m);
        }
        return methods;
    }

    protected String[] getParams(Method m, ListIterator<String> args) {
        ArrayList<String> result = new ArrayList<String>();
        if (m.isVarArgs()) {
            while (args.hasNext()) {
                String p = args.next();
                if (p.startsWith("--")) {
                    args.previous();
                    break;
                }
                result.add(p);
                args.remove();
            }
        } else {
            int paramLenght = m.getParameterTypes().length;
            for (int i = 0; i < paramLenght; ++i) {
                String p = args.next();
                args.remove();
                result.add(p);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected Action createAction(String name, ListIterator<String> args) throws ArgumentsParserException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Action result = null;
        List<Method> methods = ObjectUtil.getMethod(name, true);
        Class<?> clazz = null;
        Method method = null;
        if (methods.size() > 0) {
            if (methods.size() > 1) {
                log.warn((Object)String.format("More than one method found, used the first: %s", methods));
            }
            method = methods.get(0);
            clazz = method.getDeclaringClass();
        }
        if (method != null) {
            args.remove();
            Object o = this.cacheAction.get(clazz);
            if (o == null && !Modifier.isStatic(method.getModifiers())) {
                try {
                    o = ConstructorUtils.invokeConstructor(clazz, (Object)this);
                }
                catch (NoSuchMethodException eee) {
                    log.debug((Object)String.format("Use default constructor, because no constructor with Config parameter on class %s", clazz.getName()));
                    o = clazz.newInstance();
                }
                this.cacheAction.put(clazz, o);
            }
            int step = 0;
            Action.Step annotation = method.getAnnotation(Action.Step.class);
            if (annotation != null) {
                step = annotation.value();
            }
            String[] params = this.getParams(method, args);
            result = new Action(step, o, method, params);
        }
        return result;
    }

    public ApplicationConfig parse(String ... args) throws ArgumentsParserException {
        if (args == null) {
            args = ArrayUtils.EMPTY_STRING_ARRAY;
        }
        try {
            String arg;
            String arg2;
            Map<String, Method> methods = this.getMethods();
            ArrayList<String> arguments = new ArrayList<String>(args.length);
            for (String arg3 : args) {
                if (this.aliases.containsKey(arg3)) {
                    arguments.addAll((Collection)this.aliases.get(arg3));
                    continue;
                }
                arguments.add(arg3);
            }
            this.inParseOptionPhase = true;
            ListIterator<String> i = arguments.listIterator();
            while (i.hasNext() && !(arg2 = (String)i.next()).equals("--")) {
                String optionName;
                if (!arg2.startsWith("--") || !methods.containsKey(optionName = arg2.substring(2))) continue;
                i.remove();
                Method m = methods.get(optionName);
                Object[] params = this.getParams(m, i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Set option '%s' with method '%s %s'", optionName, m, Arrays.toString(params)));
                }
                ObjectUtil.call(this, m, (String[])params);
            }
            this.inParseOptionPhase = false;
            this.jvm.putAll((Map<?, ?>)System.getProperties());
            this.env.putAll(System.getenv());
            String filename = this.getConfigFileName();
            Enumeration<URL> enumInClasspath = ClassLoader.getSystemClassLoader().getResources(filename);
            HashSet urlsInClasspath = new HashSet(EnumerationUtils.toList(enumInClasspath));
            enumInClasspath = ApplicationConfig.class.getClassLoader().getResources(filename);
            urlsInClasspath.addAll(EnumerationUtils.toList(enumInClasspath));
            if (log.isDebugEnabled() && urlsInClasspath.isEmpty()) {
                log.debug((Object)("No configuration file found in classpath : /" + filename));
            }
            for (URL inClasspath : urlsInClasspath) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loading configuration file (classpath) : " + inClasspath));
                }
                this.loadResource(inClasspath.toURI(), this.classpath);
            }
            File etcConfig = this.getSystemConfigFile();
            if (etcConfig.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loading configuration file (etc) : " + etcConfig));
                }
                this.loadResource(etcConfig.toURI(), this.etcfile);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No configuration file found in system : " + etcConfig.getAbsolutePath()));
            }
            File homeConfig = this.getUserConfigFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("User configuration file : " + homeConfig));
            }
            File oldHomeConfig = new File(this.userPath + filename);
            if (!homeConfig.exists() && oldHomeConfig.exists()) {
                this.migrateUserConfigurationFile(oldHomeConfig, homeConfig);
            }
            if (homeConfig.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loading configuration file (home) : " + homeConfig));
                }
                this.loadResource(homeConfig.toURI(), this.homefile);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No configuration file found in user home : " + homeConfig.getAbsolutePath()));
            }
            File config = new File(filename);
            if (config.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loading configuration file (curr) : " + config));
                }
                this.loadResource(config.toURI(), this.curfile);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No configuration file found in current directory : " + config.getAbsolutePath()));
            }
            ListIterator<String> i2 = arguments.listIterator();
            while (i2.hasNext() && !(arg = (String)i2.next()).equals("--")) {
                if (!arg.startsWith("--")) continue;
                String optionName = arg.substring(2);
                Action action = this.createAction(optionName, i2);
                this.addAction(action);
            }
            arguments.remove("--");
            this.unparsed.addAll(arguments);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)eee);
            }
            throw new ArgumentsParserException("Can't parse argument", eee);
        }
        return this;
    }

    protected void migrateUserConfigurationFile(File oldHomeConfig, File homeConfig) throws IOException {
        boolean b;
        if (log.isInfoEnabled()) {
            log.info((Object)I18n._((String)"nuitonutil.config.moving.conf", (Object[])new Object[]{oldHomeConfig.getPath(), homeConfig.getPath()}));
        }
        if (!(b = oldHomeConfig.renameTo(homeConfig))) {
            String message = String.format("could not move old configuration file %s to %s", oldHomeConfig, homeConfig);
            throw new IOException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadResource(URI uri, Properties properties) throws IOException {
        InputStreamReader reader = new InputStreamReader(uri.toURL().openStream(), this.getEncoding());
        try {
            properties.load(reader);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveResource(File file, Properties properties, String comment) throws IOException {
        OutputStreamWriter reader = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getEncoding());
        try {
            properties.store(reader, comment);
        }
        finally {
            ((Writer)reader).close();
        }
    }

    public void printConfig() {
        System.out.println("-------------------Value-------------------------");
        this.printConfig(System.out);
        System.out.println("-------------------------------------------------");
    }

    public void printConfig(PrintStream output) {
        output.println("defaults " + this.defaults);
        output.println("classpath " + this.classpath);
        output.println("etcfile " + this.etcfile);
        output.println("homefile " + this.homefile);
        output.println("curfile " + this.curfile);
        output.println("env " + this.env);
        output.println("jvm " + this.jvm);
        output.println("line " + this.line);
        output.println("options " + this.options);
    }

    public String getPrintableConfig(String includePattern, int padding) {
        String msg = "Configuration:\n";
        for (String key : this.getFlatOptions().stringPropertyNames()) {
            if (includePattern != null && !"".equals(includePattern) && !key.matches(includePattern)) continue;
            String value = this.getOption(key);
            msg = msg + String.format("\t%" + padding + "s = %s\n", key, value);
        }
        return msg;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public static class OptionList {
        protected ApplicationConfig config;
        protected String key;
        protected String value;

        public OptionList(ApplicationConfig config, String key, String value) {
            this.config = config;
            this.key = key;
            this.value = value;
        }

        protected <T> List<T> convertListOption(Class<T> type) {
            List result = (List)this.config.convertOption(type, this.key, this.value, true);
            return result;
        }

        public List<String> getOption() {
            List<String> result = this.convertListOption(String.class);
            return result;
        }

        public List<File> getOptionAsFile() {
            List<File> tmp = this.convertListOption(File.class);
            ArrayList<File> result = new ArrayList<File>(tmp.size());
            for (File file : tmp) {
                result.add(file.getAbsoluteFile());
            }
            return result;
        }

        public List<URL> getOptionAsURL() {
            List<URL> result = this.convertListOption(URL.class);
            return result;
        }

        public List<Class> getOptionAsClass() {
            List<Class> result = this.convertListOption(Class.class);
            return result;
        }

        public List<Date> getOptionAsDate() {
            List<Date> result = this.convertListOption(Date.class);
            return result;
        }

        public List<Time> getOptionAsTime() {
            List<Time> result = this.convertListOption(Time.class);
            return result;
        }

        public List<Timestamp> getOptionAsTimestamp() {
            List<Timestamp> result = this.convertListOption(Timestamp.class);
            return result;
        }

        public List<Integer> getOptionAsInt() {
            List<Integer> result = this.convertListOption(Integer.class);
            return result;
        }

        public List<Double> getOptionAsDouble() {
            List<Double> result = this.convertListOption(Double.class);
            return result;
        }

        public List<Boolean> getOptionAsBoolean() {
            List<Boolean> result = this.convertListOption(Boolean.class);
            return result;
        }
    }

    protected static class CacheItem<T> {
        public T item;
        public int hash;

        public CacheItem(T item, int hash) {
            this.item = item;
            this.hash = hash;
        }
    }

    public static class Action {
        protected int step;
        protected Object o;
        protected Method m;
        protected String[] params;

        public Action(int step, Object o, Method m, String ... params) {
            this.step = step;
            this.o = o;
            this.m = m;
            this.params = params;
        }

        public void doAction() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
            ObjectUtil.call(this.o, this.m, this.params);
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD})
        public static @interface Step {
            public int value() default 0;
        }
    }

    public static interface ActionDef
    extends Serializable {
        public String getAction();

        public String[] getAliases();
    }

    public static interface OptionDef
    extends Serializable {
        public String getKey();

        public Class<?> getType();

        public String getDescription();

        public String getDefaultValue();

        public boolean isTransient();

        public boolean isFinal();

        public void setDefaultValue(String var1);

        public void setTransient(boolean var1);

        public void setFinal(boolean var1);
    }

    public static class SubApplicationConfig
    extends ApplicationConfig {
        protected ApplicationConfig parent;
        protected String prefix;

        public SubApplicationConfig(ApplicationConfig parent, String prefix) {
            this.parent = parent;
            this.prefix = prefix;
        }

        @Override
        protected void init(Properties defaults, String configFilename) {
        }

        public ApplicationConfig getParent() {
            return this.parent;
        }

        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public Properties getOptions() {
            return this.getParent().getOptions();
        }

        @Override
        public void setDefaultOption(String key, String value) {
            this.getParent().setDefaultOption(this.getPrefix() + key, value);
        }

        @Override
        public boolean hasOption(String key) {
            boolean result = this.getOption(key) != null;
            return result;
        }

        @Override
        public void setOption(String key, String value) {
            this.getParent().setOption(this.getPrefix() + key, value);
        }

        @Override
        public String getOption(String key) {
            String result = this.getParent().getOption(this.getPrefix() + key);
            if (result == null) {
                result = this.getParent().getOption(key);
            }
            return result;
        }

        @Override
        public Properties getFlatOptions(boolean replaceInner) {
            Properties result = this.getParent().getFlatOptions(replaceInner);
            Properties tmp = new Properties();
            int lenght = this.getPrefix().length();
            for (Map.Entry<Object, Object> e : result.entrySet()) {
                String k = (String)e.getKey();
                if (!k.startsWith(this.getPrefix())) continue;
                k = k.substring(lenght);
                String v = (String)e.getValue();
                tmp.setProperty(k, v);
            }
            result.putAll((Map<?, ?>)tmp);
            return result;
        }

        @Override
        public Properties getOptionStartsWith(String prefix) {
            Properties result = this.getParent().getOptionStartsWith(prefix);
            Properties tmp = this.getParent().getOptionStartsWith(this.getPrefix() + prefix);
            int lenght = this.getPrefix().length();
            for (Map.Entry<Object, Object> e : tmp.entrySet()) {
                String k = (String)e.getKey();
                k = k.substring(lenght);
                String v = (String)e.getValue();
                result.setProperty(k, v);
            }
            return result;
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName.startsWith(this.getPrefix())) {
                propertyName = propertyName.substring(this.getPrefix().length());
                this.getParent().firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.getParent().addPropertyChangeListener(this.getPrefix() + propertyName, listener);
        }

        @Override
        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.getParent().removePropertyChangeListener(this.getPrefix() + propertyName, listener);
        }

        @Override
        public boolean hasListeners(String propertyName) {
            return this.getParent().hasListeners(this.getPrefix() + propertyName);
        }

        @Override
        public ApplicationConfig parse(String ... args) throws ArgumentsParserException {
            throw new UnsupportedOperationException("This method is not supported in SubApplicationConfig");
        }
    }
}

