/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential;

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.service.referential.TuttiReferentialImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportTemporarySpeciesAction
extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(ImportTemporarySpeciesAction.class);
    private File file;

    public ImportTemporarySpeciesAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, "import", I18n._((String)"tutti.action.importTemporarySpecies", (Object[])new Object[0]), I18n._((String)"tutti.action.importTemporarySpecies.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction() {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.importTemporarySpeciesFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseReferentialSpeciesFile", (Object[])new Object[0]), null, "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import species temporary referential from file: " + this.file));
        }
        TuttiReferentialImportExportService service = this.getContext().getTuttiReferentialImportExportService();
        service.importTemporarySpecies(this.file);
        this.getDataContext().resetSpecies();
        this.sendMessage("R\u00e9f\u00e9rentiel temporaire d'esp\u00e8ces import\u00e9 depuis le fichier " + this.file + ".");
    }
}

