/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.fishing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.CaracteristicRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.CaracteristicTabUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CaracteristicTabUIHandler<RM extends CaracteristicRowModel<RM>, M extends CaracteristicTabUIModel<RM, M>, TM extends AbstractTuttiTableModel<RM>, UI extends TuttiUI<M, ?>>
extends AbstractTuttiTableUIHandler<RM, M, UI> {
    private static final Log log = LogFactory.getLog(CaracteristicTabUIHandler.class);

    public CaracteristicTabUIHandler(EditFishingOperationUI parentUi, UI ui, String ... properties) {
        super(parentUi.getHandler().getContext(), ui, properties);
    }

    public TM getTableModel() {
        return (TM)((AbstractTuttiTableModel)this.getTable().getModel());
    }

    @Override
    protected boolean isRowValid(RM row) {
        return ((CaracteristicRowModel)row).getValue() != null;
    }

    @Override
    protected void onRowModified(int rowIndex, RM row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        super.onRowModified(rowIndex, row, propertyName, oldValue, newValue);
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<RM> rowMonitor, RM row) {
        if (((AbstractTuttiBeanUIModel)row).isValid() && rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + row + " was modified, will save it"));
            }
            this.saveRow(row);
        }
    }

    @Override
    public SwingValidator<M> getValidator() {
        return null;
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, RM oldRow, int newRowIndex, RM newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        ((CaracteristicTabUIModel)this.getModel()).setRemoveCaracteristicEnabled(newRow != null);
    }

    @Override
    public void beforeInitUI() {
        M model = this.createModel();
        this.getUI().setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI((TuttiUI)this.getUI());
        this.initBeanComboBox(this.getKeyCombo(), Lists.newArrayList(), null);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.getUI()));
        }
    }

    protected void saveRow(RM row) {
        if (((AbstractTuttiBeanUIModel)row).isValid()) {
            CaracteristicMap caracteristics = ((CaracteristicTabUIModel)this.getModel()).getCaracteristicMap();
            Preconditions.checkNotNull((Object)caracteristics);
            caracteristics.put(((CaracteristicRowModel)row).getKey(), ((CaracteristicRowModel)row).getValue());
        }
    }

    protected abstract M createModel();

    protected abstract BeanComboBox<Caracteristic> getKeyCombo();

    protected abstract CaracteristicMap getCaracteristics(FishingOperation var1);

    protected abstract List<String> getProtocolPmfmIds(TuttiProtocol var1);

    public void addRow() {
        BeanComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        Caracteristic selectedItem = (Caracteristic)keyCombo.getSelectedItem();
        TM tableModel = this.getTableModel();
        CaracteristicRowModel row = (CaracteristicRowModel)((AbstractTuttiTableModel)tableModel).createNewRow();
        row.setKey(selectedItem);
        ((CaracteristicTabUIModel)this.getModel()).getRows().add(row);
        int rowIndex = ((AbstractTuttiTableModel)tableModel).getRowCount() - 1;
        ((AbstractTableModel)tableModel).fireTableRowsInserted(rowIndex, rowIndex);
        keyCombo.getData().remove(selectedItem);
        this.selectFirstInCombo(keyCombo);
        CaracteristicTabUIModel model = (CaracteristicTabUIModel)this.getModel();
        model.setModify(true);
        this.recomputeRowValidState(row);
    }

    public void reset(FishingOperation fishingOperation) {
        List<String> protocolPmfmId;
        TM tableModel = this.getTableModel();
        CaracteristicTabUIModel model = (CaracteristicTabUIModel)this.getModel();
        CaracteristicMap caracteristicMap = this.getCaracteristics(fishingOperation);
        if (caracteristicMap == null) {
            caracteristicMap = new CaracteristicMap();
        }
        model.setCaracteristicMap(caracteristicMap);
        TuttiProtocol protocol = this.getDataContext().getProtocol();
        ArrayList pmfmIds = Lists.newArrayList();
        if (protocol != null && (protocolPmfmId = this.getProtocolPmfmIds(protocol)) != null) {
            pmfmIds.addAll(protocolPmfmId);
        }
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristics = Lists.newArrayList(caracteristicMap.keySet());
        List<Caracteristic> availableCaracteristics = model.getAvailableCaracteristics();
        for (String id : pmfmIds) {
            Caracteristic caracteristic = TuttiEntities.findById(availableCaracteristics, id);
            if (caracteristics.contains(caracteristic)) continue;
            caracteristics.add(caracteristic);
        }
        for (Caracteristic key : caracteristics) {
            CaracteristicRowModel newRow = (CaracteristicRowModel)((AbstractTuttiTableModel)tableModel).createNewRow();
            newRow.setKey(key);
            newRow.setValue((Serializable)caracteristicMap.get(key));
            rows.add(newRow);
        }
        model.setRows(rows);
        ArrayList caracteristicList = Lists.newArrayList();
        for (Caracteristic caracteristic : availableCaracteristics) {
            if (caracteristics.contains(caracteristic)) continue;
            caracteristicList.add(caracteristic);
        }
        BeanComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        keyCombo.setData((List)caracteristicList);
        this.selectFirstInCombo(keyCombo);
        model.setModify(false);
    }

    public void removeCaracteristic() {
        int rowIndex = this.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove caracteristic if no caracteristic selected");
        CaracteristicRowModel row = (CaracteristicRowModel)((AbstractTuttiTableModel)this.getTableModel()).getEntry(rowIndex);
        CaracteristicMap caracteristicMap = ((CaracteristicTabUIModel)this.getModel()).getCaracteristicMap();
        if (caracteristicMap != null) {
            caracteristicMap.remove(row.getKey());
        }
        BeanComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        keyCombo.addItem((Object)row.getKey());
        this.selectFirstInCombo(keyCombo);
        ((CaracteristicTabUIModel)this.getModel()).getRows().remove(rowIndex);
        ((AbstractTableModel)this.getTableModel()).fireTableRowsDeleted(rowIndex, rowIndex);
        ((CaracteristicTabUIModel)this.getModel()).removeRowInError(row);
    }
}

