/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.conversion;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.conversion.UnitConversion;
import fr.ifremer.adagio.core.dao.referential.conversion.UnitConversionDao;
import fr.ifremer.adagio.core.dao.referential.conversion.UnitConversionImpl;
import fr.ifremer.adagio.core.dao.referential.conversion.UnitConversionPK;
import fr.ifremer.adagio.core.dao.referential.pmfm.Unit;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class UnitConversionDaoBase
extends HibernateDaoSupport
implements UnitConversionDao {
    @Override
    public Object load(int transform, Unit fromUnit, Unit toUnit) {
        UnitConversionPK entityPk = new UnitConversionPK();
        if (fromUnit == null) {
            throw new IllegalArgumentException("UnitConversion.load - 'fromUnit' can not be null");
        }
        if (toUnit == null) {
            throw new IllegalArgumentException("UnitConversion.load - 'toUnit' can not be null");
        }
        entityPk.setFromUnit(fromUnit);
        entityPk.setToUnit(toUnit);
        Object entity = this.getHibernateTemplate().get(UnitConversionImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (UnitConversion)entity);
    }

    @Override
    public UnitConversion load(Unit fromUnit, Unit toUnit) {
        return (UnitConversion)this.load(0, fromUnit, toUnit);
    }

    @Override
    public Collection<UnitConversion> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(UnitConversionImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public UnitConversion create(UnitConversion unitConversion) {
        return (UnitConversion)this.create(0, unitConversion);
    }

    @Override
    public Object create(int transform, UnitConversion unitConversion) {
        if (unitConversion == null) {
            throw new IllegalArgumentException("UnitConversion.create - 'unitConversion' can not be null");
        }
        this.getHibernateTemplate().save((Object)unitConversion);
        return this.transformEntity(transform, unitConversion);
    }

    @Override
    public Collection<UnitConversion> create(Collection<UnitConversion> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<UnitConversion> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("UnitConversion.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    UnitConversionDaoBase.this.create(transform, (UnitConversion)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public UnitConversion create(Float conversionCoefficient, Timestamp updateDate, Unit fromUnit, Unit toUnit) {
        return (UnitConversion)this.create(0, conversionCoefficient, updateDate, fromUnit, toUnit);
    }

    @Override
    public Object create(int transform, Float conversionCoefficient, Timestamp updateDate, Unit fromUnit, Unit toUnit) {
        UnitConversionImpl entity = new UnitConversionImpl();
        UnitConversionPK entityPk = new UnitConversionPK();
        entity.setUnitConversionPk(entityPk);
        entity.setConversionCoefficient(conversionCoefficient);
        entity.setUpdateDate(updateDate);
        entityPk.setFromUnit(fromUnit);
        entityPk.setToUnit(toUnit);
        return this.create(transform, entity);
    }

    @Override
    public UnitConversion create(Float conversionCoefficient, Unit fromUnit, Unit toUnit) {
        return (UnitConversion)this.create(0, conversionCoefficient, fromUnit, toUnit);
    }

    @Override
    public Object create(int transform, Float conversionCoefficient, Unit fromUnit, Unit toUnit) {
        UnitConversionImpl entity = new UnitConversionImpl();
        UnitConversionPK entityPk = new UnitConversionPK();
        entity.setUnitConversionPk(entityPk);
        entity.setConversionCoefficient(conversionCoefficient);
        entityPk.setFromUnit(fromUnit);
        entityPk.setToUnit(toUnit);
        return this.create(transform, entity);
    }

    @Override
    public void update(UnitConversion unitConversion) {
        if (unitConversion == null) {
            throw new IllegalArgumentException("UnitConversion.update - 'unitConversion' can not be null");
        }
        this.getHibernateTemplate().update((Object)unitConversion);
    }

    @Override
    public void update(final Collection<UnitConversion> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("UnitConversion.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    UnitConversionDaoBase.this.update((UnitConversion)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(UnitConversion unitConversion) {
        if (unitConversion == null) {
            throw new IllegalArgumentException("UnitConversion.remove - 'unitConversion' can not be null");
        }
        this.getHibernateTemplate().delete((Object)unitConversion);
    }

    @Override
    public void remove(Unit fromUnit, Unit toUnit) {
        UnitConversionPK entityPk = new UnitConversionPK();
        if (fromUnit == null) {
            throw new IllegalArgumentException("UnitConversion.remove - 'fromUnit' can not be null");
        }
        entityPk.setFromUnit(fromUnit);
        if (toUnit == null) {
            throw new IllegalArgumentException("UnitConversion.remove - 'toUnit' can not be null");
        }
        entityPk.setToUnit(toUnit);
        UnitConversion entity = this.load(fromUnit, toUnit);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<UnitConversion> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("UnitConversion.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, UnitConversion entity) {
        UnitConversion target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected UnitConversion toEntity(Object[] row) {
        UnitConversion target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof UnitConversion)) continue;
                target = (UnitConversion)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), UnitConversionImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), UnitConversionImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<UnitConversion> search(Search search) {
        return this.search(0, search);
    }
}

