package fr.ifremer.tutti.ui.swing.util.attachment;

/*
 * #%L
 * Tutti :: UI
 * $Id: ButtonAttachmentEditor.java 534 2013-03-05 10:45:23Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/attachment/ButtonAttachmentEditor.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import jaxx.runtime.SwingUtil;
import org.jdesktop.beans.AbstractSerializableBean;

import javax.swing.JButton;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * To show attachment editor on a button.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.2
 */
public class ButtonAttachmentEditor extends AttachmentEditor {

    private static final long serialVersionUID = 1L;

    public static String getButtonText(List<Attachment> attachment) {
        return _("tutti.action.attachments", attachment.size());
    }

    public static ButtonAttachmentEditor newEditor(TuttiUI ui,
                                                   JButton button) {

        Frame frame = SwingUtil.getParentContainer(ui, Frame.class);

        return new ButtonAttachmentEditor(frame,
                                          button,
                                          (AttachmentModelAware) ui.getModel()
        );
    }

    protected final AttachmentModelAware model;

    protected ButtonAttachmentEditor(Frame owner,
                                     JButton component,
                                     AttachmentModelAware model) {
        super(owner,
              component,
              model.getObjectType(),
              null);
        this.model = model;
    }

    @Override
    protected AttachmentModelAware getBean() {
        return model;
    }

    protected JButton getComponent() {
        return (JButton) component;
    }

    public void init() {

        JButton button = getComponent();
        button.setIcon(SwingUtil.createActionIcon("edit-attachment"));
        button.setToolTipText(_("tutti.action.attachments.tip"));
        ((AbstractSerializableBean) model).addPropertyChangeListener(AttachmentModelAware.PROPERTY_ATTACHMENT, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List<Attachment> attachment = (List<Attachment>) evt.getNewValue();
                getComponent().setText(ButtonAttachmentEditor.getButtonText(attachment));
            }
        });
        AttachmentModelAware bean = getBean();
        List<Attachment> attachment = bean == null ? Collections.<Attachment>emptyList() : bean.getAttachment();
        button.setText(ButtonAttachmentEditor.getButtonText(attachment));
    }
}
