package fr.ifremer.tutti.ui.swing.content.operation.catches.plankton;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextEditorUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class PlanktonBatchUI extends JPanel implements TuttiUI<PlanktonBatchUIModel, PlanktonBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_PLANKTON_TOTAL_SAMPLE_WEIGHT_FIELD_MODEL = "planktonTotalSampleWeightField.model";
    public static final String BINDING_PLANKTON_TOTAL_WEIGHT_FIELD_MODEL = "planktonTotalWeightField.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRQemziJ06YpjQgpKShQUVIh1khI5ZAKmrhx67BJTdaFiBzC2Du2Nx3vLDNvm42sIP4E/gS4c0Hixglx4MyBC+JfQIgD14o3s7Z3lzhxKmLJq9XM+773a+Z7+92fpKAkef2ARpElQx+8LrM213Z3HzUOWBPuM9WUXgBCkviXy5P8HrnkDtcVkJt7toaX+vBSWXQD4TM/hV61yYyCI85UhzEA8moW0VSq5Ay3V6MglAPWYVCjWL/5+6/81+5X3+YJiQKMbhZTWR6HSjKZsEnec4FcQ09PaYlTv41hSM9vY7yzeq3MqVLbtMu+IF+SKZtMBlQiGZA3zp+y4TD4KABS7Iguq1GfcSB2S1peS7IukxaEAJ4VepY6RP9WU/iAdJYImKTgCd9qUmh2mLICDPMJ4EKt/7KuNx5Xg8A4mQQy1aG+y5kE4lykg4cxa+Kn0BWuTuPji/SypTkTH3NMSiHrtMHZVuztbqa/Tyn3XIrl7jt09POTweIWU4q2WQJPiItDJJC3n4MyYbjChd+uswg2XM/Q3Dm9DiF43GLGzrIzsMdVTVccsk60hOwCWcyEFJOYNLLWi4My1gVQ/inz2h2waUPX6Zo+v1EfumkWNWjpTGzFYxwvxK0R3vvRb4fdBpNx7Fm+1zJ8Du0GnKUi0lbL50WYOLTVzSxiDnQNnKYUnOtLBOTlTJrJTrZOBYMDsiRk2zpA9UKvQQyKrM3dYWVXAlSQpUz2qE1Wok2JeOT2SEGGuIyV3DspZzu4FQvZ4n+ETBOa3WcL87/9+McPlYF6TaHvl0aapsQXVSWQ+jqBp13PxdKlz1dpiware6SoGEflNsp8Y0RgTn8bg0N/L2p4fDwfUtVBisLU7z/9vPD5ry+QfIXMcEHdCtX2VVKEjsQqCO5GwYf3TESXD6fxeRX/E3h0G4z6KD89owvHeMdoCKImghB1r9Trq5LVZlAWfstrr9y2PLU2MEkfrJXbGo2uDneY0vNiAmSIxZ/TS8Z6He8Xagt59xRaBw3TjLE98kbYkRsjOjIsS6P4yz/zzvf3Bl3JYZWun2qedKbwGZn0fO75zEyV/sAYOUUuBYqFrkgGw6hRQbBol9Mp9JXnPfN8/0QD8kCmub5oFa1Fr/ROu93HupooP0DeikXKgE7ocgoWhdrjmqmFfiuTM4QnGBPmRDI3luODojtXO8lmzsCsbwpQowBMYrsXetXt+v6d/fvVB9W6s19bq9c3drbRcDpUrIKHFdMqtCjHQ0Om+/fkCMj8/8jKFG1cVtniL/fOFrakBe+MbUEaPCrkMar7HO24dUo70pwX2ZTrF5TnuRqEec7GwogfIfpTAMibPdtT4KQXueVUtx/YG/vOhr1RrlcfmSwU9jQeH4Ms5odU2G/WliL0cWrO9sqC44hct9fKHx2nrdZp88nAarLnh5wfj8oxnlLjUskhB6dHAk8OuXIXP0rocsPzXRxlH5wgzennDDL+C+AV23XoCwAA";
    private static final Log log = LogFactory.getLog(PlanktonBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SwingValidatorMessageTableModel errorTableModel;
    protected Table form;
    protected PlanktonBatchUIHandler handler;
    protected PlanktonBatchUI homePanel = this;
    protected LongTextEditorUI longTextEditor;
    protected PlanktonBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "planktonTotalSampleWeight",  editorName = "planktonTotalSampleWeightField")
    protected NumberEditor planktonTotalSampleWeightField;
    protected JLabel planktonTotalSampleWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "planktonTotalWeight",  editorName = "planktonTotalWeightField")
    protected NumberEditor planktonTotalWeightField;
    protected JLabel planktonTotalWeightLabel;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<PlanktonBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PlanktonBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            PlanktonBatchUIHandler handler = new PlanktonBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public PlanktonBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PlanktonBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PlanktonBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PlanktonBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PlanktonBatchUI() {
        $initialize();
    }

    public PlanktonBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PlanktonBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PlanktonBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusLost__on__table(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveSelectedRowIfRequired(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public Table getForm() {
        return form;
    }

    public PlanktonBatchUIHandler getHandler() {
        return handler;
    }

    public LongTextEditorUI getLongTextEditor() {
        return longTextEditor;
    }

    public PlanktonBatchUIModel getModel() {
        return model;
    }

    public NumberEditor getPlanktonTotalSampleWeightField() {
        return planktonTotalSampleWeightField;
    }

    public JLabel getPlanktonTotalSampleWeightLabel() {
        return planktonTotalSampleWeightLabel;
    }

    public NumberEditor getPlanktonTotalWeightField() {
        return planktonTotalWeightField;
    }

    public JLabel getPlanktonTotalWeightLabel() {
        return planktonTotalWeightLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<PlanktonBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(planktonTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(planktonTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(planktonTotalSampleWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(planktonTotalSampleWeightField), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(longTextEditor);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(PlanktonBatchUIHandler.class));
    }

    protected void createLongTextEditor() {
        $objectMap.put("longTextEditor", longTextEditor = new LongTextEditorUI());
        
        longTextEditor.setName("longTextEditor");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(PlanktonBatchUIModel.class));
    }

    protected void createPlanktonTotalSampleWeightField() {
        $objectMap.put("planktonTotalSampleWeightField", planktonTotalSampleWeightField = new NumberEditor(this));
        
        planktonTotalSampleWeightField.setName("planktonTotalSampleWeightField");
        planktonTotalSampleWeightField.setProperty("planktonTotalSampleWeight");
        planktonTotalSampleWeightField.setUseFloat(false);
        planktonTotalSampleWeightField.setShowReset(true);
    }

    protected void createPlanktonTotalSampleWeightLabel() {
        $objectMap.put("planktonTotalSampleWeightLabel", planktonTotalSampleWeightLabel = new JLabel());
        
        planktonTotalSampleWeightLabel.setName("planktonTotalSampleWeightLabel");
        planktonTotalSampleWeightLabel.setText(_("tutti.label.catches.planktonTotalSampleWeight"));
    }

    protected void createPlanktonTotalWeightField() {
        $objectMap.put("planktonTotalWeightField", planktonTotalWeightField = new NumberEditor(this));
        
        planktonTotalWeightField.setName("planktonTotalWeightField");
        planktonTotalWeightField.setProperty("planktonTotalWeight");
        planktonTotalWeightField.setUseFloat(false);
        planktonTotalWeightField.setShowReset(true);
    }

    protected void createPlanktonTotalWeightLabel() {
        $objectMap.put("planktonTotalWeightLabel", planktonTotalWeightLabel = new JLabel());
        
        planktonTotalWeightLabel.setName("planktonTotalWeightLabel");
        planktonTotalWeightLabel.setText(_("tutti.label.catches.planktonTotalWeight"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__table"));
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(PlanktonBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToForm();
        addChildrenToTableScrollPane();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        planktonTotalWeightLabel.setLabelFor(planktonTotalWeightField);
        planktonTotalWeightField.setBean(model);
        planktonTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        planktonTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
        planktonTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        planktonTotalSampleWeightLabel.setLabelFor(planktonTotalSampleWeightField);
        planktonTotalSampleWeightField.setBean(model);
        planktonTotalSampleWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        planktonTotalSampleWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
        planktonTotalSampleWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createLongTextEditor();
        createForm();
        createPlanktonTotalWeightLabel();
        createPlanktonTotalWeightField();
        createPlanktonTotalSampleWeightLabel();
        createPlanktonTotalSampleWeightField();
        createTableScrollPane();
        createTable();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PLANKTON_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("planktonTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    planktonTotalWeightField.setModel(model.getPlanktonTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("planktonTotalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PLANKTON_TOTAL_SAMPLE_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("planktonTotalSampleWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    planktonTotalSampleWeightField.setModel(model.getPlanktonTotalSampleWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("planktonTotalSampleWeight", this);
                }
            }
        });
    }

}