package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.UpdateReferentialAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class DbManagerUI extends JPanel implements TuttiUI<TuttiUIContext, DbManagerUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLOSE_DB_BUTTON_ENABLED = "closeDbButton.enabled";
    public static final String BINDING_EXPORT_DB_BUTTON_ENABLED = "exportDbButton.enabled";
    public static final String BINDING_INFORMATION_LABEL_TEXT = "informationLabel.text";
    public static final String BINDING_NO_DB_ACTIONS_VISIBLE = "noDbActions.visible";
    public static final String BINDING_OPEN_DB_BUTTON_ENABLED = "openDbButton.enabled";
    public static final String BINDING_UPGRADE_DB_BUTTON_ENABLED = "upgradeDbButton.enabled";
    public static final String BINDING_WITH_DB_ACTIONS_VISIBLE = "withDbActions.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVVzW8bRRR/duuk+W6bj6YihbRcEqla9wYiVWmwE9WV06J8SFV9KLPeiT3VenaYmW02XQXxJ/AnwJ0LEjdOiANnDlwQ/wJCHLgi3szaXn9sY0dVLXlkv3nv937v7fu9/f4vKCgJt1+SKHJkyDVrUefx9rNnT92XtK7LVNUlEzqQkHxyecjXYMbr2pWGD2tVE15shxdLQUsEnPKe6K0qTCt96lPVpFRruNUfUVeqeNC93opEKDuoXVJZqN/+83f+G+/r7/IAkUB2s1jK+qiotJLLVcgzT8N1zPSKFH3CG0hDMt5AvnPGVvKJUk9Ii34JX8FkFSYEkQim4c74JVsMGx8JDfM8KLtHlcNAfE449TXcO5YOO5a0RaWjQ62ZEzJHnSAJpx5wjZiO5zpld49w0qDyqCKERZvQMNkk3POp1PDRRUEeJZEpVqEVeIbOxpuRDs3fo0rJAEY6Db3K+HEgW0SzgFeJa1Cum+ZF7bjH1micp7oxM3XkRGW7B/3u1jjgbrq2XTcZrOmGOZa71wuMK018v+x+hhyRHyz2ISZW47zajZk7Ybp5HuhsICjvIBrbmjlupUlD0ZDEo+e4zNNIBFKf4zFX9wOVCSHhvb5JRo04qUbSIc7VoCBDNGtYrQ3Lah+vEkGtDgjKANrb/1YWf//pzx93e1W0nOnaswRwuoXEDknNTOqFREKhZn5xj4itGkwp6uMGsRtiLYPYQfsayWG+aybcMeHOI6KaCFGY/OPnX1a++O0S5Hdh2g+It0uMfwWmdFNiFwLfi8SnDy2j2ZMreF7F7yV89s1Astc4BcTf9lmDt6xiF+JkDp3SzpPDnf0zDZfNGGt4ELdl5ITCI5ruUaVQJBtWEA5TZXcnYkpvbN5dT01V5EO9jc1NxJkmdoYqRmkw0yOGCLu+ltH1bunu1K//Lh788LDT+Rx24uYb3dPuF57DBOM+49RusPZyytxYM0LR0AvSJZS1liBDxKIt8Lv2vDfU6Bzun1dMMdfHaVyKbw+16ywKTeTHti7z6xPoF/IYGWZf2B2UBGi4EVc6Qk9MTt1UkZlpcCdcqJ7FeLxy+pfIqBR5TEE5wQz40lnubVlnnM6GSl6Kn9o1NLLevnV1ISZL8ThEPoiPrDz26TE170CG6hr5DAZW5DugtRyXkg06kkz/qn0HVFbinfa6H8ll4MUwxmxO+OQ0QGeYv49Pgay7jHv4bnswhJ4z5/RIRGOOzHGajbDy1gg33xrhfUT4H27g5TqhCgAA";
    private static final Log log = LogFactory.getLog(DbManagerUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel centerPanel;
    protected JButton closeDbButton;
    protected JButton exportDbButton;
    protected DbManagerUIHandler handler;
    protected JLabel informationLabel;
    protected JButton installDbButton;
    protected TuttiUIContext model;
    protected JPanel noDbActions;
    protected DbManagerUI noDbUITopPanel = this;
    protected JButton openDbButton;
    protected JButton upgradeDbButton;
    protected JPanel withDbActions;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DbManagerUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                DbManagerUIHandler handler = new DbManagerUIHandler(parentUI.getHandler().getContext(), this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public DbManagerUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI() {
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getCenterPanel() {
        return centerPanel;
    }

    public JButton getCloseDbButton() {
        return closeDbButton;
    }

    public JButton getExportDbButton() {
        return exportDbButton;
    }

    public DbManagerUIHandler getHandler() {
        return handler;
    }

    public JLabel getInformationLabel() {
        return informationLabel;
    }

    public JButton getInstallDbButton() {
        return installDbButton;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JPanel getNoDbActions() {
        return noDbActions;
    }

    public JButton getOpenDbButton() {
        return openDbButton;
    }

    public JButton getUpgradeDbButton() {
        return upgradeDbButton;
    }

    public JPanel getWithDbActions() {
        return withDbActions;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCenterPanel() {
        if (!allComponentsCreated) {
            return;
        }
        centerPanel.add(noDbActions, BorderLayout.CENTER);
        centerPanel.add(withDbActions, BorderLayout.SOUTH);
    }

    protected void addChildrenToNoDbActions() {
        if (!allComponentsCreated) {
            return;
        }
        noDbActions.add(installDbButton);
    }

    protected void addChildrenToNoDbUITopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(informationLabel, BorderLayout.CENTER);
        add(centerPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToWithDbActions() {
        if (!allComponentsCreated) {
            return;
        }
        withDbActions.add(openDbButton);
        withDbActions.add(upgradeDbButton);
        withDbActions.add(exportDbButton);
        withDbActions.add(closeDbButton);
    }

    protected void createCenterPanel() {
        $objectMap.put("centerPanel", centerPanel = new JPanel());
        
        centerPanel.setName("centerPanel");
        centerPanel.setLayout(new BorderLayout());
    }

    protected void createCloseDbButton() {
        $objectMap.put("closeDbButton", closeDbButton = new JButton());
        
        closeDbButton.setName("closeDbButton");
        closeDbButton.putClientProperty("tuttiAction", CloseDbAction.class);
    }

    protected void createExportDbButton() {
        $objectMap.put("exportDbButton", exportDbButton = new JButton());
        
        exportDbButton.setName("exportDbButton");
        exportDbButton.putClientProperty("tuttiAction", ExportDbAction.class);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(DbManagerUIHandler.class));
    }

    protected void createInformationLabel() {
        $objectMap.put("informationLabel", informationLabel = new JLabel());
        
        informationLabel.setName("informationLabel");
    }

    protected void createInstallDbButton() {
        $objectMap.put("installDbButton", installDbButton = new JButton());
        
        installDbButton.setName("installDbButton");
        installDbButton.putClientProperty("tuttiAction", InstallDbAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createNoDbActions() {
        $objectMap.put("noDbActions", noDbActions = new JPanel());
        
        noDbActions.setName("noDbActions");
        noDbActions.setLayout(new GridLayout(0, 1));
    }

    protected void createOpenDbButton() {
        $objectMap.put("openDbButton", openDbButton = new JButton());
        
        openDbButton.setName("openDbButton");
        openDbButton.putClientProperty("tuttiAction", OpenDbAction.class);
    }

    protected void createUpgradeDbButton() {
        $objectMap.put("upgradeDbButton", upgradeDbButton = new JButton());
        
        upgradeDbButton.setName("upgradeDbButton");
        upgradeDbButton.putClientProperty("tuttiAction", UpdateReferentialAction.class);
    }

    protected void createWithDbActions() {
        $objectMap.put("withDbActions", withDbActions = new JPanel());
        
        withDbActions.setName("withDbActions");
        withDbActions.setLayout(new GridLayout(0, 1));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToNoDbUITopPanel();
        addChildrenToCenterPanel();
        addChildrenToNoDbActions();
        addChildrenToWithDbActions();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        informationLabel.setHorizontalAlignment(JLabel.CENTER);
        informationLabel.setIcon(SwingUtil.createActionIcon("information"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("noDbUITopPanel", noDbUITopPanel);
        createHandler();
        createModel();
        createInformationLabel();
        createCenterPanel();
        createNoDbActions();
        createInstallDbButton();
        createWithDbActions();
        createOpenDbButton();
        createUpgradeDbButton();
        createExportDbButton();
        createCloseDbButton();
        // inline creation of noDbUITopPanel
        setName("noDbUITopPanel");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INFORMATION_LABEL_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    informationLabel.setText(_(handler.updateMessage(model.isDbExist(), model.isDbLoaded())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NO_DB_ACTIONS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    noDbActions.setVisible(!model.isDbExist());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WITH_DB_ACTIONS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    withDbActions.setVisible(model.isDbExist());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OPEN_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    openDbButton.setEnabled(!model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UPGRADE_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    upgradeDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLOSE_DB_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    closeDbButton.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
    }

}