package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditSelectedCruiseCatchesAction.java 514 2013-03-02 06:25:02Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/EditSelectedCruiseCatchesAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;

import static org.nuiton.i18n.I18n._;

/**
 * Opens the catches edition screen to edit the selected catches.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class EditSelectedCruiseCatchesAction extends AbstractChangeScreenAction {

    public EditSelectedCruiseCatchesAction(MainUIHandler handler) {
        super(handler,
              "edit",
              _("tutti.action.editCatches"),
              _("tutti.action.editCatches.tip"),
              true
        );
//        setMnemonic('C');
    }

    @Override
    protected void doAction() {
        Preconditions.checkState(getContext().isCruiseFilled());
        getContext().setValidationContext(TuttiUIContext.VALIDATION_CONTEXT_EDIT);
        getContext().setScreen(null);
        getContext().setScreen(getNextScreen());
    }

    @Override
    protected TuttiScreen getNextScreen() {
        return TuttiScreen.EDIT_FISHING_OPERATION;
    }

}
