/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportProtocolAction
extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ImportProtocolAction.class);
    public static final JAXXContextEntryDef<TuttiProtocol> IMPORT_PROTOCOL_ENTRY = new JAXXContextEntryDef("importProtocol", TuttiProtocol.class);
    private File file;

    public ImportProtocolAction(SelectCruiseUIHandler handler) {
        super(handler, "importProtocol", "import", I18n._((String)"tutti.action.importProtocol", (Object[])new Object[0]), I18n._((String)"tutti.action.importProtocol.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean doAction;
        this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.protocolImportFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseProtocolFile", (Object[])new Object[0]), null, "^.+\\.tuttiProtocol$", I18n._((String)"tutti.file.protocol", (Object[])new Object[0]));
        boolean bl = doAction = this.file != null;
        if (doAction) {
            super.prepareAction(event);
        }
        return doAction;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        this.file = null;
    }

    @Override
    protected void doAction(ActionEvent e) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)"TODO Import protocol!");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol file: " + this.file));
        }
        TuttiProtocolImportExportService service = this.getService(TuttiProtocolImportExportService.class);
        TuttiProtocol protocol = service.importProtocol(this.file);
        this.sendMessage("Protocole [" + protocol.getName() + "] lu depuis le fichier.");
        IMPORT_PROTOCOL_ENTRY.setContextValue((JAXXContext)this.getContext().getMainUI(), (Object)protocol);
        protocol.setId(null);
        this.getContext().setProtocolId(null);
        this.getContext().setScreen(TuttiScreen.EDIT_PROTOCOL);
    }
}

