/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.protocol.AddSpeciesProtocolAction;
import fr.ifremer.tutti.ui.swing.content.protocol.CancelEditProtocolAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.ExportAllCaracteristicAction;
import fr.ifremer.tutti.ui.swing.content.protocol.ExportProtocolCaracteristicAction;
import fr.ifremer.tutti.ui.swing.content.protocol.ExportProtocolSpeciesAction;
import fr.ifremer.tutti.ui.swing.content.protocol.ImportProtocolCaracteristicAction;
import fr.ifremer.tutti.ui.swing.content.protocol.ImportProtocolSpeciesAction;
import fr.ifremer.tutti.ui.swing.content.protocol.RemoveSpeciesProtocolAction;
import fr.ifremer.tutti.ui.swing.content.protocol.SaveProtocolAction;
import fr.ifremer.tutti.ui.swing.content.protocol.SelectOtherSpeciesAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorScope;

public class EditProtocolUI
extends JPanel
implements TuttiUI<EditProtocolUIModel, EditProtocolUIHandler>,
JAXXObject,
JAXXValidator {
    public static final String BINDING_ADD_SPECIES_PROTOCOL_ENABLED = "addSpeciesProtocol.enabled";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_REMOVE_SPECIES_PROTOCOL_ENABLED = "removeSpeciesProtocol.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SAVE_WARNING_CONTAINER_VISIBLE = "saveWarningContainer.visible";
    public static final String BINDING_SPECIES_COMBO_BOX_ENABLED = "speciesComboBox.enabled";
    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditProtocolUI.class);
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected JButton addSpeciesProtocol;
    protected JButton cancelButton;
    protected JPanel caracteristicActions;
    protected JTabbedPane caracteristicPane;
    protected JPanel caracteristicPanel;
    protected JTextArea commentField;
    @ValidatorField(validatorId="validator", propertyName="comment", editorName="commentPane")
    protected JScrollPane commentPane;
    protected BeanDoubleList<Caracteristic> environmentList;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JButton exportAllCaracteristic;
    protected JButton exportCaracteristic;
    protected JButton exportSpecies;
    protected BeanDoubleList<Caracteristic> gearList;
    protected EditProtocolUIHandler handler;
    protected EditProtocolUI homePanel = this;
    protected BeanDoubleList<Caracteristic> hydrologyList;
    protected JButton importCaracteristic;
    protected JButton importSpecies;
    protected BeanDoubleList<Caracteristic> lengthClassesList;
    protected EditProtocolUIModel model;
    @ValidatorField(validatorId="validator", propertyName="name", editorName="nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    protected Table protocolInfoForm;
    protected JMenuItem removeSpeciesProtocol;
    protected JButton saveButton;
    protected JLabel saveWarning;
    protected JPanel saveWarningContainer;
    protected JButton selectOtherSpecies;
    protected JPanel speciesActions;
    protected BeanComboBox<Species> speciesComboBox;
    protected JPanel speciesPanel;
    protected JXTable speciesTable;
    protected JPopupMenu tablePopup;
    @Validator(validatorId="validator")
    protected SwingValidator<EditProtocolUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JTabbedPane $JTabbedPane0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;
    private TabInfo $TabInfo6;
    private TabInfo $TabInfo7;
    private TabInfo $TabInfo8;
    private TabInfo $TabInfo9;
    private Table $Table0;

    protected void $afterCompleteSetup() {
        this.handler.afterInitUI();
    }

    public EditProtocolUI(TuttiUI parentUI) {
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentUI);
        EditProtocolUIHandler handler = new EditProtocolUIHandler(parentUI, this);
        this.setContextValue(handler);
        handler.beforeInitUI();
        this.$initialize();
    }

    public EditProtocolUI() {
        this.$initialize();
    }

    public EditProtocolUI(JAXXContext parentContext) {
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public EditProtocolUI(boolean param0) {
        super(param0);
        this.$initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public EditProtocolUI(LayoutManager param0) {
        super(param0);
        this.$initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public EditProtocolUI(LayoutManager param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public EditProtocolUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1, param2);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public void applyDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.getDataBinding($binding).applyDataBinding();
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public JAXXBinding getDataBinding(String bindingId) {
        return this.$bindings.get(bindingId);
    }

    public JAXXBinding[] getDataBindings() {
        return this.$bindings.values().toArray(new JAXXBinding[this.$bindings.size()]);
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && this.$activeBindings.contains($binding)) {
            return;
        }
        this.$activeBindings.add($binding);
        try {
            if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
                this.getDataBinding($binding).processDataBinding();
            }
        }
        finally {
            this.$activeBindings.remove($binding);
        }
    }

    public void processDataBinding(String $binding) {
        this.processDataBinding($binding, false);
    }

    public void registerDataBinding(JAXXBinding binding) {
        this.$bindings.put(binding.getId(), binding);
    }

    public void removeDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.getDataBinding($binding).removeDataBinding();
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)this, clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator)(this.validatorIds.contains(validatorId) ? this.getObjectById(validatorId) : null);
    }

    public List<String> getValidatorIds() {
        return this.validatorIds;
    }

    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields((JAXXValidator)this);
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.commentField.requestFocus();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.handler.setText(event, "name");
    }

    public void doMouseClicked__on__speciesTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.handler.autoSelectRowInTable(event, this.tablePopup);
    }

    public JButton getAddSpeciesProtocol() {
        return this.addSpeciesProtocol;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JPanel getCaracteristicActions() {
        return this.caracteristicActions;
    }

    public JTabbedPane getCaracteristicPane() {
        return this.caracteristicPane;
    }

    public JPanel getCaracteristicPanel() {
        return this.caracteristicPanel;
    }

    public JTextArea getCommentField() {
        return this.commentField;
    }

    public JScrollPane getCommentPane() {
        return this.commentPane;
    }

    public BeanDoubleList<Caracteristic> getEnvironmentList() {
        return this.environmentList;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return this.errorTableModel;
    }

    public JButton getExportAllCaracteristic() {
        return this.exportAllCaracteristic;
    }

    public JButton getExportCaracteristic() {
        return this.exportCaracteristic;
    }

    public JButton getExportSpecies() {
        return this.exportSpecies;
    }

    public BeanDoubleList<Caracteristic> getGearList() {
        return this.gearList;
    }

    @Override
    public EditProtocolUIHandler getHandler() {
        return this.handler;
    }

    public BeanDoubleList<Caracteristic> getHydrologyList() {
        return this.hydrologyList;
    }

    public JButton getImportCaracteristic() {
        return this.importCaracteristic;
    }

    public JButton getImportSpecies() {
        return this.importSpecies;
    }

    public BeanDoubleList<Caracteristic> getLengthClassesList() {
        return this.lengthClassesList;
    }

    @Override
    public EditProtocolUIModel getModel() {
        return this.model;
    }

    public JTextField getNameField() {
        return this.nameField;
    }

    public JLabel getNameLabel() {
        return this.nameLabel;
    }

    public Table getProtocolInfoForm() {
        return this.protocolInfoForm;
    }

    public JMenuItem getRemoveSpeciesProtocol() {
        return this.removeSpeciesProtocol;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JLabel getSaveWarning() {
        return this.saveWarning;
    }

    public JPanel getSaveWarningContainer() {
        return this.saveWarningContainer;
    }

    public JButton getSelectOtherSpecies() {
        return this.selectOtherSpecies;
    }

    public JPanel getSpeciesActions() {
        return this.speciesActions;
    }

    public BeanComboBox<Species> getSpeciesComboBox() {
        return this.speciesComboBox;
    }

    public JPanel getSpeciesPanel() {
        return this.speciesPanel;
    }

    public JXTable getSpeciesTable() {
        return this.speciesTable;
    }

    public JPopupMenu getTablePopup() {
        return this.tablePopup;
    }

    public SwingValidator<EditProtocolUIModel> getValidator() {
        return this.validator;
    }

    protected JLabel get$JLabel0() {
        return this.$JLabel0;
    }

    protected JLabel get$JLabel1() {
        return this.$JLabel1;
    }

    protected JLabel get$JLabel2() {
        return this.$JLabel2;
    }

    protected JPanel get$JPanel0() {
        return this.$JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return this.$JScrollPane0;
    }

    protected JTabbedPane get$JTabbedPane0() {
        return this.$JTabbedPane0;
    }

    protected TabInfo get$TabInfo0() {
        return this.$TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return this.$TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return this.$TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return this.$TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return this.$TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return this.$TabInfo5;
    }

    protected TabInfo get$TabInfo6() {
        return this.$TabInfo6;
    }

    protected TabInfo get$TabInfo7() {
        return this.$TabInfo7;
    }

    protected TabInfo get$TabInfo8() {
        return this.$TabInfo8;
    }

    protected TabInfo get$TabInfo9() {
        return this.$TabInfo9;
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected void addChildrenToCaracteristicActions() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.caracteristicActions.add(this.importCaracteristic);
        this.caracteristicActions.add(this.exportCaracteristic);
        this.caracteristicActions.add(this.exportAllCaracteristic);
    }

    protected void addChildrenToCaracteristicPane() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.caracteristicPane.add((Component)this.lengthClassesList);
        this.caracteristicPane.add((Component)this.gearList);
        this.caracteristicPane.add((Component)this.environmentList);
        this.caracteristicPane.add((Component)this.hydrologyList);
        this.$TabInfo2.addPropertyChangeListener((PropertyChangeListener)new TabInfoPropertyChangeListener(this.caracteristicPane, 0));
        this.caracteristicPane.setTitleAt(0, I18n._((String)"tutti.label.tab.protocol.caracteristic.lengthClasses", (Object[])new Object[0]));
        this.$TabInfo3.addPropertyChangeListener((PropertyChangeListener)new TabInfoPropertyChangeListener(this.caracteristicPane, 1));
        this.caracteristicPane.setTitleAt(1, I18n._((String)"tutti.label.tab.protocol.caracteristic.gear", (Object[])new Object[0]));
        this.$TabInfo4.addPropertyChangeListener((PropertyChangeListener)new TabInfoPropertyChangeListener(this.caracteristicPane, 2));
        this.caracteristicPane.setTitleAt(2, I18n._((String)"tutti.label.tab.protocol.caracteristic.environment", (Object[])new Object[0]));
        this.$TabInfo5.addPropertyChangeListener((PropertyChangeListener)new TabInfoPropertyChangeListener(this.caracteristicPane, 3));
        this.caracteristicPane.setTitleAt(3, I18n._((String)"tutti.label.tab.protocol.caracteristic.hydrology", (Object[])new Object[0]));
    }

    protected void addChildrenToCaracteristicPanel() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.caracteristicPanel.add((Component)this.caracteristicActions, "North");
        this.caracteristicPanel.add((Component)this.caracteristicPane, "Center");
    }

    protected void addChildrenToCommentPane() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.commentPane.getViewport().add(this.commentField);
    }

    protected void addChildrenToHomePanel() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.add((Component)this.$JTabbedPane0, "Center");
        this.add((Component)this.saveWarningContainer, "North");
        this.add((Component)this.$JPanel0, "South");
    }

    protected void addChildrenToProtocolInfoForm() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.protocolInfoForm.add((Component)this.nameLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.protocolInfoForm.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.nameField), (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.protocolInfoForm.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.commentPane), (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSaveWarningContainer() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.saveWarningContainer.add((Component)this.saveWarning, "Center");
    }

    protected void addChildrenToSpeciesActions() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.speciesActions.add(this.importSpecies);
        this.speciesActions.add(this.exportSpecies);
    }

    protected void addChildrenToSpeciesPanel() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.speciesPanel.add((Component)this.speciesActions, "North");
        this.speciesPanel.add((Component)this.$Table0, "Center");
    }

    protected void addChildrenToTablePopup() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.tablePopup.add(this.removeSpeciesProtocol);
    }

    protected void addChildrenToValidator() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.validator.setErrorTableModel(this.errorTableModel);
        this.validator.setUiClass(ImageValidationUI.class);
        this.validator.setBean((Object)this.model);
    }

    protected void createAddSpeciesProtocol() {
        this.addSpeciesProtocol = new JButton();
        this.$objectMap.put("addSpeciesProtocol", this.addSpeciesProtocol);
        this.addSpeciesProtocol.setName("addSpeciesProtocol");
        this.addSpeciesProtocol.putClientProperty("tuttiAction", AddSpeciesProtocolAction.class);
    }

    protected void createCancelButton() {
        this.cancelButton = new JButton();
        this.$objectMap.put("cancelButton", this.cancelButton);
        this.cancelButton.setName("cancelButton");
        this.cancelButton.putClientProperty("tuttiAction", CancelEditProtocolAction.class);
    }

    protected void createCaracteristicActions() {
        this.caracteristicActions = new JPanel();
        this.$objectMap.put("caracteristicActions", this.caracteristicActions);
        this.caracteristicActions.setName("caracteristicActions");
        this.caracteristicActions.setLayout(new GridLayout());
    }

    protected void createCaracteristicPane() {
        this.caracteristicPane = new JTabbedPane();
        this.$objectMap.put("caracteristicPane", this.caracteristicPane);
        this.caracteristicPane.setName("caracteristicPane");
    }

    protected void createCaracteristicPanel() {
        this.caracteristicPanel = new JPanel();
        this.$objectMap.put("caracteristicPanel", this.caracteristicPanel);
        this.caracteristicPanel.setName("caracteristicPanel");
        this.caracteristicPanel.setLayout(new BorderLayout());
    }

    protected void createCommentField() {
        this.commentField = new JTextArea();
        this.$objectMap.put("commentField", this.commentField);
        this.commentField.setName("commentField");
        this.commentField.setColumns(15);
        this.commentField.setLineWrap(true);
        this.commentField.setWrapStyleWord(true);
        this.commentField.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__commentField"));
        this.commentField.putClientProperty("validatorLabel", I18n._((String)"tutti.label.comment", (Object[])new Object[0]));
    }

    protected void createCommentPane() {
        this.commentPane = new JScrollPane();
        this.$objectMap.put("commentPane", this.commentPane);
        this.commentPane.setName("commentPane");
        this.commentPane.addFocusListener((FocusListener)JAXXUtil.getEventListener(FocusListener.class, (String)"focusGained", (Object)this, (String)"doFocusGained__on__commentPane"));
    }

    protected void createEnvironmentList() {
        this.environmentList = new BeanDoubleList();
        this.$objectMap.put("environmentList", this.environmentList);
        this.environmentList.setName("environmentList");
        this.environmentList.setProperty("environmentPmfm");
        this.environmentList.setShowReset(Boolean.valueOf(true));
    }

    protected void createErrorTableModel() {
        this.errorTableModel = new SwingValidatorMessageTableModel();
        this.$objectMap.put("errorTableModel", this.errorTableModel);
    }

    protected void createExportAllCaracteristic() {
        this.exportAllCaracteristic = new JButton();
        this.$objectMap.put("exportAllCaracteristic", this.exportAllCaracteristic);
        this.exportAllCaracteristic.setName("exportAllCaracteristic");
        this.exportAllCaracteristic.putClientProperty("tuttiAction", ExportAllCaracteristicAction.class);
    }

    protected void createExportCaracteristic() {
        this.exportCaracteristic = new JButton();
        this.$objectMap.put("exportCaracteristic", this.exportCaracteristic);
        this.exportCaracteristic.setName("exportCaracteristic");
        this.exportCaracteristic.putClientProperty("tuttiAction", ExportProtocolCaracteristicAction.class);
    }

    protected void createExportSpecies() {
        this.exportSpecies = new JButton();
        this.$objectMap.put("exportSpecies", this.exportSpecies);
        this.exportSpecies.setName("exportSpecies");
        this.exportSpecies.putClientProperty("tuttiAction", ExportProtocolSpeciesAction.class);
    }

    protected void createGearList() {
        this.gearList = new BeanDoubleList();
        this.$objectMap.put("gearList", this.gearList);
        this.gearList.setName("gearList");
        this.gearList.setProperty("gearPmfm");
        this.gearList.setShowReset(Boolean.valueOf(true));
    }

    protected void createHandler() {
        this.handler = this.getContextValue(EditProtocolUIHandler.class);
        this.$objectMap.put("handler", this.handler);
    }

    protected void createHydrologyList() {
        this.hydrologyList = new BeanDoubleList();
        this.$objectMap.put("hydrologyList", this.hydrologyList);
        this.hydrologyList.setName("hydrologyList");
        this.hydrologyList.setProperty("hydrologyPmfm");
        this.hydrologyList.setShowReset(Boolean.valueOf(true));
    }

    protected void createImportCaracteristic() {
        this.importCaracteristic = new JButton();
        this.$objectMap.put("importCaracteristic", this.importCaracteristic);
        this.importCaracteristic.setName("importCaracteristic");
        this.importCaracteristic.putClientProperty("tuttiAction", ImportProtocolCaracteristicAction.class);
    }

    protected void createImportSpecies() {
        this.importSpecies = new JButton();
        this.$objectMap.put("importSpecies", this.importSpecies);
        this.importSpecies.setName("importSpecies");
        this.importSpecies.putClientProperty("tuttiAction", ImportProtocolSpeciesAction.class);
    }

    protected void createLengthClassesList() {
        this.lengthClassesList = new BeanDoubleList();
        this.$objectMap.put("lengthClassesList", this.lengthClassesList);
        this.lengthClassesList.setName("lengthClassesList");
        this.lengthClassesList.setProperty("lengthClassesPmfm");
        this.lengthClassesList.setShowReset(Boolean.valueOf(true));
    }

    protected void createModel() {
        this.model = this.getContextValue(EditProtocolUIModel.class);
        this.$objectMap.put("model", this.model);
    }

    protected void createNameField() {
        this.nameField = new JTextField();
        this.$objectMap.put("nameField", this.nameField);
        this.nameField.setName("nameField");
        this.nameField.setColumns(15);
        this.nameField.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__nameField"));
        this.nameField.putClientProperty("validatorLabel", I18n._((String)"tutti.label.protocol.name", (Object[])new Object[0]));
    }

    protected void createNameLabel() {
        this.nameLabel = new JLabel();
        this.$objectMap.put("nameLabel", this.nameLabel);
        this.nameLabel.setName("nameLabel");
        this.nameLabel.setText(I18n._((String)"tutti.label.protocol.name", (Object[])new Object[0]));
    }

    protected void createProtocolInfoForm() {
        this.protocolInfoForm = new Table();
        this.$objectMap.put("protocolInfoForm", this.protocolInfoForm);
        this.protocolInfoForm.setName("protocolInfoForm");
    }

    protected void createRemoveSpeciesProtocol() {
        this.removeSpeciesProtocol = new JMenuItem();
        this.$objectMap.put("removeSpeciesProtocol", this.removeSpeciesProtocol);
        this.removeSpeciesProtocol.setName("removeSpeciesProtocol");
        this.removeSpeciesProtocol.setMnemonic(82);
        this.removeSpeciesProtocol.putClientProperty("tuttiAction", RemoveSpeciesProtocolAction.class);
    }

    protected void createSaveButton() {
        this.saveButton = new JButton();
        this.$objectMap.put("saveButton", this.saveButton);
        this.saveButton.setName("saveButton");
        this.saveButton.putClientProperty("tuttiAction", SaveProtocolAction.class);
    }

    protected void createSaveWarning() {
        this.saveWarning = new JLabel();
        this.$objectMap.put("saveWarning", this.saveWarning);
        this.saveWarning.setName("saveWarning");
    }

    protected void createSaveWarningContainer() {
        this.saveWarningContainer = new JPanel();
        this.$objectMap.put("saveWarningContainer", this.saveWarningContainer);
        this.saveWarningContainer.setName("saveWarningContainer");
        this.saveWarningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createSelectOtherSpecies() {
        this.selectOtherSpecies = new JButton();
        this.$objectMap.put("selectOtherSpecies", this.selectOtherSpecies);
        this.selectOtherSpecies.setName("selectOtherSpecies");
        this.selectOtherSpecies.putClientProperty("tuttiAction", SelectOtherSpeciesAction.class);
    }

    protected void createSpeciesActions() {
        this.speciesActions = new JPanel();
        this.$objectMap.put("speciesActions", this.speciesActions);
        this.speciesActions.setName("speciesActions");
        this.speciesActions.setLayout(new GridLayout());
    }

    protected void createSpeciesComboBox() {
        this.speciesComboBox = new BeanComboBox((JAXXContext)this);
        this.$objectMap.put("speciesComboBox", this.speciesComboBox);
        this.speciesComboBox.setName("speciesComboBox");
        this.speciesComboBox.setI18nPrefix("tutti.property.");
        this.speciesComboBox.setShowReset(Boolean.valueOf(false));
    }

    protected void createSpeciesPanel() {
        this.speciesPanel = new JPanel();
        this.$objectMap.put("speciesPanel", this.speciesPanel);
        this.speciesPanel.setName("speciesPanel");
        this.speciesPanel.setLayout(new BorderLayout());
    }

    protected void createSpeciesTable() {
        this.speciesTable = new JXTable();
        this.$objectMap.put("speciesTable", this.speciesTable);
        this.speciesTable.setName("speciesTable");
        this.speciesTable.setSortable(false);
        this.speciesTable.addMouseListener((MouseListener)JAXXUtil.getEventListener(MouseListener.class, (String)"mouseClicked", (Object)this, (String)"doMouseClicked__on__speciesTable"));
    }

    protected void createTablePopup() {
        this.tablePopup = new JPopupMenu();
        this.$objectMap.put("tablePopup", this.tablePopup);
        this.tablePopup.setName("tablePopup");
        this.tablePopup.setLabel("tutti.title.batchActions");
    }

    protected void createValidator() {
        this.validator = SwingValidator.newValidator(EditProtocolUIModel.class, null, (NuitonValidatorScope[])new NuitonValidatorScope[0]);
        this.$objectMap.put("validator", this.validator);
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.addChildrenToHomePanel();
        this.addChildrenToValidator();
        this.addChildrenToTablePopup();
        this.$JTabbedPane0.add((Component)this.protocolInfoForm);
        this.$JTabbedPane0.add(this.caracteristicPanel);
        this.$JTabbedPane0.add(this.speciesPanel);
        this.$JTabbedPane0.add(this.$JLabel0);
        this.$JTabbedPane0.add(this.$JLabel1);
        this.$JTabbedPane0.add(this.$JLabel2);
        this.$TabInfo0.addPropertyChangeListener((PropertyChangeListener)new TabInfoPropertyChangeListener(this.$JTabbedPane0, 0));
        this.$JTabbedPane0.setTitleAt(0, I18n._((String)"tutti.label.tab.protocol.info", (Object[])new Object[0]));
        this.$TabInfo1.addPropertyChangeListener((PropertyChangeListener)new TabInfoPropertyChangeListener(this.$JTabbedPane0, 1));
        this.$JTabbedPane0.setTitleAt(1, I18n._((String)"tutti.label.tab.protocol.caracteristic", (Object[])new Object[0]));
        this.$TabInfo6.addPropertyChangeListener((PropertyChangeListener)new TabInfoPropertyChangeListener(this.$JTabbedPane0, 2));
        this.$JTabbedPane0.setTitleAt(2, I18n._((String)"tutti.label.tab.protocol.species", (Object[])new Object[0]));
        this.$TabInfo7.addPropertyChangeListener((PropertyChangeListener)new TabInfoPropertyChangeListener(this.$JTabbedPane0, 3));
        this.$JTabbedPane0.setTitleAt(3, I18n._((String)"tutti.label.tab.protocol.benthos", (Object[])new Object[0]));
        this.$JTabbedPane0.setEnabledAt(3, false);
        this.$TabInfo8.addPropertyChangeListener((PropertyChangeListener)new TabInfoPropertyChangeListener(this.$JTabbedPane0, 4));
        this.$JTabbedPane0.setTitleAt(4, I18n._((String)"tutti.label.tab.protocol.plankton", (Object[])new Object[0]));
        this.$JTabbedPane0.setEnabledAt(4, false);
        this.$TabInfo9.addPropertyChangeListener((PropertyChangeListener)new TabInfoPropertyChangeListener(this.$JTabbedPane0, 5));
        this.$JTabbedPane0.setTitleAt(5, I18n._((String)"tutti.label.tab.protocol.accidental", (Object[])new Object[0]));
        this.$JTabbedPane0.setEnabledAt(5, false);
        this.addChildrenToProtocolInfoForm();
        this.addChildrenToCommentPane();
        this.addChildrenToCaracteristicPanel();
        this.addChildrenToCaracteristicActions();
        this.addChildrenToCaracteristicPane();
        this.addChildrenToSpeciesPanel();
        this.addChildrenToSpeciesActions();
        this.$Table0.add(this.speciesComboBox, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.selectOtherSpecies, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.addSpeciesProtocol, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.$JScrollPane0, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$JScrollPane0.getViewport().add((Component)this.speciesTable);
        this.addChildrenToSaveWarningContainer();
        this.$JPanel0.add(this.cancelButton);
        this.$JPanel0.add(this.saveButton);
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.lengthClassesList.setBeanType(Caracteristic.class);
        this.gearList.setBeanType(Caracteristic.class);
        this.environmentList.setBeanType(Caracteristic.class);
        this.hydrologyList.setBeanType(Caracteristic.class);
        this.speciesComboBox.setBeanType(Species.class);
        this.$JLabel0.setHorizontalAlignment(0);
        this.$JLabel1.setHorizontalAlignment(0);
        this.$JLabel2.setHorizontalAlignment(0);
        this.nameLabel.setLabelFor(this.nameField);
        this.commentPane.setBorder(BorderFactory.createTitledBorder(I18n._((String)"tutti.label.comment", (Object[])new Object[0])));
        this.caracteristicPane.setTabPlacement(2);
        this.lengthClassesList.setBean((Object)this.model);
        this.gearList.setBean((Object)this.model);
        this.environmentList.setBean((Object)this.model);
        this.hydrologyList.setBean((Object)this.model);
        this.speciesTable.setSelectionMode(0);
        this.speciesTable.setSelectionForeground(Color.BLACK);
        this.speciesTable.setSelectionBackground(null);
        this.saveWarningContainer.setBackground(new Color(245, 218, 88));
        this.saveWarning.setIcon(SwingUtil.createActionIcon((String)"warning"));
        this.saveWarning.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.validatorIds = SwingValidatorUtil.detectValidators((JAXXValidator)this);
        SwingValidatorUtil.installUI((JAXXValidator)this);
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.$objectMap.put("homePanel", this.homePanel);
        this.createHandler();
        this.createModel();
        this.createErrorTableModel();
        this.createValidator();
        this.createTablePopup();
        this.createRemoveSpeciesProtocol();
        this.$JTabbedPane0 = new JTabbedPane();
        this.$objectMap.put("$JTabbedPane0", this.$JTabbedPane0);
        this.$JTabbedPane0.setName("$JTabbedPane0");
        this.createProtocolInfoForm();
        this.createNameLabel();
        this.createNameField();
        this.createCommentPane();
        this.createCommentField();
        this.createCaracteristicPanel();
        this.createCaracteristicActions();
        this.createImportCaracteristic();
        this.createExportCaracteristic();
        this.createExportAllCaracteristic();
        this.createCaracteristicPane();
        this.createLengthClassesList();
        this.createGearList();
        this.createEnvironmentList();
        this.createHydrologyList();
        this.createSpeciesPanel();
        this.createSpeciesActions();
        this.createImportSpecies();
        this.createExportSpecies();
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.createSpeciesComboBox();
        this.createSelectOtherSpecies();
        this.createAddSpeciesProtocol();
        this.$JScrollPane0 = new JScrollPane();
        this.$objectMap.put("$JScrollPane0", this.$JScrollPane0);
        this.$JScrollPane0.setName("$JScrollPane0");
        this.createSpeciesTable();
        this.$JLabel0 = new JLabel();
        this.$objectMap.put("$JLabel0", this.$JLabel0);
        this.$JLabel0.setName("$JLabel0");
        this.$JLabel0.setText(I18n._((String)"tutti.to.be.done", (Object[])new Object[0]));
        this.$JLabel1 = new JLabel();
        this.$objectMap.put("$JLabel1", this.$JLabel1);
        this.$JLabel1.setName("$JLabel1");
        this.$JLabel1.setText(I18n._((String)"tutti.to.be.done", (Object[])new Object[0]));
        this.$JLabel2 = new JLabel();
        this.$objectMap.put("$JLabel2", this.$JLabel2);
        this.$JLabel2.setName("$JLabel2");
        this.$JLabel2.setText(I18n._((String)"tutti.to.be.done", (Object[])new Object[0]));
        this.createSaveWarningContainer();
        this.createSaveWarning();
        this.$JPanel0 = new JPanel();
        this.$objectMap.put("$JPanel0", this.$JPanel0);
        this.$JPanel0.setName("$JPanel0");
        this.$JPanel0.setLayout(new GridLayout(1, 0));
        this.createCancelButton();
        this.createSaveButton();
        this.$TabInfo0 = new TabInfo();
        this.$objectMap.put("$TabInfo0", this.$TabInfo0);
        this.$TabInfo0.setTitle(I18n._((String)"tutti.label.tab.protocol.info", (Object[])new Object[0]));
        this.$TabInfo1 = new TabInfo();
        this.$objectMap.put("$TabInfo1", this.$TabInfo1);
        this.$TabInfo1.setTitle(I18n._((String)"tutti.label.tab.protocol.caracteristic", (Object[])new Object[0]));
        this.$TabInfo2 = new TabInfo();
        this.$objectMap.put("$TabInfo2", this.$TabInfo2);
        this.$TabInfo2.setTitle(I18n._((String)"tutti.label.tab.protocol.caracteristic.lengthClasses", (Object[])new Object[0]));
        this.$TabInfo3 = new TabInfo();
        this.$objectMap.put("$TabInfo3", this.$TabInfo3);
        this.$TabInfo3.setTitle(I18n._((String)"tutti.label.tab.protocol.caracteristic.gear", (Object[])new Object[0]));
        this.$TabInfo4 = new TabInfo();
        this.$objectMap.put("$TabInfo4", this.$TabInfo4);
        this.$TabInfo4.setTitle(I18n._((String)"tutti.label.tab.protocol.caracteristic.environment", (Object[])new Object[0]));
        this.$TabInfo5 = new TabInfo();
        this.$objectMap.put("$TabInfo5", this.$TabInfo5);
        this.$TabInfo5.setTitle(I18n._((String)"tutti.label.tab.protocol.caracteristic.hydrology", (Object[])new Object[0]));
        this.$TabInfo6 = new TabInfo();
        this.$objectMap.put("$TabInfo6", this.$TabInfo6);
        this.$TabInfo6.setTitle(I18n._((String)"tutti.label.tab.protocol.species", (Object[])new Object[0]));
        this.$TabInfo7 = new TabInfo();
        this.$objectMap.put("$TabInfo7", this.$TabInfo7);
        this.$TabInfo7.setEnabled(false);
        this.$TabInfo7.setTitle(I18n._((String)"tutti.label.tab.protocol.benthos", (Object[])new Object[0]));
        this.$TabInfo8 = new TabInfo();
        this.$objectMap.put("$TabInfo8", this.$TabInfo8);
        this.$TabInfo8.setEnabled(false);
        this.$TabInfo8.setTitle(I18n._((String)"tutti.label.tab.protocol.plankton", (Object[])new Object[0]));
        this.$TabInfo9 = new TabInfo();
        this.$objectMap.put("$TabInfo9", this.$TabInfo9);
        this.$TabInfo9.setEnabled(false);
        this.$TabInfo9.setTitle(I18n._((String)"tutti.label.tab.protocol.accidental", (Object[])new Object[0]));
        this.setName("homePanel");
        this.setLayout(new BorderLayout());
        this.$registerDefaultBindings();
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_PROTOCOL_ENABLED, true){

            public void applyDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.addPropertyChangeListener("removeSpeciesEnabled", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.removeSpeciesProtocol.setEnabled(EditProtocolUI.this.model.isRemoveSpeciesEnabled());
                }
            }

            public void removeDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.removePropertyChangeListener("removeSpeciesEnabled", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true){

            public void applyDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.addPropertyChangeListener("name", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    SwingUtil.setText((JTextComponent)EditProtocolUI.this.nameField, (String)EditProtocolUI.this.model.getName());
                }
            }

            public void removeDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.removePropertyChangeListener("name", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true){

            public void applyDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.addPropertyChangeListener("comment", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    SwingUtil.setText((JTextComponent)EditProtocolUI.this.commentField, (String)SwingUtil.getStringValue((Object)EditProtocolUI.this.model.getComment()));
                }
            }

            public void removeDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.removePropertyChangeListener("comment", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_ENABLED, true){

            public void applyDataBinding() {
                if (EditProtocolUI.this.speciesComboBox != null) {
                    EditProtocolUI.this.speciesComboBox.addPropertyChangeListener("empty", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (EditProtocolUI.this.speciesComboBox != null) {
                    EditProtocolUI.this.speciesComboBox.setEnabled(!EditProtocolUI.this.speciesComboBox.isEmpty());
                }
            }

            public void removeDataBinding() {
                if (EditProtocolUI.this.speciesComboBox != null) {
                    EditProtocolUI.this.speciesComboBox.removePropertyChangeListener("empty", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_ADD_SPECIES_PROTOCOL_ENABLED, true){

            public void applyDataBinding() {
                if (EditProtocolUI.this.speciesComboBox != null) {
                    EditProtocolUI.this.speciesComboBox.addPropertyChangeListener("selectedItem", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (EditProtocolUI.this.speciesComboBox != null) {
                    EditProtocolUI.this.addSpeciesProtocol.setEnabled(EditProtocolUI.this.speciesComboBox.getSelectedItem() != null);
                }
            }

            public void removeDataBinding() {
                if (EditProtocolUI.this.speciesComboBox != null) {
                    EditProtocolUI.this.speciesComboBox.removePropertyChangeListener("selectedItem", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_SAVE_WARNING_CONTAINER_VISIBLE, true, true){

            public void applyDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.addPropertyChangeListener("imported", (PropertyChangeListener)((Object)this));
                }
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.addPropertyChangeListener("cloned", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.saveWarningContainer.setVisible(EditProtocolUI.this.model.isImported() || EditProtocolUI.this.model.isCloned());
                }
            }

            public void removeDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.removePropertyChangeListener("imported", (PropertyChangeListener)((Object)this));
                }
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.removePropertyChangeListener("cloned", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true){

            public void applyDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.addPropertyChangeListener("modify", (PropertyChangeListener)((Object)this));
                }
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.addPropertyChangeListener("valid", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.saveButton.setEnabled(EditProtocolUI.this.model.isModify() && EditProtocolUI.this.model.isValid());
                }
            }

            public void removeDataBinding() {
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.removePropertyChangeListener("modify", (PropertyChangeListener)((Object)this));
                }
                if (EditProtocolUI.this.model != null) {
                    EditProtocolUI.this.model.removePropertyChangeListener("valid", (PropertyChangeListener)((Object)this));
                }
            }
        });
    }
}

