/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.TabHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditCatchesUIHandler
extends AbstractTuttiTabContainerUIHandler<EditCatchesUIModel, EditCatchesUI>
implements TabHandler {
    public static final String MAIN_CARD = "main";
    public static final String CREATE_BATCH_CARD = "createBatch";
    public static final String SPLIT_BATCH_CARD = "splitBatch";
    public static final String EDIT_FREQUENCY_CARD = "editFrequency";
    private static final Log log = LogFactory.getLog(EditCatchesUIHandler.class);
    private final TuttiBeanMonitor<EditCatchesUIModel> catchBatchMonitor;
    protected final FishingOperationsUI parentUi;

    public EditCatchesUIHandler(FishingOperationsUI parentUi, EditCatchesUI ui) {
        super(parentUi.getHandler().getContext(), ui);
        this.parentUi = parentUi;
        this.catchBatchMonitor = new TuttiBeanMonitor("speciesTotalSortedWeight");
    }

    @Override
    public void beforeInitUI() {
        EditCatchesUIModel model = ((EditCatchesUI)this.ui).getContextValue(EditCatchesUIModel.class);
        this.listModelIsModify(model);
        this.catchBatchMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        this.listenValidatorValid((SimpleBeanValidator)this.getValidator(), model);
        this.setCustomTab(0, model);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        this.closeUI(((EditCatchesUI)this.ui).getSpeciesTabContent());
    }

    @Override
    public SwingValidator<EditCatchesUIModel> getValidator() {
        return ((EditCatchesUI)this.ui).getValidator();
    }

    @Override
    protected Set<String> getPropertiesToIgnore() {
        Set<String> result = super.getPropertiesToIgnore();
        result.addAll(Sets.newHashSet((Object[])new String[]{"catchTotalComputedWeight", "catchTotalSortedComputedWeight", "catchTotalUnsortedComputedWeight", "catchTotalRejectedComputedWeight", "speciesTotalComputedWeight", "speciesTotalSortedComputedWeight", "speciesTotalUnsortedComputedWeight", "speciesTotalSampleSortedComputedWeight"}));
        return result;
    }

    @Override
    protected JTabbedPane getTabPanel() {
        return ((EditCatchesUI)this.ui).getTabPane();
    }

    @Override
    public boolean onHideTab(int currentIndex, int newIndex) {
        boolean result;
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        if (model.isModify()) {
            if (model.isValid()) {
                int answer = this.askSaveBeforeLeaving(I18n._((String)"tutti.dialog.askSaveBeforeLeaving.saveCatchBatch", (Object[])new Object[0]));
                switch (answer) {
                    case 0: {
                        this.doAction(((EditCatchesUI)this.getUI()).getSaveButton(), null);
                        result = true;
                        break;
                    }
                    case 1: {
                        this.doAction(((EditCatchesUI)this.getUI()).getCancelButton(), null);
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
            } else {
                int answer = this.askCancelEditBeforeLeaving(I18n._((String)"tutti.dialog.askCancelEditBeforeLeaving.cancelEditCatchBatch", (Object[])new Object[0]));
                switch (answer) {
                    case 0: {
                        ActionEvent event = new ActionEvent(this, newIndex, null);
                        this.doAction(((EditCatchesUI)this.ui).getCancelButton(), event);
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    public void onShowTab(int currentIndex, int newIndex) {
        this.registerValidators();
    }

    public TuttiBeanMonitor<EditCatchesUIModel> getCatchBatchMonitor() {
        return this.catchBatchMonitor;
    }

    public FishingOperationsUI getParentUi() {
        return this.parentUi;
    }

    public FishingOperationsUIHandler getParentHandler() {
        return this.getParentUi().getHandler();
    }

    protected void registerValidators() {
        this.registerValidators(this.getValidator(), ((EditCatchesUI)this.ui).getSpeciesTabContent().getHandler().getValidator());
    }

    public void setSpeciesSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getSpeciesTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        layout.setSelected(card);
        JPanel actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
        if (MAIN_CARD.equals(card)) {
            this.registerValidators();
            actionPanel.setVisible(true);
        } else {
            actionPanel.setVisible(false);
            JPanel tuttiUi = null;
            JXTitledPanel titlePanel = null;
            String title = "";
            if (CREATE_BATCH_CARD.equals(card)) {
                tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabCreateBatch();
                titlePanel = ((EditCatchesUI)this.ui).getSpeciesTabCreateBatchReminderLabel();
                title = I18n.n_((String)"tutti.title.createBatch", (Object[])new Object[0]);
            } else if (SPLIT_BATCH_CARD.equals(card)) {
                tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabSplitBatch();
                titlePanel = ((EditCatchesUI)this.ui).getSpeciesTabSplitBatchReminderLabel();
                title = I18n.n_((String)"tutti.title.splitBatch", (Object[])new Object[0]);
            } else if (EDIT_FREQUENCY_CARD.equals(card)) {
                tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditor();
                titlePanel = ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditorReminderLabel();
                title = I18n.n_((String)"tutti.title.editFrequency", (Object[])new Object[0]);
            }
            if (tuttiUi != null) {
                this.registerValidators(((AbstractTuttiUIHandler)tuttiUi.getHandler()).getValidator());
            }
            if (titlePanel != null) {
                titlePanel.setTitle(((EditCatchesUI)this.ui).getSpeciesTabFishingOperationReminderLabel().getTitle() + " - " + I18n._((String)title, (Object[])new Object[0]));
            }
        }
    }
}

