/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import java.io.Serializable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.hibernate.management.impl.EhcacheHibernateMbeanNames;
import net.sf.ehcache.management.CacheConfigurationMBean;

public class CacheConfiguration
implements CacheConfigurationMBean,
Serializable {
    private static final long serialVersionUID = -8944774509593267228L;
    private transient net.sf.ehcache.config.CacheConfiguration cacheConfiguration;
    private ObjectName objectName;

    public CacheConfiguration(Ehcache cache) {
        this.cacheConfiguration = cache.getCacheConfiguration();
        this.objectName = CacheConfiguration.createObjectName(cache.getCacheManager().toString(), cache.getName());
    }

    static ObjectName createObjectName(String cacheManagerName, String cacheName) {
        ObjectName objectName;
        try {
            objectName = new ObjectName("net.sf.ehcache:type=CacheConfiguration,CacheManager=" + cacheManagerName + ",name=" + EhcacheHibernateMbeanNames.mbeanSafe(cacheName));
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException(e);
        }
        return objectName;
    }

    public String getName() {
        return this.cacheConfiguration.getName();
    }

    public boolean isLoggingEnabled() {
        return this.cacheConfiguration.getLogging();
    }

    public void setLoggingEnabled(boolean enable) {
        this.cacheConfiguration.setLogging(enable);
    }

    public int getMaxElementsInMemory() {
        return this.cacheConfiguration.getMaxElementsInMemory();
    }

    public void setMaxElementsInMemory(int maxElements) {
        this.cacheConfiguration.setMaxElementsInMemory(maxElements);
    }

    public int getMaxElementsOnDisk() {
        return this.cacheConfiguration.getMaxElementsOnDisk();
    }

    public void setMaxElementsOnDisk(int maxElements) {
        this.cacheConfiguration.setMaxElementsOnDisk(maxElements);
    }

    public String getMemoryStoreEvictionPolicy() {
        return this.cacheConfiguration.getMemoryStoreEvictionPolicy().toString();
    }

    public void setMemoryStoreEvictionPolicy(String memoryStoreEvictionPolicy) {
        this.cacheConfiguration.setMemoryStoreEvictionPolicy(memoryStoreEvictionPolicy);
    }

    public boolean isEternal() {
        return this.cacheConfiguration.isEternal();
    }

    public void setEternal(boolean eternal) {
        this.cacheConfiguration.setEternal(eternal);
    }

    public long getTimeToIdleSeconds() {
        return this.cacheConfiguration.getTimeToIdleSeconds();
    }

    public void setTimeToIdleSeconds(long tti) {
        this.cacheConfiguration.setTimeToIdleSeconds(tti);
    }

    public long getTimeToLiveSeconds() {
        return this.cacheConfiguration.getTimeToLiveSeconds();
    }

    public void setTimeToLiveSeconds(long ttl) {
        this.cacheConfiguration.setTimeToLiveSeconds(ttl);
    }

    public boolean isOverflowToDisk() {
        return this.cacheConfiguration.isOverflowToDisk();
    }

    public void setOverflowToDisk(boolean overflowToDisk) {
        this.cacheConfiguration.setOverflowToDisk(overflowToDisk);
    }

    public boolean isDiskPersistent() {
        return this.cacheConfiguration.isDiskPersistent();
    }

    public void setDiskPersistent(boolean diskPersistent) {
        this.cacheConfiguration.setDiskPersistent(diskPersistent);
    }

    public int getDiskSpoolBufferSizeMB() {
        return this.cacheConfiguration.getDiskSpoolBufferSizeMB();
    }

    public void setDiskSpoolBufferSizeMB(int diskSpoolBufferSizeMB) {
        this.cacheConfiguration.setDiskSpoolBufferSizeMB(diskSpoolBufferSizeMB);
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.cacheConfiguration.getDiskExpiryThreadIntervalSeconds();
    }

    public final void setDiskExpiryThreadIntervalSeconds(long diskExpiryThreadIntervalSeconds) {
        this.cacheConfiguration.setDiskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds);
    }

    public boolean isTerracottaClustered() {
        return this.cacheConfiguration.isTerracottaClustered();
    }

    ObjectName getObjectName() {
        return this.objectName;
    }

    public boolean isOverflowToOffHeap() {
        return this.cacheConfiguration.isOverflowToOffHeap();
    }

    public long getMaxMemoryOffHeapInBytes() {
        return this.cacheConfiguration.getMaxMemoryOffHeapInBytes();
    }
}

