/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.bean.list;

import com.google.common.collect.ArrayListMultimap;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.SimpleBean;
import org.nuiton.validator.bean.list.BeanListValidator;
import org.nuiton.validator.bean.list.BeanListValidatorEvent;
import org.nuiton.validator.bean.list.BeanListValidatorListener;

public class BeanListValidatorTest {
    private static final Log log = LogFactory.getLog(BeanListValidatorTest.class);
    protected BeanListValidator<SimpleBean> validator;
    protected SimpleBean bean;
    protected SimpleBean bean2;
    BeanValidatorListenerImpl fatalListener;
    BeanValidatorListenerImpl errorListener;
    BeanValidatorListenerImpl warningListener;
    BeanValidatorListenerImpl infoListener;
    private static final String STRING_VALUE_FATAL = "stringValue.fatal";
    private static final String STRING_VALUE_ERROR = "stringValue.error";
    private static final String STRING_VALUE_WARNING = "stringValue.warning";
    private static final String INT_VALUE_FATAL = "intValue.fatal";
    private static final String INT_VALUE_ERROR = "intValue.error";
    private static final String INT_VALUE_INFO = "intValue.info";

    @Before
    public void setUp() {
        this.bean = new SimpleBean();
        this.bean2 = new SimpleBean();
    }

    protected void prepareValidator(String context) {
        this.validator = BeanListValidator.newValidator(SimpleBean.class, (String)context, (NuitonValidatorScope[])new NuitonValidatorScope[0]);
        this.fatalListener = new BeanValidatorListenerImpl(NuitonValidatorScope.FATAL);
        this.validator.addBeanListValidatorListener((BeanListValidatorListener)this.fatalListener);
        this.errorListener = new BeanValidatorListenerImpl(NuitonValidatorScope.ERROR);
        this.validator.addBeanListValidatorListener((BeanListValidatorListener)this.errorListener);
        this.warningListener = new BeanValidatorListenerImpl(NuitonValidatorScope.WARNING);
        this.validator.addBeanListValidatorListener((BeanListValidatorListener)this.warningListener);
        this.infoListener = new BeanValidatorListenerImpl(NuitonValidatorScope.INFO);
        this.validator.addBeanListValidatorListener((BeanListValidatorListener)this.infoListener);
    }

    @After
    public void tearDown() {
        this.bean = null;
        this.bean2 = null;
        if (this.validator != null) {
            this.validator.removeAllBeans();
            this.validator = null;
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testValidateWithBad() {
        this.prepareValidator("marchepo");
    }

    @Test
    public void addBean() {
        this.prepareValidator(null);
        this.assertMessages(this.fatalListener, this.bean, new String[0]);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, new String[0]);
        this.validator.addBean((Object)this.bean);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        this.validator.addBean((Object)this.bean2);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        this.assertMessages(this.fatalListener, this.bean2, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean2, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean2, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean2, INT_VALUE_INFO);
    }

    @Test
    public void addAllBean() {
        this.prepareValidator(null);
        this.assertMessages(this.fatalListener, this.bean, new String[0]);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, new String[0]);
        this.assertMessages(this.fatalListener, this.bean2, new String[0]);
        this.assertMessages(this.errorListener, this.bean2, new String[0]);
        this.assertMessages(this.warningListener, this.bean2, new String[0]);
        this.assertMessages(this.infoListener, this.bean2, new String[0]);
        this.validator.addAllBeans(Arrays.asList(this.bean, this.bean2));
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        this.assertMessages(this.fatalListener, this.bean2, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean2, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean2, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean2, INT_VALUE_INFO);
    }

    @Test
    public void removeBean() {
        this.prepareValidator(null);
        this.assertMessages(this.fatalListener, this.bean, new String[0]);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, new String[0]);
        this.assertMessages(this.fatalListener, this.bean2, new String[0]);
        this.assertMessages(this.errorListener, this.bean2, new String[0]);
        this.assertMessages(this.warningListener, this.bean2, new String[0]);
        this.assertMessages(this.infoListener, this.bean2, new String[0]);
        this.validator.addBean((Object)this.bean);
        this.validator.addBean((Object)this.bean2);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        this.assertMessages(this.fatalListener, this.bean2, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean2, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean2, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean2, INT_VALUE_INFO);
        this.validator.removeBean((Object)this.bean);
        this.assertMessages(this.fatalListener, this.bean, new String[0]);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, new String[0]);
        this.validator.removeBean((Object)this.bean2);
        this.assertMessages(this.fatalListener, this.bean2, new String[0]);
        this.assertMessages(this.errorListener, this.bean2, new String[0]);
        this.assertMessages(this.warningListener, this.bean2, new String[0]);
        this.assertMessages(this.infoListener, this.bean2, new String[0]);
    }

    @Test
    public void removeAllBeans() {
        this.prepareValidator(null);
        this.assertMessages(this.fatalListener, this.bean, new String[0]);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, new String[0]);
        this.assertMessages(this.fatalListener, this.bean2, new String[0]);
        this.assertMessages(this.errorListener, this.bean2, new String[0]);
        this.assertMessages(this.warningListener, this.bean2, new String[0]);
        this.assertMessages(this.infoListener, this.bean2, new String[0]);
        this.validator.addBean((Object)this.bean);
        this.validator.addBean((Object)this.bean2);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        this.assertMessages(this.fatalListener, this.bean2, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean2, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean2, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean2, INT_VALUE_INFO);
        this.validator.removeAllBeans(Arrays.asList(this.bean, this.bean2));
        this.assertMessages(this.fatalListener, this.bean, new String[0]);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, new String[0]);
        this.assertMessages(this.fatalListener, this.bean2, new String[0]);
        this.assertMessages(this.errorListener, this.bean2, new String[0]);
        this.assertMessages(this.warningListener, this.bean2, new String[0]);
        this.assertMessages(this.infoListener, this.bean2, new String[0]);
    }

    @Test
    public void removeAllBeans2() {
        this.prepareValidator(null);
        this.assertMessages(this.fatalListener, this.bean, new String[0]);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, new String[0]);
        this.assertMessages(this.fatalListener, this.bean2, new String[0]);
        this.assertMessages(this.errorListener, this.bean2, new String[0]);
        this.assertMessages(this.warningListener, this.bean2, new String[0]);
        this.assertMessages(this.infoListener, this.bean2, new String[0]);
        this.validator.addBean((Object)this.bean);
        this.validator.addBean((Object)this.bean2);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        this.assertMessages(this.fatalListener, this.bean2, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean2, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean2, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean2, INT_VALUE_INFO);
        this.validator.removeAllBeans();
        this.assertMessages(this.fatalListener, this.bean, new String[0]);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, new String[0]);
        this.assertMessages(this.fatalListener, this.bean2, new String[0]);
        this.assertMessages(this.errorListener, this.bean2, new String[0]);
        this.assertMessages(this.warningListener, this.bean2, new String[0]);
        this.assertMessages(this.infoListener, this.bean2, new String[0]);
    }

    @Test
    public void validate() {
        this.prepareValidator(null);
        this.assertMessages(this.fatalListener, this.bean, new String[0]);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, new String[0]);
        if (log.isDebugEnabled()) {
            log.debug((Object)"- bean 1 ----------------------------------------------");
        }
        this.validator.addBean((Object)this.bean);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"- bean 1 ----------------------------------------------");
        }
        this.bean.setStringValue("one");
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"- bean 1 ----------------------------------------------");
        }
        this.bean.setStringValue("oneone");
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"- bean 1 ----------------------------------------------");
        }
        this.bean.setIntValue(1);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"- bean 1 ----------------------------------------------");
        }
        this.bean.setIntValue(10);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, new String[0]);
        if (log.isDebugEnabled()) {
            log.debug((Object)"- bean 1 ----------------------------------------------");
        }
        this.bean.setStringValue(null);
        this.bean.setIntValue(0);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"- bean 1 ----------------------------------------------");
        }
        this.bean.setStringValue("5");
        this.bean.setIntValue(5);
        this.assertMessages(this.fatalListener, this.bean, new String[0]);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"- bean 2 ----------------------------------------------");
        }
        this.validator.addBean((Object)this.bean2);
        this.assertMessages(this.fatalListener, this.bean2, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean2, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean2, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean2, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"- bean 2 ----------------------------------------------");
        }
        this.bean2.setStringValue("one");
        this.assertMessages(this.fatalListener, this.bean2, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean2, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean2, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean2, INT_VALUE_INFO);
    }

    @Test
    public void convert() {
        this.prepareValidator(null);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, new String[0]);
        this.assertMessages(this.infoListener, this.bean, new String[0]);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.validator.addBean((Object)this.bean);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        Object value = this.validator.convert((Object)this.bean, "intValue", "abc", Class.class);
        Assert.assertNull((Object)value);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, STRING_VALUE_ERROR, "error.convertor.class");
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.bean.setStringValue("one");
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, "error.convertor.class");
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        value = this.validator.convert((Object)this.bean, "intValue", "3", Integer.class);
        this.bean.setIntValue((Integer)value);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, new String[0]);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
        this.bean.setIntValue(-1);
        this.assertMessages(this.fatalListener, this.bean, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, this.bean, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, this.bean, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, this.bean, INT_VALUE_INFO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"-----------------------------------------------");
        }
    }

    void assertMessages(BeanValidatorListenerImpl listener, Object bean, String ... expected) {
        List<String> actual = listener.getMessages(bean);
        Assert.assertEquals((String)(" shoudl have " + Arrays.toString(expected) + " but had " + actual), (long)expected.length, (long)actual.size());
        for (String m : expected) {
            Assert.assertEquals((String)("could not find " + m + " in " + actual), (Object)true, (Object)actual.contains(m));
        }
    }

    class BeanValidatorListenerImpl
    implements BeanListValidatorListener {
        private final NuitonValidatorScope scope;
        private final ArrayListMultimap<Object, String> messages;

        public BeanValidatorListenerImpl(NuitonValidatorScope scope) {
            this.scope = scope;
            this.messages = ArrayListMultimap.create();
        }

        public ArrayListMultimap<Object, String> getMessages() {
            return this.messages;
        }

        public List<String> getMessages(Object bean) {
            return this.messages.get(bean);
        }

        public void onFieldChanged(BeanListValidatorEvent event) {
            Object[] messagesToAdd;
            if (this.scope != event.getScope()) {
                return;
            }
            Object bean = event.getBean();
            Object[] messagesToDelete = event.getMessagesToDelete();
            if (messagesToDelete != null && messagesToDelete.length > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.scope + "[" + bean + "] messages to delete : " + Arrays.toString(messagesToDelete)));
                }
                for (String string : messagesToDelete) {
                    this.messages.remove(bean, (Object)string);
                }
            }
            if ((messagesToAdd = event.getMessagesToAdd()) != null && messagesToAdd.length > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.scope + "[" + bean + "] messages to add : " + Arrays.toString(messagesToAdd)));
                }
                this.messages.putAll(bean, Arrays.asList(messagesToAdd));
            }
        }
    }
}

