/*
 * Decompiled with CFR 0.152.
 */
package com.ezware.oxbow.swingbits.list;

import com.ezware.oxbow.swingbits.list.CheckListFilterType;
import com.ezware.oxbow.swingbits.list.ICheckListAction;
import com.ezware.oxbow.swingbits.list.ICheckListModel;
import com.ezware.oxbow.swingbits.util.IObjectToStringTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ActionCheckListModel<T>
implements ICheckListModel<T> {
    private final List<ListDataListener> listeners = Collections.synchronizedList(new ArrayList());
    private final ICheckListModel<T> originalModel;
    private final ICheckListAction<T> actionCheckAll = new ICheckListAction.CheckAll();
    private final List<ICheckListAction<T>> actionItems = Arrays.asList(this.actionCheckAll);
    private final Set<ICheckListAction<T>> checks = new HashSet<ICheckListAction<T>>();

    public ActionCheckListModel(final ICheckListModel<T> originalModel) {
        if (originalModel == null) {
            throw new NullPointerException();
        }
        this.originalModel = originalModel;
        this.originalModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                ListDataEvent event = ActionCheckListModel.this.toDecoratedEvent(e);
                for (ListDataListener l : ActionCheckListModel.this.listeners) {
                    l.intervalAdded(event);
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ListDataEvent event = ActionCheckListModel.this.toDecoratedEvent(e);
                for (ListDataListener l : ActionCheckListModel.this.listeners) {
                    l.intervalRemoved(event);
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ListDataEvent event = ActionCheckListModel.this.toDecoratedEvent(e);
                for (ListDataListener l : ActionCheckListModel.this.listeners) {
                    l.contentsChanged(event);
                }
                if (originalModel.getCheckedItems().size() < originalModel.getSize()) {
                    ActionCheckListModel.this.checks.remove(ActionCheckListModel.this.actionCheckAll);
                } else {
                    ActionCheckListModel.this.checks.add(ActionCheckListModel.this.actionCheckAll);
                }
                ActionCheckListModel.this.fireListDataChanged();
            }
        });
    }

    @Override
    public int getSize() {
        return this.originalModel.getSize() + this.actionItems.size();
    }

    public Object getElementAt(int index) {
        if (this.isDecoratedIndex(index)) {
            return this.actionItems.get(index);
        }
        return this.originalModel.getElementAt(this.toOriginalIndex(index));
    }

    private int toOriginalIndex(int index) {
        return index - this.actionItems.size();
    }

    private int toDecoratedIndex(int index) {
        return index + this.actionItems.size();
    }

    private boolean isDecoratedIndex(int index) {
        int size = this.actionItems.size();
        return size > 0 && index >= 0 && index < size;
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    private void fireListDataChanged() {
        ListDataEvent e = new ListDataEvent(this, 0, 0, this.getSize());
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(e);
        }
    }

    private ListDataEvent toDecoratedEvent(ListDataEvent e) {
        return new ListDataEvent(e.getSource(), e.getType(), this.toDecoratedIndex(e.getIndex0()), this.toDecoratedIndex(e.getIndex1()));
    }

    @Override
    public boolean isCheckedIndex(int index) {
        if (this.isDecoratedIndex(index)) {
            return this.checks.contains(this.actionItems.get(index));
        }
        return this.originalModel.isCheckedIndex(this.toOriginalIndex(index));
    }

    @Override
    public void setCheckedIndex(int index, boolean value) {
        if (this.isDecoratedIndex(index)) {
            ICheckListAction<T> item = this.actionItems.get(index);
            item.check(this.originalModel, value);
            if (value) {
                this.checks.add(item);
            } else {
                this.checks.remove(item);
            }
            this.fireListDataChanged();
        } else {
            this.originalModel.setCheckedIndex(this.toOriginalIndex(index), value);
        }
    }

    @Override
    public Collection<T> getCheckedItems() {
        return this.originalModel.getCheckedItems();
    }

    @Override
    public void setCheckedItems(Collection<T> items) {
        this.originalModel.setCheckedItems(items);
    }

    @Override
    public void filter(String filter, IObjectToStringTranslator translator, CheckListFilterType filterType) {
        this.originalModel.filter(filter, translator, filterType);
    }
}

