/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.CustomTab;
import fr.ifremer.tutti.ui.swing.util.TabHandler;
import java.awt.Component;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JTabbedPane;

public abstract class AbstractTuttiTabContainerUIHandler<M>
extends AbstractTuttiUIHandler<M> {
    protected AbstractTuttiTabContainerUIHandler(TuttiUIContext context) {
        super(context);
    }

    protected abstract JTabbedPane getTabPanel();

    protected boolean onTabChanged(int currentIndex, int newIndex) {
        boolean result = true;
        if (currentIndex != newIndex) {
            TabHandler handler = this.getTabHandler(currentIndex);
            if (handler != null) {
                result = handler.onHideTab();
            }
            if ((handler = this.getTabHandler(newIndex)) != null) {
                handler.onShowTab();
            }
        }
        return result;
    }

    protected TabHandler getTabHandler(int index) {
        TuttiUI tuttiTab;
        Object handler;
        Component tab;
        TabHandler tabHandler = null;
        JTabbedPane tabPanel = this.getTabPanel();
        if (index >= 0 && index < tabPanel.getTabCount() && TuttiUI.class.isInstance(tab = tabPanel.getComponentAt(index)) && TabHandler.class.isInstance(handler = (tuttiTab = (TuttiUI)((Object)tabPanel.getComponentAt(index))).getHandler())) {
            tabHandler = (TabHandler)handler;
        }
        return tabHandler;
    }

    @Override
    protected void initUI(TuttiUI ui) {
        super.initUI(ui);
        final JTabbedPane tabPanel = this.getTabPanel();
        tabPanel.setModel(new DefaultSingleSelectionModel(){

            @Override
            public void setSelectedIndex(int index) {
                int currentIndex = tabPanel.getSelectedIndex();
                boolean mustChangeTab = AbstractTuttiTabContainerUIHandler.this.onTabChanged(currentIndex, index);
                if (mustChangeTab) {
                    super.setSelectedIndex(index);
                }
            }
        });
    }

    protected void setCustomTab(int index, AbstractTuttiBeanUIModel model) {
        this.getTabPanel().setTabComponentAt(index, new CustomTab(model));
    }
}

