/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.program;

import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.MainUI;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditProgramUIHandler
extends AbstractTuttiUIHandler<EditProgramUIModel> {
    private static final Log log = LogFactory.getLog(EditProgramUIHandler.class);
    private final EditProgramUI ui;
    private final PersistenceService persistenceService;

    public EditProgramUIHandler(TuttiUI parentUi, EditProgramUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext());
        this.ui = ui;
        this.persistenceService = this.context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        EditProgramUIModel model = new EditProgramUIModel();
        String surveyId = this.context.getProgramId();
        if (surveyId == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Edit new program");
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Edit existing program " + surveyId));
            }
            Program program = this.persistenceService.getProgram(surveyId);
            model.fromBean(program);
        }
        this.listModelIsModify(model);
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        EditProgramUIModel model = this.getModel();
        this.initBeanComboBox(this.ui.getZoneComboBox(), this.persistenceService.getAllProgramZone(), model.getZone());
        SwingValidator<EditProgramUIModel> validator = this.ui.getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        MainUI main = this.ui.getContextValue(MainUI.class, MainUI.class.getName());
        main.clearValidators();
        main.registerValidator(validator);
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        MainUI main = this.ui.getContextValue(MainUI.class, MainUI.class.getName());
        main.clearValidators();
    }

    @Override
    protected EditProgramUIModel getModel() {
        return this.ui.getModel();
    }

    public void cancel() {
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }

    public void save() {
        EditProgramUIModel model = this.getModel();
        Program bean = (Program)model.toBean();
        Program saved = TuttiEntities.isNew((IdAware)bean) ? this.persistenceService.createProgram(bean) : this.persistenceService.saveProgram(bean);
        this.context.setProgramId(saved.getId());
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }
}

