/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.fishing.environment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTableModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueEditor;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueRenderer;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;

public class EnvironmentTabUIHandler
extends AbstractTuttiTableUIHandler<EnvironmentRowModel, EnvironmentTabUIModel> {
    private static final Log log = LogFactory.getLog(EnvironmentTabUIHandler.class);
    protected final EnvironmentTabUI ui;

    public EnvironmentTabUIHandler(EditFishingOperationUI parentUi, EnvironmentTabUI ui) {
        super(parentUi.getHandler().getContext(), "value");
        this.ui = ui;
    }

    protected EnvironmentTableModel getTableModel() {
        return (EnvironmentTableModel)this.getTable().getModel();
    }

    @Override
    protected JXTable getTable() {
        return this.ui.getEnvironmentTable();
    }

    @Override
    protected boolean isRowValid(EnvironmentRowModel row) {
        return row.getValue() != null;
    }

    @Override
    protected void onRowModified(int rowIndex, EnvironmentRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        super.onRowModified(rowIndex, row, propertyName, oldValue, newValue);
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<EnvironmentRowModel> rowMonitor, EnvironmentRowModel row) {
        if (row.isValid() && rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + (Object)((Object)row) + " was modified, will save it"));
            }
            this.showInformationMessage("[ Trait - Environnement ] Sauvegarde des modifications de " + (Object)((Object)row) + ".");
            this.saveRow(row);
            rowMonitor.clearModified();
            this.getModel().setModify(false);
        }
    }

    @Override
    protected EnvironmentTabUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    public void beforeInitUI() {
        EnvironmentTabUIModel model = new EnvironmentTabUIModel();
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        this.initBeanComboBox(this.ui.getNewRowKey(), Lists.newArrayList(), null);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Caracteristic.class, "withUnit"), EnvironmentTableModel.KEY);
        this.addColumnToModel((TableColumnModel)columnModel, new CaracteristicValueEditor(this.context), new CaracteristicValueRenderer(this.context), EnvironmentTableModel.VALUE);
        EnvironmentTableModel tableModel = new EnvironmentTableModel((TableColumnModel)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, EnvironmentRowModel oldRow, int newRowIndex, EnvironmentRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        this.getModel().setRemoveCaracteristicEnabled(newRow != null);
    }

    public void addRow() {
        BeanComboBox<Caracteristic> keyCombo = this.ui.getNewRowKey();
        Caracteristic selectedItem = (Caracteristic)keyCombo.getSelectedItem();
        EnvironmentRowModel row = this.getTableModel().createNewRow();
        row.setKey(selectedItem);
        this.getTableModel().addNewRow(row);
        EnvironmentTableModel tableModel = this.getTableModel();
        int rowIndex = tableModel.getRowCount() - 1;
        tableModel.fireTableRowsInserted(rowIndex, rowIndex);
        keyCombo.removeItem((Object)selectedItem);
        this.selectFirstInCombo(keyCombo);
        EnvironmentTabUIModel model = this.getModel();
        model.setModify(true);
        model.setValid(row.isValid());
    }

    public void reset(FishingOperation fishingOperation) {
        List protocolEnvironmentPmfmId;
        EnvironmentTableModel tableModel = this.getTableModel();
        EnvironmentTabUIModel model = this.getModel();
        model.setFishingOperation(fishingOperation);
        CaracteristicMap environmentCaracteristics = fishingOperation.getEnvironmentCaracteristics();
        if (environmentCaracteristics == null) {
            environmentCaracteristics = new CaracteristicMap();
        }
        TuttiProtocol protocol = this.ui.getContextValue(TuttiProtocol.class);
        ArrayList environmentPmfmIds = Lists.newArrayList();
        if (protocol != null && (protocolEnvironmentPmfmId = protocol.getEnvironmentPmfmId()) != null) {
            environmentPmfmIds.addAll(protocolEnvironmentPmfmId);
        }
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristics = Lists.newArrayList((Iterable)environmentCaracteristics.keySet());
        List<Caracteristic> availableCaracteristics = model.getAvailableCaracteristics();
        for (String id : environmentPmfmIds) {
            Caracteristic caracteristic = (Caracteristic)TuttiEntities.findById(availableCaracteristics, (String)id);
            if (caracteristics.contains(caracteristic)) continue;
            caracteristics.add(caracteristic);
        }
        for (Caracteristic key : caracteristics) {
            EnvironmentRowModel newRow = tableModel.createNewRow();
            newRow.setKey(key);
            newRow.setValue((Serializable)environmentCaracteristics.get((Object)key));
            rows.add(newRow);
        }
        model.setRows(rows);
        ArrayList caracteristicList = Lists.newArrayList();
        for (Caracteristic caracteristic : availableCaracteristics) {
            if (caracteristics.contains(caracteristic)) continue;
            caracteristicList.add(caracteristic);
        }
        this.ui.getNewRowKey().setData((List)caracteristicList);
        this.selectFirstInCombo(this.ui.getNewRowKey());
        model.setModify(false);
    }

    public void removeCaracteristic() {
        int rowIndex = this.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove caracteristic if no caracteristic selected");
        EnvironmentRowModel row = (EnvironmentRowModel)((Object)this.getTableModel().getEntry(rowIndex));
        FishingOperation fishingOperation = this.getModel().getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        fishingOperation.getEnvironmentCaracteristics().remove((Object)row.getKey());
        if (TuttiEntities.isNew((IdAware)fishingOperation)) {
            fishingOperation = this.persistenceService.createFishingOperation(fishingOperation);
        } else {
            this.persistenceService.saveFishingOperation(fishingOperation);
        }
        BeanComboBox<Caracteristic> keyCombo = this.ui.getNewRowKey();
        keyCombo.addItem((Object)row.getKey());
        this.selectFirstInCombo(keyCombo);
        this.getModel().getRows().remove(rowIndex);
        this.getTableModel().fireTableRowsDeleted(rowIndex, rowIndex);
    }

    protected void saveRow(EnvironmentRowModel row) {
        FishingOperation fishingOperation = this.getModel().getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        if (fishingOperation.getEnvironmentCaracteristics() == null) {
            fishingOperation.setEnvironmentCaracteristics(new CaracteristicMap());
        }
        fishingOperation.getEnvironmentCaracteristics().put((Object)row.getKey(), (Object)row.getValue());
        if (TuttiEntities.isNew((IdAware)fishingOperation)) {
            fishingOperation = this.persistenceService.createFishingOperation(fishingOperation);
        } else {
            this.persistenceService.saveFishingOperation(fishingOperation);
        }
    }
}

