/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.MainUI;
import fr.ifremer.tutti.ui.swing.RunTutti;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiConfig;
import fr.ifremer.tutti.ui.swing.config.TuttiConfigUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.widget.SwingSession;

public class MainUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext> {
    private static final Log log = LogFactory.getLog(MainUIHandler.class);
    protected MainUI ui;
    protected JComponent currentBody;
    protected final PersistenceService persistenceService;

    protected MainUIHandler(TuttiUIContext context, MainUI ui) {
        super(context);
        this.ui = ui;
        this.persistenceService = context.getService(PersistenceService.class);
        context.addMessageNotifier(this);
    }

    @Override
    public void beforeInitUI() {
        this.context.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (TuttiUIContext.ID_TO_SAVE_PROPERTIES.contains(propertyName)) {
                    MainUIHandler.this.changeTitle();
                } else if (propertyName.equals("screen")) {
                    MainUIHandler.this.setScreen((TuttiScreen)((Object)evt.getNewValue()));
                }
            }
        });
        this.ui.setContextValue(this.ui, MainUI.class.getName());
    }

    @Override
    public void afterInitUI() {
        ErrorDialogUI.init((Frame)this.ui);
        SwingSession swingSession = this.context.getSwingSession();
        swingSession.add((Component)this.ui);
        swingSession.save();
        this.changeTitle();
        JToolBar bar = this.ui.getBottomBar();
        this.ui.getStatus().addWidget((Component)bar, 0);
        TuttiScreen screen = TuttiScreen.SELECT_CRUISE;
        this.context.setScreen(screen);
    }

    @Override
    public void onCloseUI() {
        this.context.close();
    }

    @Override
    protected TuttiUIContext getModel() {
        return this.ui.getModel();
    }

    public void closeTutti() {
        RunTutti.closeTutti(this.ui, true);
    }

    public void reloadTutti() {
        RunTutti.closeTutti(this.ui, false);
        RunTutti.startTutti(this.context);
    }

    public void reloadApplication() {
    }

    public void reloadShortcuts() {
    }

    public void showConfig() {
        TuttiConfigUI configUI = new TuttiConfigUI(this.ui);
        configUI.createUI();
    }

    public void showManageProtocol() {
        this.context.setScreen(TuttiScreen.EDIT_PROTOCOL);
    }

    public void showSelectCampaign() {
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }

    public void showFillCatches() {
        this.context.setValidationContext("edit");
        this.context.setScreen(TuttiScreen.EDIT_FISHING_OPERATION);
    }

    public void showValidateCatches() {
        this.context.setValidationContext("validate");
        this.context.setScreen(TuttiScreen.EDIT_FISHING_OPERATION);
    }

    public void showImportScreen() {
    }

    public void showExportScreen() {
    }

    public void showAllegroScreen() {
    }

    public void showAbout() {
        ApplicationConfig applicationConfig = this.context.getConfig().getApplicationConfig();
        String iconPath = applicationConfig.getOption("application.icon.path");
        String name = "tutti-ui-swing";
        String licensePath = "META-INF/" + name + "-LICENSE.txt";
        String thirdPartyPath = "META-INF/" + name + "-THIRD-PARTY.txt";
        AboutPanel about = new AboutPanel();
        about.setTitle(I18n._((String)"tutti.title.about", (Object[])new Object[0]));
        about.setAboutText(I18n._((String)"tutti.about.message", (Object[])new Object[0]));
        TuttiConfig config = this.context.getConfig();
        int currentYear = Calendar.getInstance().get(1);
        int inceptionYear = config.getInceptionYear();
        String years = currentYear != inceptionYear ? inceptionYear + "-" + currentYear : inceptionYear + "";
        about.setBottomText(I18n._((String)"tutti.about.bottomText", (Object[])new Object[]{config.getOrganizationName(), years, config.getVersion()}));
        about.setIconPath(iconPath);
        about.setLicenseFile(licensePath);
        about.setThirdpartyFile(thirdPartyPath);
        about.buildTopPanel();
        about.init();
        about.showInDialog((Frame)this.ui, true);
        this.context.getSwingSession().add((Component)about);
    }

    public void gotoSite() {
        TuttiConfig config = this.context.getConfig();
        URL siteURL = config.getSiteUrl();
        if (log.isDebugEnabled()) {
            log.debug((Object)("goto " + siteURL));
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception e) {
                log.error((Object)("Failed to open '" + siteURL + "' in browser"), (Throwable)e);
                ErrorDialogUI.showError((Exception)e);
            }
        }
    }

    @Override
    public final void showInformationMessage(String message) {
        this.ui.getStatus().setStatus(message);
    }

    public void registerValidator(SwingValidator validator) {
        this.ui.getValidatorMessageWidget().registerValidator(validator);
    }

    public void clearValidators() {
        this.ui.getValidatorMessageWidget().clearValidators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setScreen(TuttiScreen screen) {
        try {
            TuttiUIUtil.updateBusyState(this.ui, true);
            if (this.currentBody != null) {
                TuttiUI body = (TuttiUI)((Object)this.currentBody);
                ((AbstractTuttiUIHandler)body.getHandler()).onCloseUI();
                this.context.getSwingSession().save();
                this.ui.getBody().remove((Component)this.currentBody);
                this.currentBody = null;
            }
            if (screen != null) {
                String screenTitle;
                JPanel screenUI;
                String programId = this.context.getProgramId();
                String cruiseId = this.context.getCruiseId();
                String protocolId = this.context.getProtocolId();
                switch (screen) {
                    default: {
                        screenUI = new SelectCruiseUI(this.context);
                        screenTitle = I18n._((String)"tutti.title.home", (Object[])new Object[0]);
                        break;
                    }
                    case EDIT_PROGRAM: {
                        screenTitle = programId == null ? I18n._((String)"tutti.title.create.program", (Object[])new Object[0]) : I18n._((String)"tutti.title.edit.program", (Object[])new Object[0]);
                        screenUI = new EditProgramUI(this.ui);
                        break;
                    }
                    case EDIT_CRUISE: {
                        screenTitle = cruiseId == null ? I18n._((String)"tutti.title.create.cruise", (Object[])new Object[0]) : I18n._((String)"tutti.title.edit.cruise", (Object[])new Object[0]);
                        screenUI = new EditCruiseUI(this.ui);
                        break;
                    }
                    case EDIT_PROTOCOL: {
                        screenTitle = protocolId == null ? I18n._((String)"tutti.title.create.protocol", (Object[])new Object[0]) : I18n._((String)"tutti.title.edit.protocol", (Object[])new Object[0]);
                        screenUI = new EditProtocolUI(this.ui);
                        break;
                    }
                    case EDIT_FISHING_OPERATION: {
                        String validationContext = this.context.getValidationContext();
                        screenTitle = "edit".equals(validationContext) ? I18n._((String)"tutti.title.edit.operations", (Object[])new Object[]{this.getSelectedCruiseTitle()}) : I18n._((String)"tutti.title.validate.operations", (Object[])new Object[]{this.getSelectedCruiseTitle()});
                        screenUI = new FishingOperationsUI(this.ui);
                    }
                }
                this.currentBody = screenUI;
                this.context.getSwingSession().add((Component)this.currentBody);
                this.ui.getBody().setTitle(screenTitle);
                this.ui.getBody().add((Component)this.currentBody);
            }
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            this.context.setScreen(TuttiScreen.SELECT_CRUISE);
        }
        finally {
            TuttiUIUtil.updateBusyState(this.ui, false);
        }
    }

    protected void changeTitle() {
        String title = this.getSelectedCruiseTitle();
        this.ui.setTitle("Tutti - v " + this.getConfig().getVersion() + " [ " + title + " ]");
    }

    protected String getSelectedCruiseTitle() {
        String title;
        String programId = this.context.getProgramId();
        if (programId == null) {
            title = I18n._((String)"tutti.title.noSelectedProgram", (Object[])new Object[0]);
        } else {
            Program program = this.persistenceService.getProgram(programId);
            title = I18n._((String)"tutti.title.selectedProgram", (Object[])new Object[]{program.getName()}) + " / ";
            String cruiseId = this.context.getCruiseId();
            if (cruiseId == null) {
                title = title + I18n._((String)"tutti.title.noSelectedCruise", (Object[])new Object[0]);
            } else {
                Cruise cruise = this.persistenceService.getCruise(cruiseId);
                title = title + I18n._((String)"tutti.title.selectedCruise", (Object[])new Object[]{cruise.getName()});
            }
            title = title + " / ";
            String protocolId = this.context.getProtocolId();
            if (protocolId == null) {
                title = title + I18n._((String)"tutti.title.noSelectedProtocol", (Object[])new Object[0]);
            } else {
                TuttiProtocol protocol = this.persistenceService.getProtocol(protocolId);
                title = title + I18n._((String)"tutti.title.selectedProtocol", (Object[])new Object[]{protocol.getName()});
            }
        }
        return title;
    }
}

