package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

/*
 * #%L
 * Tutti :: UI
 * $Id: SplitSpeciesBatchTableModel.java 135 2013-01-01 16:10:44Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/split/SplitSpeciesBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;

import javax.swing.table.TableColumnModel;

import static org.nuiton.i18n.I18n.n_;

/**
 * Table model of sample categories values.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class SplitSpeciesBatchTableModel
        extends AbstractTuttiTableModel<SplitSpeciesBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<SplitSpeciesBatchRowModel> EDITABLE_CATEGORY_VALUE = ColumnIdentifier.newId(
            SplitSpeciesBatchRowModel.PROPERTY_CATEGORY_VALUE,
            n_("tutti.table.species.sampleCategory.header.category"),
            n_("tutti.table.species.sampleCategory.header.category"));

    public static final ColumnIdentifier<SplitSpeciesBatchRowModel> READ_ONLY_CATEGORY_VALUE = ColumnIdentifier.newId(
            SplitSpeciesBatchRowModel.PROPERTY_CATEGORY_VALUE,
            n_("tutti.table.species.sampleCategory.header.category"),
            n_("tutti.table.species.sampleCategory.header.category"));

    public static final ColumnIdentifier<SplitSpeciesBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            SplitSpeciesBatchRowModel.PROPERTY_WEIGHT,
            n_("tutti.table.species.sampleCategory.header.weight"),
            n_("tutti.table.species.sampleCategory.header.weight"));

    private final SplitSpeciesBatchUIModel uiModel;

    public SplitSpeciesBatchTableModel(TableColumnModel columnModel,
                                       SplitSpeciesBatchUIModel uiModel,
                                       boolean createEmptyRowIsEmpty) {
        super(columnModel, createEmptyRowIsEmpty, createEmptyRowIsEmpty);
        this.uiModel = uiModel;
        setNoneEditableCols(READ_ONLY_CATEGORY_VALUE);
    }

    @Override
    public SplitSpeciesBatchRowModel createNewRow() {
        SplitSpeciesBatchRowModel result = new SplitSpeciesBatchRowModel();
        result.setCategoryType(uiModel.getSelectedCategory());
        result.setValid(false);
        return result;
    }

}