package fr.ifremer.tutti.ui.swing;

/*
 * #%L
 * Tutti :: UI
 * $Id: RunTutti.java 156 2013-01-07 22:58:44Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/RunTutti.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.config.TuttiConfig;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;

import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import java.awt.Color;
import java.util.Locale;

/**
 * To start Tutti application.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class RunTutti {

    /** Logger. */
    private static final Log log = LogFactory.getLog(RunTutti.class);

    public static void main(String... args) {

        // Create configuration
        TuttiConfig config = new TuttiConfig("tutti.properties", args);

        // Create application context
        final TuttiUIContext context = TuttiUIContext.newContext(config);

        // use our special classLoader (which will read some files from resources from a configuration directory)
        Thread.currentThread().setContextClassLoader(context.getResourceLoader());

        // Use shutdownHook to close context on System.exit
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable() {

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info("Close context on shutdown");
                }
                context.close();
            }
        }));

        // Initialize i18n
        I18n.init(new DefaultI18nInitializer("tutti-ui-swing"), Locale.UK);

        // Prepare ui look&feel and load ui properties
        try {
            SwingUtil.initNimbusLoookAndFeel();
        } catch (Exception e) {
            // could not find nimbus look-and-feel
            if (log.isWarnEnabled()) {
                log.warn("Failed to init nimbus look and feel");
            }
        }

        UIManager.put("Table.focusCellHighlightBorder",
                      new BorderUIResource.LineBorderUIResource(Color.BLACK));
        UIManager.put("BlockingLayerUI.blockingColor", new Color(50, 50, 50));

        startTutti(context);
    }

    public static void startTutti(TuttiUIContext context) {

        context.open();

        MainUI mainUI = new MainUI(context);
        mainUI.setVisible(true);
    }

    public static void closeTutti(MainUI ui, boolean exit) {

        ui.getHandler().getContext().getSwingSession().save();

        ui.getHandler().onCloseUI();

        ui.setVisible(false);
        ui.dispose();

        if (exit) {
            System.exit(0);
        }
    }

}