/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.table;

import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import java.awt.event.ActionEvent;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoveToNextEditableRowAction<M extends AbstractTuttiTableModel>
extends AbstractSelectTableAction<M> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MoveToNextEditableRowAction.class);

    public static <M extends AbstractTuttiTableModel> MoveToNextEditableRowAction<M> newAction(M model, JTable table) {
        return new MoveToNextEditableRowAction<M>(model, table);
    }

    protected MoveToNextEditableRowAction(M model, JTable table) {
        super(model, table);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int currentColumn;
        int currentRow = this.getSelectedRow();
        if (this.isCellEditable(currentRow, currentColumn = this.getSelectedColumn())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Move to next row editable cell " + this.getCellCoordinate(currentRow, currentColumn)));
            }
            if (++currentRow >= this.getRowCount()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No next row");
                }
                this.addNewRow();
            }
            this.doSelectCell(currentRow, currentColumn);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Cell not editable at " + this.getCellCoordinate(currentRow, currentColumn)));
        }
    }
}

