/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.species;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;

public class SpeciesFrequencyUIHandler
extends AbstractTuttiTableUIHandler<SpeciesFrequencyRowModel, SpeciesFrequencyUIModel> {
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUIHandler.class);
    private final SpeciesFrequencyUI ui;

    public SpeciesFrequencyUIHandler(TuttiUIContext context, SpeciesFrequencyUI ui) {
        super(context, "lengthStep", "number", "weight", "computedWeight");
        this.ui = ui;
    }

    @Override
    protected SpeciesFrequencyUIModel getModel() {
        return this.ui.getModel();
    }

    protected SpeciesFrequencyTableModel getTableModel() {
        return (SpeciesFrequencyTableModel)this.getTable().getModel();
    }

    @Override
    protected JXTable getTable() {
        return this.ui.getTable();
    }

    @Override
    protected TableColumnModel createTableColumnModel() {
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.LENGTH_STEP, "\\d{0,6}|\\d{1,6}.\\d{0,1}");
        this.addIntegerColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.NUMBER, "\\d{0,6}");
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}.\\d{0,3}");
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.COMPUTED_WEIGHT, "\\d{0,6}|\\d{1,6}.\\d{0,3}");
        return columnModel;
    }

    @Override
    protected void onRowModified(SpeciesFrequencyRowModel row, String propertyName, Object oldValue, Object newValue) {
        if ("number".equals(propertyName)) {
            this.computeComputedWeight(row);
        }
    }

    @Override
    protected void onRowValidStateChanged(SpeciesFrequencyRowModel row, Boolean oldValue, Boolean newValue) {
    }

    @Override
    protected void onRowModifyStateChanged(SpeciesFrequencyRowModel row, Boolean oldValue, Boolean newValue) {
    }

    @Override
    public void beforeInitUI() {
        SpeciesFrequencyUIModel model = new SpeciesFrequencyUIModel();
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        JXTable table = this.getTable();
        TableColumnModel columnModel = this.createTableColumnModel();
        SpeciesFrequencyUIModel model = this.getModel();
        SpeciesFrequencyTableModel tableModel = new SpeciesFrequencyTableModel(columnModel, model);
        table.setModel((TableModel)tableModel);
        table.setColumnModel(columnModel);
        this.installTableKeyListener(columnModel, (JTable)table);
        table.getTableHeader().setReorderingAllowed(false);
        table.addHighlighter(TuttiUIUtil.newBackgroundColorHighlighter(HighlightPredicate.READ_ONLY, Color.LIGHT_GRAY));
        this.listenRowsFromModel();
        model.setStep(0.5f);
        model.setMinStep(Float.valueOf(10.0f));
        model.setMaxStep(Float.valueOf(20.0f));
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE);
        SwingUtil.scrollToTableSelection((JTable)this.getTable());
        this.ui.getRafaleStepField().getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    Float step = (Float)SpeciesFrequencyUIHandler.this.ui.getRafaleStepField().getModel();
                    SpeciesFrequencyUIHandler.this.applyRafaleStep(step);
                }
            }
        });
    }

    @Override
    public void onCloseUI() {
    }

    public void generateLengthSteps() {
        SpeciesFrequencyUIModel model = this.getModel();
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = this.getTableModel().getRowCache();
        Float minStep = Float.valueOf(model.getLengthStep(model.getMinStep().floatValue()));
        Float maxStep = Float.valueOf(model.getLengthStep(model.getMaxStep().floatValue()));
        float step = model.getStep();
        for (float i = minStep.floatValue(); i <= maxStep.floatValue(); i += step) {
            if (rowsByStep.containsKey(Float.valueOf(i))) continue;
            SpeciesFrequencyRowModel newRow = new SpeciesFrequencyRowModel();
            newRow.setLengthStep(Float.valueOf(i));
            rowsByStep.put(Float.valueOf(i), newRow);
        }
        ArrayList rows = Lists.newArrayList(rowsByStep.values());
        model.setRows(rows);
    }

    public void applyRafaleStep(Float step) {
        int rowIndex;
        float aroundLengthStep;
        if (log.isInfoEnabled()) {
            log.info((Object)("Will apply rafale step: " + step));
        }
        SpeciesFrequencyUIModel model = this.getModel();
        SpeciesFrequencyTableModel tableModel = this.getTableModel();
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = tableModel.getRowCache();
        SpeciesFrequencyRowModel row = rowsByStep.get(Float.valueOf(aroundLengthStep = model.getLengthStep(step.floatValue())));
        if (row != null) {
            Integer number = row.getNumber();
            row.setNumber((number == null ? 0 : number) + 1);
            rowIndex = tableModel.updateRow(row);
        } else {
            row = new SpeciesFrequencyRowModel();
            row.setLengthStep(Float.valueOf(aroundLengthStep));
            row.setNumber(1);
            ArrayList steps = Lists.newArrayList(rowsByStep.keySet());
            steps.add(Float.valueOf(aroundLengthStep));
            Collections.sort(steps);
            rowIndex = steps.indexOf(Float.valueOf(aroundLengthStep));
            tableModel.addNewRow(rowIndex, row);
        }
        this.getTable().scrollRowToVisible(rowIndex);
    }

    public void editBatch(SpeciesBatchRowModel row) {
        List<SpeciesFrequencyRowModel> frequency = null;
        if (row != null) {
            frequency = row.getFrequency();
        }
        ArrayList editFrequency = CollectionUtils.isEmpty(frequency) ? Lists.newArrayList() : Lists.newArrayList(frequency);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will edit batch row: " + (Object)((Object)row) + " with " + editFrequency.size() + " frequency"));
        }
        this.getModel().setRows(editFrequency);
        this.getModel().setBatch(row);
    }

    public void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will close UI " + this.ui));
        }
        ArrayList frequency = Lists.newArrayList();
        for (SpeciesFrequencyRowModel row : this.getModel().getRows()) {
            if (!row.isValid()) continue;
            frequency.add(row);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Push back " + frequency.size() + " frequency to batch " + (Object)((Object)this.getModel().getBatch())));
        }
        this.getModel().getBatch().setFrequency(frequency);
        this.ui.editBatch(null);
        ((JDialog)SwingUtil.getParentContainer((Object)this.ui, JDialog.class)).setVisible(false);
    }

    protected void computeComputedWeight(SpeciesFrequencyRowModel row) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will recompute computed weight for frequency: " + row));
        }
    }
}

