/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.species;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Sex;
import fr.ifremer.tutti.persistence.entities.referential.SortedUnsortedCategory;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.WeightCategory;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.species.FrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesBatchTreeModel;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesBatchTreeNode;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.editor.AttachmentCellComponent;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextCellComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class SpeciesBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<SpeciesBatchRowModel, SpeciesBatchUIModel> {
    private static final Log log = LogFactory.getLog(SpeciesBatchUIHandler.class);
    public static final Set<String> RECOMPUTE_TOTAL_WEIGHT = Sets.newHashSet((Object[])new String[]{"sortedUnsortedCategory", "weight"});
    public static final Set<String> SAMPLING_PROPERTIES = Sets.newHashSet((Object[])new String[]{"species", "sortedUnsortedCategory", "weightCategory", "sex", "maturity", "age"});
    private final SpeciesBatchUI ui;

    public SpeciesBatchUIHandler(FishingOperationsUI parentUi, SpeciesBatchUI ui) {
        super(parentUi, new String[]{"sampleVracWeight", "totalHorsVracWeight", "totalVracWeight", "totalWeight"}, "speciesToConfirm", "species", "sortedUnsortedCategory", "weightCategory", "sex", "maturity", "age", "weight", "comment", "attachments", "frequency");
        this.ui = ui;
    }

    @Override
    protected SpeciesBatchUIModel getModel() {
        return this.ui.getModel();
    }

    protected SpeciesBatchTableModel getTableModel() {
        return (SpeciesBatchTableModel)this.getTable().getModel();
    }

    @Override
    protected JXTable getTable() {
        return this.ui.getTable();
    }

    @Override
    protected FishingOperation getFishingOperation() {
        return this.getModel().getFishingOperation();
    }

    @Override
    protected void onModelRowsChanged(List<SpeciesBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
        this.getModel().getSamplingTreeModel().populate(rows);
    }

    @Override
    protected String[] getRowPropertiesToIgnore() {
        return new String[]{"sampleWeight", "samplingRatio", "frequency"};
    }

    @Override
    protected TableColumnModel createTableColumnModel() {
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addBooleanColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SPECIES_TO_CONFIRM, (JTable)this.getTable());
        List allSpecies = this.persistenceService.getAllSpecies();
        Decorator<Species> decorator = this.getDecorator(Species.class, "byCode");
        this.addComboDataColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SPECIES_BY_CODE, decorator, allSpecies);
        decorator = this.getDecorator(Species.class, "byGenus");
        this.addComboDataColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SPECIES_BY_GENUS_CODE, decorator, allSpecies);
        decorator = this.getDecorator(SortedUnsortedCategory.class, null);
        List data = this.persistenceService.getAllSortedUnsortedCategory();
        this.addComboDataColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SORTED_UNSORTED_CATEGORY, decorator, data);
        decorator = this.getDecorator(WeightCategory.class, "byName");
        data = this.persistenceService.getAllWeightCategory();
        this.addComboDataColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.WEIGHT_CATEGORY, decorator, data);
        decorator = this.getDecorator(Sex.class, "byName");
        data = this.persistenceService.getAllSex();
        this.addComboDataColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SEX, decorator, data);
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.MATURITY, "\\d{0,6}|\\d{1,6}.\\d{0,3}");
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.AGE, "\\d{0,6}|\\d{1,6}.\\d{0,3}");
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}.\\d{0,3}");
        this.addColumnToModel((TableColumnModel)columnModel, FrequencyCellComponent.newEditor(this.ui.getFrequencyEditor()), FrequencyCellComponent.newRender(), SpeciesBatchTableModel.COMPUTED_WEIGHT);
        this.addColumnToModel((TableColumnModel)columnModel, FrequencyCellComponent.newEditor(this.ui.getFrequencyEditor()), FrequencyCellComponent.newRender(), SpeciesBatchTableModel.COMPUTED_NUMBER);
        this.addColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SAMPLE_WEIGHT);
        this.addColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SAMPLING_RATIO);
        this.addColumnToModel((TableColumnModel)columnModel, LongTextCellComponent.newEditor(this.ui.getLongTextEditor()), LongTextCellComponent.newRender(I18n.n_((String)"tutti.tooltip.comment.none", (Object[])new Object[0])), SpeciesBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellComponent.newEditor(this.ui.getAttachmentEditor()), AttachmentCellComponent.newRender(this.getDecorator(Attachment.class, null), I18n.n_((String)"tutti.tooltip.attachment.none", (Object[])new Object[0])), SpeciesBatchTableModel.ATTACHMENTS);
        return columnModel;
    }

    @Override
    protected void onRowModified(SpeciesBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        boolean rowWasValid;
        if (RECOMPUTE_TOTAL_WEIGHT.contains(propertyName)) {
            this.recomputeTotalHorsVrac();
        }
        SpeciesBatchUIModel model = this.getModel();
        SpeciesBatchTreeModel samplingTreeModel = model.getSamplingTreeModel();
        if (SAMPLING_PROPERTIES.contains(propertyName)) {
            SpeciesBatchTreeNode oldNode = samplingTreeModel.removeNodeFromCache(row);
            rowWasValid = row.isValid();
            if (oldNode != null && rowWasValid) {
                this.recomputeSuperSamplingRatio(samplingTreeModel, oldNode);
            }
            SpeciesBatchTreeNode newNode = samplingTreeModel.getSamplingNode(row);
            boolean rowValid = samplingTreeModel.isValid(row, newNode);
            row.setValid(rowValid);
            if (rowValid) {
                this.recomputeSuperSamplingRatio(samplingTreeModel, newNode);
            } else if (rowWasValid) {
                row.setSampleWeight(null);
                row.setSamplingRatio(null);
                this.getTableModel().updateSamplingRatio(Sets.newHashSet((Object[])new SpeciesBatchRowModel[]{row}));
            }
        }
        if ("weight".equals(propertyName)) {
            SpeciesBatchTreeNode node = samplingTreeModel.getSamplingNode(row);
            rowWasValid = row.isValid();
            boolean rowValid = samplingTreeModel.isValid(row, node);
            row.setValid(rowValid);
            if (rowValid) {
                this.recomputeSuperSamplingRatio(samplingTreeModel, node);
            } else if (rowWasValid) {
                this.recomputeSuperSamplingRatio(samplingTreeModel, node);
                row.setSampleWeight(null);
                row.setSamplingRatio(null);
                this.getTableModel().updateSamplingRatio(Sets.newHashSet((Object[])new SpeciesBatchRowModel[]{row}));
            }
        }
    }

    @Override
    protected void onRowValidStateChanged(SpeciesBatchRowModel row, Boolean oldValue, Boolean newValue) {
        int rowIndex = this.getTableModel().getRowIndex(row);
        if (rowIndex > -1) {
            this.getTableModel().fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    @Override
    protected void onRowModifyStateChanged(SpeciesBatchRowModel row, Boolean oldValue, Boolean newValue) {
    }

    @Override
    protected void saveSelectedRowIfRequired() {
        TuttiBeanMonitor rowMonitor = this.getRowMonitor();
        SpeciesBatchRowModel bean = (SpeciesBatchRowModel)((Object)rowMonitor.getBean());
        if (bean != null) {
            if (bean.isValid()) {
                if (rowMonitor.wasModified()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Row " + (Object)((Object)bean) + " was modified, will save it"));
                    }
                    this.saveRow(bean);
                    rowMonitor.clearModified();
                }
            } else {
                SpeciesBatch catchBean = (SpeciesBatch)bean.toBean();
                if (!TuttiEntities.isNew((IdAware)catchBean)) {
                    this.persistenceService.deleteSpeciesBatch(catchBean.getId());
                }
            }
        }
    }

    @Override
    protected boolean isRowValid(SpeciesBatchRowModel row) {
        SpeciesBatchUIModel model = this.getModel();
        SpeciesBatchTreeModel samplingTreeModel = model.getSamplingTreeModel();
        SpeciesBatchTreeNode node = samplingTreeModel.getSamplingNode(row);
        boolean rowValid = samplingTreeModel.isValid(row, node);
        return rowValid;
    }

    @Override
    protected void saveRow(SpeciesBatchRowModel row) {
        SpeciesBatch catchBean = (SpeciesBatch)row.toBean();
        FishingOperation fishingOperation = this.getModel().getFishingOperation();
        catchBean.setFishingOperation(fishingOperation);
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected fishingOperation: " + fishingOperation.getId()));
        }
        if (TuttiEntities.isNew((IdAware)catchBean)) {
            catchBean = this.persistenceService.createSpeciesBatch(catchBean);
            row.setId(catchBean.getId());
        } else {
            this.persistenceService.saveSpeciesBatch(catchBean);
        }
        List<SpeciesFrequencyRowModel> frequencyRows = row.getFrequency();
        List frequency = SpeciesFrequencyRowModel.toBeans(frequencyRows, catchBean);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save " + frequency.size() + " frequencies."));
        }
        frequency = this.persistenceService.saveSpeciesBatchFrequency(catchBean.getId(), frequency);
        frequencyRows = SpeciesFrequencyRowModel.fromBeans(frequency);
        row.setFrequency(frequencyRows);
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        String fishingoperationText;
        ArrayList rows;
        JXTable table = this.ui.getTable();
        if (table.isEditing()) {
            table.editingCanceled(null);
        }
        if (this.fishingOperationMonitor.wasModified()) {
            SpeciesBatchUIModel beanToSave = (SpeciesBatchUIModel)((Object)this.fishingOperationMonitor.getBean());
            FishingOperation fishingOperation = (FishingOperation)beanToSave.toBean();
            if (log.isInfoEnabled()) {
                log.info((Object)("FishingOperation " + fishingOperation.getId() + " was modified, will save it."));
            }
            this.persistenceService.saveFishingOperation(fishingOperation);
        }
        table.clearSelection();
        boolean empty = bean == null;
        SpeciesBatchUIModel model = this.getModel();
        if (empty) {
            rows = null;
            bean = new FishingOperation();
            model.setFishingOperation(null);
            fishingoperationText = "";
        } else {
            Decorator<FishingOperation> decorator = this.getDecorator(FishingOperation.class, null);
            fishingoperationText = I18n._((String)"tutti.label.traitReminder", (Object[])new Object[]{decorator.toString((Object)bean)});
            if (log.isInfoEnabled()) {
                log.info((Object)("Get species batch for fishingOperation: " + bean.getId() + " - " + fishingoperationText));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew((IdAware)bean)) {
                List catches = this.persistenceService.getAllSpeciesBatch(bean.getId());
                for (SpeciesBatch aBatch : catches) {
                    List frequencies = this.persistenceService.getAllSpeciesBatchFrequency(aBatch.getId());
                    SpeciesBatchRowModel entry = new SpeciesBatchRowModel(aBatch, frequencies);
                    rows.add(entry);
                }
            }
            model.setFishingOperation(bean);
        }
        model.fromBean(bean);
        model.setRows(rows);
        this.fishingOperationMonitor.clearModified();
        this.ui.getFishingOperationReminderLabel().setText(fishingoperationText);
    }

    @Override
    public void beforeInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("beforeInit: " + this.ui));
        }
        SpeciesBatchUIModel model = new SpeciesBatchUIModel();
        this.ui.setContextValue(model);
        this.fishingOperationMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        ArrayList samplingOrder = Lists.newArrayList((Object[])new String[]{"species", "sortedUnsortedCategory", "weightCategory", "sex", "maturity", "age"});
        this.getModel().setSamplingOrder(samplingOrder);
        JXTable table = this.getTable();
        TableColumnModel columnModel = this.createTableColumnModel();
        SpeciesBatchTableModel tableModel = new SpeciesBatchTableModel(columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel(columnModel);
        this.initBatchTable(table, columnModel, tableModel);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
    }

    protected void recomputeSuperSamplingRatio(SpeciesBatchTreeModel samplingTreeModel, SpeciesBatchTreeNode node) {
        SpeciesBatchTreeNode superSamplingNode = node.getParent();
        Preconditions.checkNotNull((Object)superSamplingNode, (Object)"Super sampling node can't be null");
        SpeciesBatchTreeModel.SamplingContext samplingContext = samplingTreeModel.createSamplingContext(superSamplingNode);
        float samplingTotalWeight = samplingContext.getTotalWeight();
        SpeciesBatchRowModel superSamplingRow = samplingContext.getSuperSamplingRow();
        Float superSamplingTotalWeight = superSamplingRow == null ? this.getModel().getTotalWeight() : superSamplingRow.getWeight();
        if (log.isInfoEnabled()) {
            log.info((Object)("Super sampling total weight: " + superSamplingTotalWeight));
        }
        Float samplingRatio = null;
        if (superSamplingTotalWeight != null) {
            samplingRatio = Float.valueOf(samplingTotalWeight / superSamplingTotalWeight.floatValue());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Sampling ratio: " + samplingRatio));
        }
        samplingContext.applyNewSampleValues(samplingTotalWeight, samplingRatio);
        this.getTableModel().updateSamplingRatio(samplingContext.getSamplingRows());
    }

    protected void recomputeTotalHorsVrac() {
        Float totalHorsVrac = Float.valueOf(0.0f);
        Float totalVrac = Float.valueOf(0.0f);
        for (SpeciesBatchRowModel batch : this.getModel().getRows()) {
            Float weight;
            SortedUnsortedCategory vracHorsVrac = batch.getSortedUnsortedCategory();
            if (vracHorsVrac == null) continue;
            boolean unsorted = "unsorted".equals(vracHorsVrac.getName());
            if (unsorted) {
                weight = batch.getWeight();
                if (weight == null) continue;
                totalHorsVrac = Float.valueOf(totalHorsVrac.floatValue() + weight.floatValue());
                continue;
            }
            weight = batch.getWeight();
            if (weight == null) continue;
            totalVrac = Float.valueOf(totalVrac.floatValue() + weight.floatValue());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("New total vrac / hors vrac: " + totalVrac + " / " + totalHorsVrac));
        }
        this.getModel().setTotalHorsVracWeight(totalHorsVrac);
    }
}

