package fr.ifremer.tutti.ui.swing.util.editor;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class LongTextEditorUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_PROPERTY = "property";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1TPW8TQRCdHHEcJ0QErIQggsRXvaaisRAJgSiJzIcwSBFuWPs28UbrvWV3jlwaxE/gJ0BPg0RHhSioKWgQfwEhClrE7J7js8EIxEl30u3Oe/Nm5s3LL1ByFs7t8SxjNtUoe4JtrW5v327viQ5eF65jpcHEQv5MRBC1YDYenDuEC62Gh9f68Npa0jOJFnoIXW/AjMMDJVxXCEQ4M4roOFdrDq7rmUntIetA1DjW59++Rs/ipy8igMyQujKVcvZvqKKSyQZEMkY4QZke85riepdkWKl3Se+cP1tT3LlbvCcewRMoN2DKcEtkCOf/veTAEfCZQaj0uNR3uBYK4fKOZXLHip6wDFNEyVLJ3D7lZylKxUQsiYg1Er17T2R4I/ze3zQm0E0hTBubGGHxAGHey2W+BJaXUERNtgXXIxH5cIuIcpfrWBERXPk/SRs5vmCcu7jV7NhEKV/qJYSTPnnWZxq68uGVAWoWiXMt0Rh6vDCC8elWreA+dKFAdFTixDVSSiiojiDy034GC6dHjEGWY4XlCk9MtKBkUzpGWGr97tK7dJX7c+kXf3rCcPtjsfrxzefX64emnKDcC2NDh3aKzNKfpfSpj+WO9C2v3eSm3oKKE4pmFhZueYywZv+axFG+42HWYWIb3HWJolT+9Pbd4sMPRyBahxmV8Hid+/hNqGDXUhcSFWfm6kpQdHR/mr7z9EZkHz8UWpLcDgSSiWah7Qgz+e9mx3e/FA4z6s3ymN4MBLYr779Xm69Whvtz6o/hRY9KD2BKaiW1CGvb38ixazprnEjjpNi8cbsIo+4xxvwE1pedyA0FAAA=";
    private static final Log log = LogFactory.getLog(LongTextEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Object bean;
    protected JButton closeButton;
    protected LongTextEditorUIHandler handler;
    protected LongTextEditorUI mainPanel = this;
    protected String property;
    protected JTextArea textContent;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LongTextEditorUI() {
        $initialize();
    }

    public LongTextEditorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__closeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.close();
    }

    public void doKeyReleased__on__textContent(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(((JTextArea)event.getSource()).getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Object getBean() {
        return bean;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public LongTextEditorUIHandler getHandler() {
        return handler;
    }

    public String getProperty() {
        return property;
    }

    public JTextArea getTextContent() {
        return textContent;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Object bean) {
        Object oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(closeButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("tutti.action.close"));
        closeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__closeButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new LongTextEditorUIHandler(this));
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    protected void createTextContent() {
        $objectMap.put("textContent", textContent = new JTextArea());
        
        textContent.setName("textContent");
        textContent.setColumns(15);
        textContent.setLineWrap(true);
        textContent.setWrapStyleWord(true);
        textContent.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textContent"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(textContent);
        
        // apply 1 property setters
        closeButton.setIcon(SwingUtil.createActionIcon("close"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainPanel", mainPanel);
        createProperty();
        createBean();
        createHandler();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTextContent();
        createCloseButton();
        // inline creation of mainPanel
        setName("mainPanel");
        
        $completeSetup();
    }

}