package fr.ifremer.tutti.ui.swing.content.operation.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class SpeciesFrequencyUI extends JPanel implements TuttiUI<SpeciesFrequencyUIModel, SpeciesFrequencyUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AUTO_GEN_MODE_BUTTON_SELECTED = "autoGenModeButton.selected";
    public static final String BINDING_GENERATE_BUTTON_ENABLED = "generateButton.enabled";
    public static final String BINDING_MAX_STEP_FIELD_MODEL = "maxStepField.model";
    public static final String BINDING_MAX_STEP_FIELD_NUMBER_PATTERN = "maxStepField.numberPattern";
    public static final String BINDING_MIN_STEP_FIELD_MODEL = "minStepField.model";
    public static final String BINDING_MIN_STEP_FIELD_NUMBER_PATTERN = "minStepField.numberPattern";
    public static final String BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED = "modeConfigurationLayout.selected";
    public static final String BINDING_RAFALE_MODE_BUTTON_SELECTED = "rafaleModeButton.selected";
    public static final String BINDING_RAFALE_STEP_FIELD_NUMBER_PATTERN = "rafaleStepField.numberPattern";
    public static final String BINDING_SIMPLE_MODE_BUTTON_SELECTED = "simpleModeButton.selected";
    public static final String BINDING_STEP_FIELD_MODEL = "stepField.model";
    public static final String BINDING_STEP_FIELD_NUMBER_PATTERN = "stepField.numberPattern";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected JRadioButton autoGenModeButton;
    protected JPanel autoGenModePanel;
    protected JButton closeButton;
    protected JPanel configurationPanel;
    protected JButton generateButton;
    protected SpeciesFrequencyUIHandler handler;
    protected SpeciesFrequencyUI homePanel = this;
    protected NumberEditor maxStepField;
    protected JLabel maxStepLabel;
    protected NumberEditor minStepField;
    protected JLabel minStepLabel;
    protected JAXXButtonGroup mode;
    protected CardLayout2Ext modeConfigurationLayout;
    protected JPanel modeConfigurationPanel;
    protected VBox modePanel;
    protected SpeciesFrequencyUIModel model;
    protected JRadioButton rafaleModeButton;
    protected JPanel rafaleModePanel;
    protected NumberEditor rafaleStepField;
    protected JLabel rafaleStepLabel;
    protected JRadioButton simpleModeButton;
    protected JLabel simpleModeLabel;
    protected JPanel simpleModePanel;
    protected NumberEditor stepField;
    protected JLabel stepLabel;
    protected JXTable table;
    protected JScrollPane tableScrollPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JSeparator $JSeparator0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          public void editBatch(SpeciesBatchRowModel row) {
              handler.editBatch(row);
          }
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesFrequencyUI(TuttiUIContext context) {
        SpeciesFrequencyUIHandler handler = new SpeciesFrequencyUIHandler(context, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public SpeciesFrequencyUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI() {
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__autoGenModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.AUTO_GEN);
    }

    public void doActionPerformed__on__closeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.close();
    }

    public void doActionPerformed__on__generateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.generateLengthSteps();
    }

    public void doActionPerformed__on__rafaleModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.RAFALE);
    }

    public void doActionPerformed__on__simpleModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public JRadioButton getAutoGenModeButton() {
        return autoGenModeButton;
    }

    public JPanel getAutoGenModePanel() {
        return autoGenModePanel;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public JButton getGenerateButton() {
        return generateButton;
    }

    public SpeciesFrequencyUIHandler getHandler() {
        return handler;
    }

    public NumberEditor getMaxStepField() {
        return maxStepField;
    }

    public JLabel getMaxStepLabel() {
        return maxStepLabel;
    }

    public NumberEditor getMinStepField() {
        return minStepField;
    }

    public JLabel getMinStepLabel() {
        return minStepLabel;
    }

    public JAXXButtonGroup getMode() {
        return mode;
    }

    public CardLayout2Ext getModeConfigurationLayout() {
        return modeConfigurationLayout;
    }

    public JPanel getModeConfigurationPanel() {
        return modeConfigurationPanel;
    }

    public VBox getModePanel() {
        return modePanel;
    }

    public SpeciesFrequencyUIModel getModel() {
        return model;
    }

    public JRadioButton getRafaleModeButton() {
        return rafaleModeButton;
    }

    public JPanel getRafaleModePanel() {
        return rafaleModePanel;
    }

    public NumberEditor getRafaleStepField() {
        return rafaleStepField;
    }

    public JLabel getRafaleStepLabel() {
        return rafaleStepLabel;
    }

    public JRadioButton getSimpleModeButton() {
        return simpleModeButton;
    }

    public JLabel getSimpleModeLabel() {
        return simpleModeLabel;
    }

    public JPanel getSimpleModePanel() {
        return simpleModePanel;
    }

    public NumberEditor getStepField() {
        return stepField;
    }

    public JLabel getStepLabel() {
        return stepLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(closeButton);
    }

    protected void addChildrenToAutoGenModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; autoGenModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(autoGenModeButton); }
    }

    protected void addChildrenToAutoGenModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        autoGenModePanel.add($Table0, BorderLayout.SOUTH);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add($JPanel0, BorderLayout.CENTER);
        configurationPanel.add($Table2, BorderLayout.SOUTH);
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToModeConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        modeConfigurationPanel.add(simpleModePanel, "simpleMode");
        modeConfigurationPanel.add(autoGenModePanel, "autoGenMode");
        modeConfigurationPanel.add(rafaleModePanel, "rafaleMode");
    }

    protected void addChildrenToModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        modePanel.add(simpleModeButton);
        modePanel.add(autoGenModeButton);
        modePanel.add(rafaleModeButton);
    }

    protected void addChildrenToRafaleModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; rafaleModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(rafaleModeButton); }
    }

    protected void addChildrenToRafaleModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        rafaleModePanel.add($Table1, BorderLayout.SOUTH);
    }

    protected void addChildrenToSimpleModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; simpleModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(simpleModeButton); }
    }

    protected void addChildrenToSimpleModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        simpleModePanel.add(simpleModeLabel, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
    }

    protected void createAutoGenModeButton() {
        $objectMap.put("autoGenModeButton", autoGenModeButton = new JRadioButton());
        
        autoGenModeButton.setName("autoGenModeButton");
        autoGenModeButton.setText(_("tutti.label.frequencyConfiguration.mode.autoGen"));
        { autoGenModeButton.putClientProperty("$value", "autoGenMode");  Object $buttonGroup = autoGenModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        autoGenModeButton.setToolTipText(_("tutti.label.frequencyConfiguration.mode.autoGen.tip"));
        autoGenModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__autoGenModeButton"));
    }

    protected void createAutoGenModePanel() {
        $objectMap.put("autoGenModePanel", autoGenModePanel = new JPanel());
        
        autoGenModePanel.setName("autoGenModePanel");
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("tutti.action.close"));
        closeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__closeButton"));
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new BorderLayout());
    }

    protected void createGenerateButton() {
        $objectMap.put("generateButton", generateButton = new JButton());
        
        generateButton.setName("generateButton");
        generateButton.setText(_("tutti.action.generate"));
        generateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__generateButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SpeciesFrequencyUIHandler.class));
    }

    protected void createMaxStepField() {
        $objectMap.put("maxStepField", maxStepField = new NumberEditor(this));
        
        maxStepField.setName("maxStepField");
        maxStepField.setProperty("maxStep");
        maxStepField.setUseFloat(true);
        maxStepField.setShowReset(true);
    }

    protected void createMaxStepLabel() {
        $objectMap.put("maxStepLabel", maxStepLabel = new JLabel());
        
        maxStepLabel.setName("maxStepLabel");
        maxStepLabel.setText(_("tutti.label.frequencyConfiguration.maxStep"));
    }

    protected void createMinStepField() {
        $objectMap.put("minStepField", minStepField = new NumberEditor(this));
        
        minStepField.setName("minStepField");
        minStepField.setProperty("minStep");
        minStepField.setUseFloat(true);
        minStepField.setShowReset(true);
    }

    protected void createMinStepLabel() {
        $objectMap.put("minStepLabel", minStepLabel = new JLabel());
        
        minStepLabel.setName("minStepLabel");
        minStepLabel.setText(_("tutti.label.frequencyConfiguration.minStep"));
    }

    protected void createMode() {
        $objectMap.put("mode", mode = new JAXXButtonGroup());
    }

    protected void createModeConfigurationLayout() {
        $objectMap.put("modeConfigurationLayout", modeConfigurationLayout = new CardLayout2Ext(this, "modeConfigurationPanel"));
    }

    protected void createModeConfigurationPanel() {
        $objectMap.put("modeConfigurationPanel", modeConfigurationPanel = new JPanel());
        
        modeConfigurationPanel.setName("modeConfigurationPanel");
        modeConfigurationPanel.setLayout(modeConfigurationLayout);
    }

    protected void createModePanel() {
        $objectMap.put("modePanel", modePanel = new VBox());
        
        modePanel.setName("modePanel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesFrequencyUIModel.class));
    }

    protected void createRafaleModeButton() {
        $objectMap.put("rafaleModeButton", rafaleModeButton = new JRadioButton());
        
        rafaleModeButton.setName("rafaleModeButton");
        rafaleModeButton.setText(_("tutti.label.frequencyConfiguration.mode.rafale"));
        { rafaleModeButton.putClientProperty("$value", "rafaleMode");  Object $buttonGroup = rafaleModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        rafaleModeButton.setToolTipText(_("tutti.label.frequencyConfiguration.mode.rafale.tip"));
        rafaleModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rafaleModeButton"));
    }

    protected void createRafaleModePanel() {
        $objectMap.put("rafaleModePanel", rafaleModePanel = new JPanel());
        
        rafaleModePanel.setName("rafaleModePanel");
    }

    protected void createRafaleStepField() {
        $objectMap.put("rafaleStepField", rafaleStepField = new NumberEditor(this));
        
        rafaleStepField.setName("rafaleStepField");
        rafaleStepField.setUseFloat(true);
        rafaleStepField.setShowReset(true);
    }

    protected void createRafaleStepLabel() {
        $objectMap.put("rafaleStepLabel", rafaleStepLabel = new JLabel());
        
        rafaleStepLabel.setName("rafaleStepLabel");
        rafaleStepLabel.setText(_("tutti.label.frequencyConfiguration.rafaleStep"));
    }

    protected void createSimpleModeButton() {
        $objectMap.put("simpleModeButton", simpleModeButton = new JRadioButton());
        
        simpleModeButton.setName("simpleModeButton");
        simpleModeButton.setText(_("tutti.label.frequencyConfiguration.mode.simple"));
        { simpleModeButton.putClientProperty("$value", "simpleMode");  Object $buttonGroup = simpleModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        simpleModeButton.setToolTipText(_("tutti.label.frequencyConfiguration.mode.simple.tip"));
        simpleModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleModeButton"));
    }

    protected void createSimpleModeLabel() {
        $objectMap.put("simpleModeLabel", simpleModeLabel = new JLabel());
        
        simpleModeLabel.setName("simpleModeLabel");
        simpleModeLabel.setEnabled(false);
        simpleModeLabel.setText(_("tutti.label.frequencyConfiguration.no.configuration"));
    }

    protected void createSimpleModePanel() {
        $objectMap.put("simpleModePanel", simpleModePanel = new JPanel());
        
        simpleModePanel.setName("simpleModePanel");
        simpleModePanel.setLayout(new BorderLayout());
    }

    protected void createStepField() {
        $objectMap.put("stepField", stepField = new NumberEditor(this));
        
        stepField.setName("stepField");
        stepField.setProperty("step");
        stepField.setUseFloat(true);
    }

    protected void createStepLabel() {
        $objectMap.put("stepLabel", stepLabel = new JLabel());
        
        stepLabel.setName("stepLabel");
        stepLabel.setText(_("tutti.label.frequencyConfiguration.step"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(modePanel, BorderLayout.WEST);
        $JPanel0.add(modeConfigurationPanel, BorderLayout.CENTER);
        addChildrenToModePanel();
        addChildrenToSimpleModeButton();
        addChildrenToAutoGenModeButton();
        addChildrenToRafaleModeButton();
        addChildrenToModeConfigurationPanel();
        addChildrenToSimpleModePanel();
        addChildrenToAutoGenModePanel();
        // inline complete setup of $Table0
        $Table0.add(minStepLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(minStepField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add(generateButton);
        addChildrenToRafaleModePanel();
        // inline complete setup of $Table1
        $Table1.add(rafaleStepLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(rafaleStepField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JSeparator0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(stepLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(stepField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToTableScrollPane();
        addChildrenToActionPanel();
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 31 property setters
        modePanel.setVerticalAlignment(SwingConstants.CENTER);
        configurationPanel.setBorder(new TitledBorder(null, _("tutti.legend.frequencyConfiguration")));
        simpleModeLabel.setHorizontalAlignment(JLabel.CENTER);
        minStepLabel.setLabelFor(minStepField);
        minStepField.setBean(model);
        minStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        minStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        maxStepLabel.setLabelFor(maxStepField);
        maxStepField.setBean(model);
        maxStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        maxStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        generateButton.setIcon(SwingUtil.createActionIcon("generate"));
        rafaleStepLabel.setLabelFor(rafaleStepField);
        rafaleStepField.setModelType(Float.class);
        rafaleStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rafaleStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        stepLabel.setLabelFor(stepField);
        stepField.setBean(model);
        stepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        stepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        closeButton.setIcon(SwingUtil.createActionIcon("close"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createModeConfigurationLayout();
        createConfigurationPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createModePanel();
        createSimpleModeButton();
        createAutoGenModeButton();
        createRafaleModeButton();
        createModeConfigurationPanel();
        createSimpleModePanel();
        createSimpleModeLabel();
        createAutoGenModePanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createMinStepLabel();
        createMinStepField();
        createMaxStepLabel();
        createMaxStepField();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createGenerateButton();
        createRafaleModePanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createRafaleStepLabel();
        createRafaleStepField();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createStepLabel();
        createStepField();
        createTableScrollPane();
        createTable();
        createActionPanel();
        createCloseButton();
        createMode();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (mode != null) {
                    mode.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (mode != null) {
                    modeConfigurationLayout.setSelected(String.valueOf(mode.getSelectedValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (mode != null) {
                    mode.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleModeButton.setSelected(model.isSimpleMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AUTO_GEN_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("autoGenMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    autoGenModeButton.setSelected(model.isAutoGenMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("autoGenMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rafaleMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleModeButton.setSelected(model.isRafaleMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rafaleMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MIN_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minStepField.setModel(model.getMinStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minStep", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MIN_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                minStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAX_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    maxStepField.setModel(model.getMaxStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxStep", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MAX_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                maxStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateButton.setEnabled(model.isCanGenerate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerate", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RAFALE_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                rafaleStepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setModel(model.getStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STEP_FIELD_NUMBER_PATTERN, true ,"DECIMAL1_PATTERN") {
        
            @Override
            public void processDataBinding() {
                stepField.setNumberPattern(DECIMAL1_PATTERN);
            }
        });
    }

}