package fr.ifremer.tutti.ui.swing.content.operation.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: SpeciesBatchTreeNode.java 54 2012-12-12 22:50:50Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/species/SpeciesBatchTreeNode.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.lang3.ObjectUtils;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import java.io.Serializable;
import java.util.Arrays;

/**
 * Defines a node of a species catches sampling.
 * <p/>
 * A path in the tree gives a sampling path.
 * <p/>
 * UserObject is the {@code samplingValue}. It can be null only on root node.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class SpeciesBatchTreeNode extends DefaultMutableTreeNode {

    private static final long serialVersionUID = 1L;

    /**
     * Property name defining the sampling.
     * <p/>
     * <strong>Note:</strong> can be null (only for root node).
     *
     * @since 0.2
     */
    protected final String samplingKey;

    public SpeciesBatchTreeNode() {
        this(null, null);
    }

    public SpeciesBatchTreeNode(String samplingKey,
                                Serializable samplingValue) {
        this.samplingKey = samplingKey;
        setUserObject(samplingValue);
    }

    public String getSamplingPropertyKey() {
        return samplingKey;
    }

    public boolean matchSamplingValue(Serializable value) {
        Serializable samplingValue = getUserObject();

        boolean result = ObjectUtils.equals(value, samplingValue);
        return result;
    }

    public SpeciesBatchTreeNode getChild(Serializable samplingValue) {
        SpeciesBatchTreeNode result = null;

        for (int i = 0, max = getChildCount(); i < max; i++) {
            SpeciesBatchTreeNode child = getChildAt(i);
            if (child.matchSamplingValue(samplingValue)) {

                // found matching child
                result = child;
                break;
            }
        }
        return result;
    }

    @Override
    public Serializable getUserObject() {
        return (Serializable) super.getUserObject();
    }

    @Override
    public SpeciesBatchTreeNode getChildAt(int index) {
        return (SpeciesBatchTreeNode) super.getChildAt(index);
    }

    @Override
    public SpeciesBatchTreeNode getParent() {
        return (SpeciesBatchTreeNode) super.getParent();
    }

    @Override
    public SpeciesBatchTreeNode getRoot() {
        return (SpeciesBatchTreeNode) super.getRoot();
    }

    @Override
    public SpeciesBatchTreeNode getFirstChild() {
        return (SpeciesBatchTreeNode) super.getFirstChild();
    }

    @Override
    public SpeciesBatchTreeNode getLastChild() {
        return (SpeciesBatchTreeNode) super.getLastChild();
    }

    @Override
    public SpeciesBatchTreeNode getChildAfter(TreeNode aChild) {
        return (SpeciesBatchTreeNode) super.getChildAfter(aChild);
    }

    @Override
    public SpeciesBatchTreeNode getChildBefore(TreeNode aChild) {
        return (SpeciesBatchTreeNode) super.getChildBefore(aChild);
    }

    @Override
    public SpeciesBatchTreeNode getNextSibling() {
        return (SpeciesBatchTreeNode) super.getNextSibling();
    }

    @Override
    public SpeciesBatchTreeNode getPreviousSibling() {
        return (SpeciesBatchTreeNode) super.getPreviousSibling();
    }

    @Override
    public SpeciesBatchTreeNode getFirstLeaf() {
        return (SpeciesBatchTreeNode) super.getFirstLeaf();
    }

    @Override
    public SpeciesBatchTreeNode getLastLeaf() {
        return (SpeciesBatchTreeNode) super.getLastLeaf();
    }

    @Override
    public SpeciesBatchTreeNode getNextLeaf() {
        return (SpeciesBatchTreeNode) super.getNextLeaf();
    }

    @Override
    public SpeciesBatchTreeNode getPreviousLeaf() {
        return (SpeciesBatchTreeNode) super.getPreviousLeaf();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SpeciesBatchTreeNode)) return false;

        SpeciesBatchTreeNode that = (SpeciesBatchTreeNode) o;

        Object[] path = getUserObjectPath();
        Object[] path2 = that.getUserObjectPath();
        return Arrays.equals(path, path2);
    }

}
