package fr.ifremer.tutti.ui.swing.content.operation.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id: BenthosBatchTableModel.java 77 2012-12-15 16:05:45Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/benthos/BenthosBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.content.operation.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;

import javax.swing.table.TableColumnModel;
import java.util.Set;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class BenthosBatchTableModel extends AbstractTuttiTableModel<BenthosBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<BenthosBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_SPECIES_TO_CONFIRM,
            n_("tutti.table.benthos.batch.header.toConfirm"),
            n_("tutti.table.benthos.batch.header.toConfirm"));

    public static final ColumnIdentifier<BenthosBatchRowModel> SPECIES_BY_CODE = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.table.benthos.batch.header.speciesByCode"),
            n_("tutti.table.benthos.batch.header.speciesByCode"));

    public static final ColumnIdentifier<BenthosBatchRowModel> SPECIES_BY_GENUS_CODE = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.table.benthos.batch.header.speciesByGenusCode"),
            n_("tutti.table.benthos.batch.header.speciesByGenusCode"));

    public static final ColumnIdentifier<BenthosBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_WEIGHT,
            n_("tutti.table.benthos.batch.header.weight"),
            n_("tutti.table.benthos.batch.header.weight"));

    public static final ColumnIdentifier<BenthosBatchRowModel> SAMPLE_WEIGHT = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_SAMPLE_WEIGHT,
            n_("tutti.table.benthos.batch.header.sampleWeight"),
            n_("tutti.table.benthos.batch.header.sampleWeight"));

    public static final ColumnIdentifier<BenthosBatchRowModel> SAMPLING_RATIO = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_SAMPLING_RATIO,
            n_("tutti.table.benthos.batch.header.elevationRate"),
            n_("tutti.table.benthos.batch.header.elevationRate"));

    public static final ColumnIdentifier<BenthosBatchRowModel> COMMENT = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_COMMENT,
            n_("tutti.table.benthos.batch.header.comment"),
            n_("tutti.table.benthos.batch.header.comment"));

    public static final ColumnIdentifier<BenthosBatchRowModel> ATTACHMENTS = ColumnIdentifier.newId(
            SpeciesBatchRowModel.PROPERTY_ATTACHMENTS,
            n_("tutti.table.benthos.batch.header.file"),
            n_("tutti.table.benthos.batch.header.file"));


    public BenthosBatchTableModel(TableColumnModel columnModel) {
        super(columnModel);

        setNoneEditableCols(SAMPLE_WEIGHT, SAMPLING_RATIO);
    }

    @Override
    protected BenthosBatchRowModel createNewRow() {
        BenthosBatchRowModel result = new BenthosBatchRowModel();

        // by default empty row is not valid
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue,
                           int rowIndex,
                           int columnIndex,
                           ColumnIdentifier<BenthosBatchRowModel> propertyName,
                           BenthosBatchRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);

        if (propertyName == SPECIES_BY_CODE) {

            // update also other columns
            fireTableCellUpdated(rowIndex,
                                 SPECIES_BY_GENUS_CODE);

        } else if (propertyName == SPECIES_BY_GENUS_CODE) {

            // update also other columns
            fireTableCellUpdated(rowIndex,
                                 SPECIES_BY_CODE);
        }
    }

    public void updateSamplingRatio(Set<BenthosBatchRowModel> rows) {
        for (BenthosBatchRowModel row : rows) {
            int rowIndex = getRows().indexOf(row);
            fireTableCellUpdated(rowIndex,
                                 SAMPLE_WEIGHT,
                                 SAMPLING_RATIO);
        }


    }

    @Override
    protected boolean isCellEditable(int rowIndex,
                                     int columnIndex,
                                     ColumnIdentifier<BenthosBatchRowModel> propertyName) {

        boolean result = super.isCellEditable(rowIndex,
                                              columnIndex,
                                              propertyName);

        return result;
    }
}