package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id: FishingOperationsUIModel.java 40 2012-12-11 14:19:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/FishingOperationsUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import org.jdesktop.beans.AbstractSerializableBean;

import java.util.List;

/**
 * Model fo UI {@link FishingOperationsUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class FishingOperationsUIModel extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_FISHING_OPERATION = "fishingOperation";

    public static final String PROPERTY_SELECTED_FISHING_OPERATION = "selectedFishingOperation";

    public static final String PROPERTY_CRUISE = "cruise";

    protected List<FishingOperation> fishingOperation;

    protected FishingOperation selectedFishingOperation;

    protected Cruise cruise;

    public List<FishingOperation> getFishingOperation() {
        return fishingOperation;
    }

    public void setFishingOperation(List<FishingOperation> fishingOperation) {
        this.fishingOperation = fishingOperation;
        firePropertyChange(PROPERTY_FISHING_OPERATION, null, fishingOperation);
    }

    public FishingOperation getSelectedFishingOperation() {
        return selectedFishingOperation;
    }

    public void setSelectedFishingOperation(FishingOperation selectedFishingOperation) {
        Object oldValue = getSelectedFishingOperation();
        this.selectedFishingOperation = selectedFishingOperation;
        firePropertyChange(PROPERTY_SELECTED_FISHING_OPERATION, oldValue, selectedFishingOperation);
    }

    public Cruise getCruise() {
        return cruise;
    }

    public void setCruise(Cruise cruise) {
        Object oldValue = getCruise();
        this.cruise = cruise;
        firePropertyChange(PROPERTY_CRUISE, oldValue, cruise);
    }
}
