package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id: FishingOperationTabUIHandler.java 55 2012-12-13 01:57:28Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/FishingOperationTabUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JLabel;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

/**
 * Handler for UI {@link FishingOperationTabUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class FishingOperationTabUIHandler extends AbstractTuttiUIHandler<FishingOperationTabUIModel> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(FishingOperationTabUIHandler.class);

    private final FishingOperationTabUI ui;

    private final FishingOperationsUI parentUi;

    private final PersistenceService persistenceService;

    public FishingOperationTabUIHandler(FishingOperationsUI parentUi, FishingOperationTabUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.parentUi = parentUi;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {

        FishingOperationTabUIModel model = new FishingOperationTabUIModel();
        model.addPropertyChangeListener(FishingOperationTabUIModel.PROPERTY_EMPTY, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JPanel form = ui.getFishingOperationPane();
                JLabel noContentPane = ui.getNoTraitPane();

                Boolean empty = (Boolean) evt.getNewValue();
                ui.remove(form);
                ui.remove(noContentPane);
                if (empty) {
                    ui.add(noContentPane, BorderLayout.CENTER);
                } else {
                    ui.add(form, BorderLayout.CENTER);
                }
                ui.repaint();
            }
        });

        listModelIsModify(model);

        ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {

        ui.getFishingOperationValidPanel().remove(
                ui.getFishingOperationResetRadio());

        FishingOperationTabUIModel model = ui.getModel();

        initUI(ui);

        initBeanList(ui.getSaisisseurList(),
                     persistenceService.getAllPerson(),
                     model.getSaisisseur());

        initBeanComboBox(ui.getBeaufortScaleComboBox(),
                         persistenceService.getAllBeaufortScale(),
                         model.getBeaufortScale());

        initBeanComboBox(ui.getStrataComboBox(),
                         persistenceService.getAllStrata(),
                         model.getStrata());

        initBeanComboBox(ui.getSeaStateComboBox(),
                         persistenceService.getAllSeaState(),
                         model.getSeaState());

        model.setEmpty(true);

        listenValidatorValid(ui.getValidator(), getModel());
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    protected FishingOperationTabUIModel getModel() {
        return ui.getModel();
    }

    public void selectFishingOperation(FishingOperation bean) {

        boolean empty = bean == null;

        FishingOperationTabUIModel model = getModel();

        if (empty) {

            model.fromBean(new FishingOperation());
        } else {

            model.fromBean(bean);
        }

        // update saisissuer selection
        List<Person> saisisseur = model.getSaisisseur();
        ui.getSaisisseurList().getModel().setSelected(saisisseur);

        // update model empty property
        model.setEmpty(empty);

        // if new fishingOperation can already cancel his creation
        model.setModify(!empty && model.isCreate());
    }

    public void cancel() {

        String id = getModel().getId();

        if (log.isInfoEnabled()) {
            log.info("Cancel edition for fishingOperation: " + id);
        }
        boolean newBean = StringUtils.isBlank(id);

        if (newBean) {

            // cancel to create a new fishingOperation
            parentUi.getHandler().selectFishingOperation(null);

        } else {

            // reselect in ui the fishingOperation
            FishingOperation selectedFishingOperation = parentUi.getModel().getSelectedFishingOperation();
            parentUi.getHandler().selectFishingOperation(selectedFishingOperation);
        }
    }

    public void save() {

        // get fishingOperation to save
        FishingOperation toSave = getModel().toBean();

        if (log.isInfoEnabled()) {
            log.info("Save edition for fishingOperation: " + toSave.getId());
        }

        // keep selected tab (to resotre it after save)
        int selectedIndex = ui.getFishingOperationTabPane().getSelectedIndex();

        // persist current fishingOperation
        parentUi.getHandler().saveFishingOperation(toSave);

        // reselect current tab
        ui.getFishingOperationTabPane().setSelectedIndex(selectedIndex);

        getModel().setModify(false);
    }

    public void importPupitri() {
        //TODO
    }

    public void importCasino() {
        //TODO
    }

    public void setGearShootingStartLatitude(String text) {
        getModel().setGearShootingStartLatitude(Float.valueOf(text));
    }

    public void setGearShootingStartLongitude(String text) {
        getModel().setGearShootingStartLongitude(Float.valueOf(text));
    }

    public void setGearShootingEndLatitude(String text) {
        getModel().setGearShootingEndLatitude(Float.valueOf(text));
    }

    public void setGearShootingEndLongitude(String text) {
        getModel().setGearShootingEndLongitude(Float.valueOf(text));
    }
}
