/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.HydrologicCaracteristicUtil;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditProtocolUIHandler
extends AbstractTuttiTableUIHandler<EditProtocolSpeciesRowModel, EditProtocolUIModel> {
    private static final Log log = LogFactory.getLog(EditProtocolUIHandler.class);
    private final EditProtocolUI ui;
    protected Map<String, Species> allSpecies;
    protected Map<String, Caracteristic> allLengthStepPmfm;
    protected Multimap<String, String> hydroCaracteristics;
    private final BiMap<ColumnIdentifier<EditProtocolSpeciesRowModel>, SampleCategoryEnum> columToSampleCategory;

    public EditProtocolUIHandler(TuttiUIContext context, EditProtocolUI ui) {
        super(context, new String[0]);
        this.ui = ui;
        this.columToSampleCategory = HashBiMap.create((int)SampleCategoryEnum.values().length);
        this.columToSampleCategory.put(EditProtocolSpeciesTableModel.SORTED_UNSORTED_ENABLED, (Object)SampleCategoryEnum.sortedUnsorted);
        this.columToSampleCategory.put(EditProtocolSpeciesTableModel.SIZE_ENABLED, (Object)SampleCategoryEnum.size);
        this.columToSampleCategory.put(EditProtocolSpeciesTableModel.SEX_ENABLED, (Object)SampleCategoryEnum.sex);
        this.columToSampleCategory.put(EditProtocolSpeciesTableModel.MATURITY_ENABLED, (Object)SampleCategoryEnum.maturity);
        this.columToSampleCategory.put(EditProtocolSpeciesTableModel.AGE_ENABLED, (Object)SampleCategoryEnum.age);
    }

    protected EditProtocolSpeciesTableModel getTableModel() {
        return (EditProtocolSpeciesTableModel)this.getTable().getModel();
    }

    @Override
    protected JXTable getTable() {
        return this.ui.getSpeciesTable();
    }

    @Override
    protected boolean isRowValid(EditProtocolSpeciesRowModel row) {
        boolean result = row.getLengthStepPmfm() != null;
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, EditProtocolSpeciesRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, EditProtocolSpeciesRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        if (row != null && row.isModify() && newValue != null && newValue.booleanValue()) {
            this.getModel().setModify(true);
        }
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<EditProtocolSpeciesRowModel> rowMonitor, EditProtocolSpeciesRowModel row) {
    }

    @Override
    protected EditProtocolUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    public void beforeInitUI() {
        EditProtocolUIModel model = new EditProtocolUIModel();
        this.listModelIsModify(model);
        this.ui.setContextValue(model);
        this.allSpecies = TuttiEntities.splitById((Iterable)this.persistenceService.getAllSpecies());
        this.allLengthStepPmfm = TuttiEntities.splitById((Iterable)this.persistenceService.getAllSpeciesLengthStepCaracteristic());
        this.hydroCaracteristics = ArrayListMultimap.create();
        for (Caracteristic caracteristic : this.persistenceService.getAllFishingOperationHydrologicCaracteristic()) {
            String name = HydrologicCaracteristicUtil.getGlobalName(caracteristic.getName());
            this.hydroCaracteristics.put((Object)name, (Object)caracteristic.getId());
        }
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        EditProtocolUIModel model = this.getModel();
        String protocolId = this.context.getProtocolId();
        TuttiProtocol protocol = null;
        if (protocolId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will create a new protocol");
            }
        } else {
            protocol = this.persistenceService.getProtocol(protocolId);
            model.fromBean(protocol);
        }
        SwingValidatorUtil.installUI((JTable)this.ui.getErrorTable(), (SwingValidatorMessageTableRenderer)new SwingValidatorMessageTableRenderer());
        this.listenValidatorValid((SimpleBeanValidator)this.ui.getValidator(), model);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class), EditProtocolSpeciesTableModel.SPECIES_ID);
        this.addComboDataColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.SIZE_FRENQUENCY_PMFM_ID, this.getDecorator(Caracteristic.class, null), Lists.newArrayList(this.allLengthStepPmfm.values()));
        BiMap sampleCategoryToColumn = this.columToSampleCategory.inverse();
        for (SampleCategoryEnum sampleOrder : model.getSampleCategoryOrder()) {
            ColumnIdentifier columnIdentifier = (ColumnIdentifier)sampleCategoryToColumn.get(sampleOrder);
            this.addBooleanColumnToModel((TableColumnModel)columnModel, columnIdentifier, (JTable)table);
        }
        columnModel.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                EditProtocolUIHandler.this.getModel().setModify(true);
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        EditProtocolSpeciesTableModel tableModel = new EditProtocolSpeciesTableModel((TableColumnModel)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        table.getTableHeader().setReorderingAllowed(true);
        ArrayList speciesList = Lists.newArrayList(this.allSpecies.values());
        ArrayList rows = Lists.newArrayList();
        if (protocol != null) {
            List speciesProtocols = protocol.getSpecies();
            if (CollectionUtils.isNotEmpty((Collection)speciesProtocols)) {
                for (SpeciesProtocol speciesProtocol : speciesProtocols) {
                    Species species = this.allSpecies.get(speciesProtocol.getSpeciesId());
                    speciesList.remove(species);
                    EditProtocolSpeciesRowModel row = tableModel.createNewRow();
                    row.setSpecies(species);
                    row.setLengthStepPmfm(this.allLengthStepPmfm.get(speciesProtocol.getLengthStepPmfmId()));
                    row.fromBean(speciesProtocol);
                    rows.add(row);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit protocol: " + protocolId + " with " + rows.size() + " species declared."));
            }
        }
        model.setRows(rows);
        this.initBeanComboBox(this.ui.getSpeciesComboBox(), speciesList, null);
        this.selectFirstInCombo(this.ui.getSpeciesComboBox());
        List gearPmfm = this.persistenceService.getAllFishingOperationGearCaracteristic();
        this.initDoubleList(this.ui.getGearList(), gearPmfm, model.getGearPmfmId());
        List environmentPmfm = this.persistenceService.getAllFishingOperationEnvironmentCaracteristic();
        this.initDoubleList(this.ui.getEnvironmentList(), environmentPmfm, model.getEnvironmentPmfmId());
        ArrayList selection = Lists.newArrayList();
        Set availableCaracteristicNames = this.hydroCaracteristics.keySet();
        ArrayList availableCaracteristics = Lists.newArrayList();
        for (String name : availableCaracteristicNames) {
            Caracteristic caracteristic = HydrologicCaracteristicUtil.createGlobalCaracteristic(name, null);
            availableCaracteristics.add(caracteristic);
        }
        List<String> hydrologyPmfm = model.getHydrologyPmfmId();
        if (hydrologyPmfm != null) {
            block3: for (String caracteristicName : availableCaracteristicNames) {
                Collection ids = this.hydroCaracteristics.get((Object)caracteristicName);
                for (String caracteristicId : hydrologyPmfm) {
                    if (!ids.contains(caracteristicId)) continue;
                    Caracteristic caracteristic = HydrologicCaracteristicUtil.createGlobalCaracteristic(caracteristicName, null);
                    selection.add(caracteristic);
                    continue block3;
                }
            }
        }
        this.initBeanList(this.ui.getHydrologyList(), availableCaracteristics, selection);
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, EditProtocolSpeciesRowModel oldRow, int newRowIndex, EditProtocolSpeciesRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        this.getModel().setRemoveSpeciesEnabled(newRow != null);
    }

    public void cancel() {
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }

    public void save() {
        EditProtocolUIModel model = this.getModel();
        TuttiProtocol bean = (TuttiProtocol)model.toBean();
        ArrayList protocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : this.getTableModel().getRows()) {
            if (!row.isValid()) continue;
            SpeciesProtocol protocol = (SpeciesProtocol)row.toBean();
            protocols.add(protocol);
        }
        bean.setSpecies((List)protocols);
        List hydroPmfm = bean.getHydrologyPmfmId();
        ArrayList allIds = Lists.newArrayList();
        if (hydroPmfm != null) {
            for (String id : hydroPmfm) {
                allIds.addAll(this.hydroCaracteristics.get((Object)id));
            }
        }
        bean.setHydrologyPmfmId((List)allIds);
        ArrayList sampleOrder = Lists.newArrayList();
        TableColumnModel columnModel = this.getTable().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            ColumnIdentifier identifier = (ColumnIdentifier)column.getIdentifier();
            SampleCategoryEnum sampleCategory = (SampleCategoryEnum)this.columToSampleCategory.get((Object)identifier);
            if (sampleCategory == null) continue;
            sampleOrder.add(sampleCategory);
        }
        bean.setSampleCategoryOrder((List)sampleOrder);
        TuttiProtocol saved = TuttiEntities.isNew((IdAware)bean) ? this.persistenceService.createProtocol(bean) : this.persistenceService.saveProtocol(bean);
        this.context.setProtocolId(saved.getId());
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }

    public void addRow() {
        Species species = (Species)this.ui.getSpeciesComboBox().getSelectedItem();
        EditProtocolSpeciesRowModel protocol = this.getTableModel().createNewRow();
        protocol.setSpecies(species);
        this.getTableModel().addNewRow(protocol);
        this.ui.getSpeciesComboBox().removeItem((Object)species);
        this.selectFirstInCombo(this.ui.getSpeciesComboBox());
    }

    public void removeSpecies() {
        int rowIndex = this.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove species if no species selected");
        this.getModel().getRows().remove(rowIndex);
        this.getTableModel().fireTableRowsDeleted(rowIndex, rowIndex);
    }

    protected void initDoubleList(BeanDoubleList<Caracteristic> widget, List<Caracteristic> availableCaracteristics, List<String> selectedCaracteristics) {
        ArrayList selection = Lists.newArrayList();
        if (selectedCaracteristics != null) {
            for (Caracteristic caracteristic : availableCaracteristics) {
                if (!selectedCaracteristics.contains(caracteristic.getId())) continue;
                selection.add(caracteristic);
            }
        }
        this.initBeanList(widget, availableCaracteristics, selection);
    }
}

