/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTreeNode;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class SpeciesBatchTreeModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final SpeciesBatchTreeNode root;
    protected String[] samplingOrder;
    protected final Map<SpeciesBatchRowModel, SpeciesBatchTreeNode> rowToNode;
    protected final Multimap<SpeciesBatchTreeNode, SpeciesBatchRowModel> nodeToRow;

    public SpeciesBatchTreeModel(String ... samplingOrder) {
        this.samplingOrder = samplingOrder;
        this.root = new SpeciesBatchTreeNode();
        this.rowToNode = Maps.newHashMap();
        this.nodeToRow = HashMultimap.create();
    }

    public String[] getSamplingOrder() {
        return this.samplingOrder;
    }

    public void setSamplingOrder(String ... samplingOrder) {
        this.samplingOrder = samplingOrder;
        this.clear();
    }

    protected void clear() {
        this.root.removeAllChildren();
        this.rowToNode.clear();
        this.nodeToRow.clear();
    }

    public SpeciesBatchTreeNode removeNodeFromCache(SpeciesBatchRowModel row) {
        SpeciesBatchTreeNode result = this.rowToNode.remove((Object)row);
        if (result != null) {
            this.nodeToRow.remove((Object)result, (Object)row);
        }
        return result;
    }

    public SpeciesBatchTreeNode getSamplingNode(SpeciesBatchRowModel row) {
        SpeciesBatchTreeNode result = this.rowToNode.get((Object)row);
        if (result == null) {
            result = this.getSamplingNode(this.root, 0, row);
            if (result == this.root) {
                result = null;
            } else {
                this.rowToNode.put(row, result);
                this.nodeToRow.put((Object)result, (Object)row);
            }
        }
        return result;
    }

    protected SpeciesBatchTreeNode getSamplingNode(SpeciesBatchTreeNode node, int samplingIndex, SpeciesBatchRowModel row) {
        SpeciesBatchTreeNode result;
        String samplingKey = this.samplingOrder[samplingIndex];
        Serializable samplingValue = (Serializable)TuttiUIUtil.getProperty((Object)row, samplingKey);
        if (samplingValue == null) {
            result = node;
        } else {
            result = node.getChild(samplingValue);
            if (result == null) {
                result = new SpeciesBatchTreeNode(samplingKey, samplingValue);
                node.add(result);
            }
            if (samplingIndex < this.samplingOrder.length) {
                result = this.getSamplingNode(result, samplingIndex + 1, row);
            }
        }
        return result;
    }

    public SpeciesBatchRowModel getNodeToRow(SpeciesBatchTreeNode node) {
        Collection rows = this.nodeToRow.get((Object)node);
        SpeciesBatchRowModel result = null;
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            for (SpeciesBatchRowModel next : rows) {
                if (!next.isValid()) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    public boolean isValid(SpeciesBatchRowModel row, SpeciesBatchTreeNode newNode) {
        boolean result;
        boolean bl = result = row.getWeight() != null && newNode != null;
        if (result && CollectionUtils.size((Object)this.nodeToRow.get((Object)newNode)) > 1) {
            result = false;
        }
        return result;
    }
}

