/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.swing.editor.bean.BeanDoubleListModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditFishingOperationUIHandler
extends AbstractTuttiUIHandler<EditFishingOperationUIModel> {
    private static final Log log = LogFactory.getLog(EditFishingOperationUIHandler.class);
    private final EditFishingOperationUI ui;
    private final FishingOperationsUI parentUi;
    private final PersistenceService persistenceService;
    private final TuttiBeanMonitor<EditFishingOperationUIModel> fishingOperationMonitor;

    public EditFishingOperationUIHandler(FishingOperationsUI parentUi, EditFishingOperationUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.parentUi = parentUi;
        this.persistenceService = this.context.getService(PersistenceService.class);
        this.fishingOperationMonitor = new TuttiBeanMonitor("stationNumber", "fishingOperationNumber", "date", "strata", "subStrata", "gearShootingStartLatitude", "gearShootingStartLongitude", "gearShootingStartDate", "gearShootingEndLatitude", "gearShootingEndLongitude", "gearShootingEndDate", "fishingOperationRectiligne", "distanceChalutee", "duree", "fishingOperationValid", "location", "comment", "saisisseur");
    }

    @Override
    public void beforeInitUI() {
        EditFishingOperationUIModel model = new EditFishingOperationUIModel();
        model.addPropertyChangeListener("empty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JPanel form = EditFishingOperationUIHandler.this.ui.getFishingOperationPane();
                JLabel noContentPane = EditFishingOperationUIHandler.this.ui.getNoTraitPane();
                Boolean empty = (Boolean)evt.getNewValue();
                EditFishingOperationUIHandler.this.ui.remove(form);
                EditFishingOperationUIHandler.this.ui.remove(noContentPane);
                if (empty.booleanValue()) {
                    EditFishingOperationUIHandler.this.ui.add((Component)noContentPane, "Center");
                } else {
                    EditFishingOperationUIHandler.this.ui.add((Component)form, "Center");
                }
                EditFishingOperationUIHandler.this.ui.repaint();
            }
        });
        model.addPropertyChangeListener("strata", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditFishingOperationUIModel source = (EditFishingOperationUIModel)((Object)evt.getSource());
                FishingOperationLocation newStrata = (FishingOperationLocation)evt.getNewValue();
                EditFishingOperationUIHandler.this.onSelectedStrata(source, newStrata);
            }
        });
        model.addPropertyChangeListener("subStrata", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditFishingOperationUIModel source = (EditFishingOperationUIModel)((Object)evt.getSource());
                FishingOperationLocation newStrata = (FishingOperationLocation)evt.getNewValue();
                EditFishingOperationUIHandler.this.onSelectedSubStrata(source, newStrata);
            }
        });
        this.ui.setContextValue(model);
        this.fishingOperationMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {
        this.ui.getFishingOperationValidPanel().remove(this.ui.getFishingOperationResetRadio());
        EditFishingOperationUIModel model = this.getModel();
        this.initUI(this.ui);
        this.initBeanList(this.ui.getSaisisseurList(), this.persistenceService.getAllPerson(), model.getSaisisseur());
        BeanDoubleListModel saisisseurModel = this.ui.getSaisisseurList().getModel();
        String programId = this.context.getProgramId();
        Program program = this.persistenceService.getProgram(programId);
        Zone zone = program.getZone();
        FishingOperationLocation strata = model.getStrata();
        String strataId = strata == null ? null : strata.getId();
        FishingOperationLocation subStrata = model.getSubStrata();
        String substrataId = subStrata == null ? null : subStrata.getId();
        FishingOperationLocation location = model.getLocation();
        List stratas = this.persistenceService.getAllFishingOperationStrata(zone.getId());
        List subStratas = strataId == null ? Lists.newArrayList() : this.persistenceService.getAllFishingOperationSubStrata(strataId);
        List locations = substrataId == null ? Lists.newArrayList() : this.persistenceService.getAllFishingOperationLocation(substrataId);
        this.initBeanComboBox(this.ui.getStrataComboBox(), stratas, strata);
        this.initBeanComboBox(this.ui.getSubStrataComboBox(), subStratas, subStrata);
        this.initBeanComboBox(this.ui.getLocationComboBox(), locations, location);
        model.setEmpty(true);
        this.listenValidatorValid((SimpleBeanValidator)this.ui.getValidator(), this.getModel());
        GearShootingTabUIModel gearShootingModel = this.ui.getGearShootingTabContent().getModel();
        gearShootingModel.setAvailableCaracteristics(this.persistenceService.getAllFishingOperationGearCaracteristic());
        EnvironmentTabUIModel environmentModel = this.ui.getEnvironmentTabContent().getModel();
        environmentModel.setAvailableCaracteristics(this.persistenceService.getAllFishingOperationEnvironmentCaracteristic());
        HydrologyTabUIModel hydrologyModel = this.ui.getHydrologyTabContent().getModel();
        hydrologyModel.setAvailableCaracteristics(this.persistenceService.getAllFishingOperationHydrologicCaracteristic());
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        this.closeUI(this.ui.getGearShootingTabContent());
        this.closeUI(this.ui.getEnvironmentTabContent());
        this.closeUI(this.ui.getHydrologyTabContent());
    }

    @Override
    protected EditFishingOperationUIModel getModel() {
        return this.ui.getModel();
    }

    public void selectFishingOperation(FishingOperation bean) {
        if (this.fishingOperationMonitor.wasModified()) {
            EditFishingOperationUIModel beanToSave = this.fishingOperationMonitor.getBean();
            if (beanToSave.isEmpty()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Won't save new fishing operation, use explicit save button instead...");
                }
            } else {
                FishingOperation toSave = (FishingOperation)beanToSave.toBean();
                this.showInformationMessage("[ Trait - Caract\u00e9ristiques g\u00e9n\u00e9rales ] Sauvegarde des modifications de " + this.decorate(toSave) + ".");
                if (log.isInfoEnabled()) {
                    log.info((Object)("FishingOperation " + toSave.getId() + " was modified, will save it."));
                }
                this.fishingOperationMonitor.clearModified();
                this.persistenceService.saveFishingOperation(toSave);
            }
        }
        boolean empty = bean == null;
        EditFishingOperationUIModel model = this.getModel();
        if (empty) {
            bean = new FishingOperation();
        }
        FishingOperationLocation strata = bean.getStrata();
        FishingOperationLocation subStrata = bean.getSubStrata();
        FishingOperationLocation location = bean.getLocation();
        model.fromBean(bean);
        model.setStrata(null);
        model.setSubStrata(null);
        model.setLocation(null);
        if (strata != null) {
            this.ui.getStrataComboBox().setSelectedItem((Object)strata);
        }
        if (subStrata != null) {
            this.ui.getSubStrataComboBox().setSelectedItem((Object)subStrata);
        }
        if (location != null) {
            this.ui.getLocationComboBox().setSelectedItem((Object)location);
        }
        model.setFishingOperation(bean);
        List<Person> saisisseur = model.getSaisisseur();
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected saisisseurs: " + (saisisseur == null ? 0 : saisisseur.size())));
        }
        this.ui.getSaisisseurList().getModel().setSelected(saisisseur);
        model.setEmpty(empty);
        GearShootingTabUI gearShootingTab = this.ui.getGearShootingTabContent();
        gearShootingTab.getHandler().reset(bean);
        EnvironmentTabUI environmentTab = this.ui.getEnvironmentTabContent();
        environmentTab.getHandler().reset(bean);
        HydrologyTabUI hydrologyTab = this.ui.getHydrologyTabContent();
        hydrologyTab.getHandler().reset(bean);
        this.fishingOperationMonitor.clearModified();
    }

    public void cancel() {
        boolean newBean;
        String id = this.getModel().getId();
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancel edition for fishingOperation: " + id));
        }
        if (newBean = StringUtils.isBlank((CharSequence)id)) {
            this.parentUi.getHandler().selectFishingOperation(null);
        } else {
            FishingOperation selectedFishingOperation = this.parentUi.getModel().getSelectedFishingOperation();
            this.parentUi.getHandler().selectFishingOperation(selectedFishingOperation);
        }
    }

    public void save() {
        FishingOperation toSave = (FishingOperation)this.getModel().toBean();
        if (log.isInfoEnabled()) {
            log.info((Object)("Save edition for fishingOperation: " + toSave.getId()));
        }
        int selectedIndex = this.ui.getFishingOperationTabPane().getSelectedIndex();
        this.fishingOperationMonitor.clearModified();
        this.parentUi.getHandler().saveFishingOperation(toSave);
        this.ui.getFishingOperationTabPane().setSelectedIndex(selectedIndex);
    }

    public void importCasino() {
    }

    public void setGearShootingStartLatitude(String text) {
        this.getModel().setGearShootingStartLatitude(Float.valueOf(text));
    }

    public void setGearShootingStartLongitude(String text) {
        this.getModel().setGearShootingStartLongitude(Float.valueOf(text));
    }

    public void setGearShootingEndLatitude(String text) {
        this.getModel().setGearShootingEndLatitude(Float.valueOf(text));
    }

    public void setGearShootingEndLongitude(String text) {
        this.getModel().setGearShootingEndLongitude(Float.valueOf(text));
    }

    protected void onSelectedStrata(EditFishingOperationUIModel model, FishingOperationLocation newStrata) {
        model.setSubStrata(null);
        this.ui.getSubStrataComboBox().setData(null);
        if (newStrata == null) {
            this.ui.getStrataComboBox().grabFocus();
        } else {
            List subStrata = this.persistenceService.getAllFishingOperationSubStrata(newStrata.getId());
            this.ui.getSubStrataComboBox().setData(subStrata);
            if (CollectionUtils.isEmpty((Collection)subStrata)) {
                List location = this.persistenceService.getAllFishingOperationLocation(newStrata.getId());
                this.ui.getLocationComboBox().setData(location);
                this.ui.getLocationComboBox().grabFocus();
            }
        }
    }

    protected void onSelectedSubStrata(EditFishingOperationUIModel model, FishingOperationLocation newSubStrata) {
        model.setLocation(null);
        this.ui.getLocationComboBox().setData(null);
        if (newSubStrata == null) {
            this.ui.getSubStrataComboBox().grabFocus();
        } else {
            List location = this.persistenceService.getAllFishingOperationLocation(newSubStrata.getId());
            this.ui.getLocationComboBox().setData(location);
        }
    }
}

