package fr.ifremer.tutti.ui.swing.content.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: TraitTabUIHandler.java 20 2012-11-26 10:27:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/catches/TraitTabUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.persistence.entities.UserBean;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JLabel;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.util.List;

/**
 * Handler for UI {@link TraitTabUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class TraitTabUIHandler extends AbstractTuttiUIHandler<TraitTabUIModel> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(TraitTabUIHandler.class);

    private final TraitTabUI ui;

    private final CatchesUI parentUi;

    private final PersistenceService persistenceService;

    public TraitTabUIHandler(CatchesUI parentUi, TraitTabUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.parentUi = parentUi;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {

        TraitTabUIModel model = new TraitTabUIModel();
        model.addPropertyChangeListener(TraitTabUIModel.PROPERTY_EMPTY, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JPanel form = ui.getTraitPane();
                JLabel noContentPane = ui.getNoTraitPane();

                Boolean empty = (Boolean) evt.getNewValue();
                ui.remove(form);
                ui.remove(noContentPane);
                if (empty) {
                    ui.add(noContentPane, BorderLayout.CENTER);
                } else {
                    ui.add(form, BorderLayout.CENTER);
                }
                ui.repaint();
            }
        });

        listModelIsModify(model);

        ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {

        TraitTabUIModel model = ui.getModel();

        initUI(ui);

        initBeanList(ui.getSaisisseurHeader(),
                     persistenceService.getAllUsers(),
                     model.getSaisisseur());

        initBeanComboBox(ui.getBeaufortScaleComboBox(),
                         persistenceService.getAllBeaufortScales(),
                         model.getBeaufortScale());

        initBeanComboBox(ui.getStrataComboBox(),
                         persistenceService.getAllStratas(),
                         model.getStrata());

        initBeanComboBox(ui.getSeaStateComboBox(),
                         persistenceService.getAllSeaStates(),
                         model.getSeaState());

        model.setEmpty(true);

        listenValidatorValid(ui.getValidator(), getModel());
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    protected TraitTabUIModel getModel() {
        return ui.getModel();
    }

    public void selectTrait(TraitBean bean) {

        boolean empty = bean == null;

        TraitTabUIModel model = ui.getModel();

        // clean previous selection
        ui.getSaisisseurHeader().getList().clearSelection();

        if (empty) {

            model.fromBean(new TraitBean());
        } else {

            model.fromBean(bean);
        }

        // update saisissuer selection
        List<UserBean> saisisseur = model.getSaisisseur();
        if (CollectionUtils.isNotEmpty(saisisseur)) {
            updateIndices(ui.getSaisisseurList(), saisisseur);
        }

        // update model empty property
        model.setEmpty(empty);

        // reload bean in validator (? really mandatory?)
//        ui.getValidator().reloadBean();

        // if new trait can already cancel his creation
        model.setModify(!empty && model.isCreate());
    }

    public void cancel() {

        String id = ui.getModel().getId();

        if (log.isInfoEnabled()) {
            log.info("Cancel edition for trait: " + id);
        }
        boolean newBean = StringUtils.isBlank(id);

        if (newBean) {

            // cancel to create a new trait
            parentUi.getHandler().selectTrait(null);

        } else {

            // reselect in ui the trait
            TraitBean selectedTrait = parentUi.getModel().getSelectedTrait();
            parentUi.getHandler().selectTrait(selectedTrait);
        }
    }

    public void save() {

        // get trait to save
        TraitBean toSave = ui.getModel().toBean();

        if (log.isInfoEnabled()) {
            log.info("Save edition for trait: " + toSave.getId());
        }

        // keep selected tab (to resotre it after save)
        int selectedIndex = ui.getTraitTabPane().getSelectedIndex();

        // persist current trait
        parentUi.getHandler().saveTrait(toSave);

        // reselect current tab
        ui.getTraitTabPane().setSelectedIndex(selectedIndex);
    }

    public void importPupitri() {
        //TODO
    }

    public void setGearShootingStartLatitude(String text) {
        ui.getModel().setGearShootingStartLatitude(Float.valueOf(text));
    }

    public void setGearShootingStartLongitude(String text) {
        ui.getModel().setGearShootingStartLongitude(Float.valueOf(text));
    }

    public void setGearShootingStartTime(String text) {
        ui.getModel().setGearShootingStartTime(Date.valueOf(text));
    }

    public void setGearShootingEndLatitude(String text) {
        ui.getModel().setGearShootingEndLatitude(Float.valueOf(text));
    }

    public void setGearShootingEndLongitude(String text) {
        ui.getModel().setGearShootingEndLongitude(Float.valueOf(text));
    }

    public void setGearShootingEndTime(String text) {
        ui.getModel().setGearShootingEndTime(Date.valueOf(text));
    }
}
