package fr.ifremer.tutti.ui.swing.content.campaign;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CampaignBean;
import fr.ifremer.tutti.persistence.entities.SurveyBean;
import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SelectCampaignUI extends JPanel implements TuttiUI<SelectCampaignUIModel, SelectCampaignUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CAMPAIGN_COMBOBOX_ENABLED = "campaignCombobox.enabled";
    public static final String BINDING_CAMPAIGN_COMBOBOX_SELECTED_ITEM = "campaignCombobox.selectedItem";
    public static final String BINDING_EDIT_CAMPAIGN_BUTTON_ENABLED = "editCampaignButton.enabled";
    public static final String BINDING_EDIT_SURVEY_BUTTON_ENABLED = "editSurveyButton.enabled";
    public static final String BINDING_NEW_CAMPAIGN_BUTTON_ENABLED = "newCampaignButton.enabled";
    public static final String BINDING_SHOW_CATCHES_BUTTON_ENABLED = "showCatchesButton.enabled";
    public static final String BINDING_SURVEY_COMBOBOX_SELECTED_ITEM = "surveyCombobox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WTW8bRRh+7cSOnTRN4vQLmkoGSmlVad2iHioFQXCQ1URuqWqQKnxh7J3EU61nltnZZqOoiJ/AL+DjzgWJGyfEgTMHLoi/gBAHroh3Zr+86y1Om1jyyvvO+/G8X8/4uz+h4kl47QkJAkv6XLExtXbff/z4w8ETOlQfUG8omauEhPBTKkO5D0t2IvcUvNHvavNWZN7aFmNXcMonrDe7sOipQ4d6I0qVgitZi6HntXrJ8Wbg+jL2moAq8vrN33+Vv7S/+LYMELiIbgVTac6ySjOZ70KZ2QoaGOkpaTmE7yMMyfg+4l3Wsm2HeN4DMqafweew0IWqSyQ6U/D68VM2Pox94Cqoj8SYPiScOgo296TF9iQdU2kpXylm+czyDjC+NRRcoTtrSMYuYfvc6lEH+7EdvX6847rGZ1XBwohw26FSQfsE/u6FTlK3lbGwNcitEzi9r11MIL36ERk49JaCS5kmhd7MmdasJwZLni+f0sMuGWgkDd2RINLeNUKt10jUz4bq2IyBGIhAwc2CMNRm2B1rQAm32vgw2m0RZF3Vru6aJt3KhzXSrO6qdtkzodtYICwKrGdsQqnWvpwYrXB6MGmjxc2synJc1yTVi7nAsUKcsZa/WpzIbf1+JXvW0MDjbuVgvJVorSHS2UreSKCWGo6ol1PCeBIuZzqB+26l+54uZKkPFemjGCekP00Rj/AoJIdLOXLQDs3pvxfWf/vxjx86MSMsY+zzhaoThIab6krh4goxHXolpANfMad1n7ibfah7ZrAN220UAOtFxwgO461pc0ubW/eIN0IXlYXff/r5wqe/zkG5A4uOIHaHaP0dqKuRxCoIxw7c97YMojMHNXyu4ndOwbyeU9ycI7ONzxQsstt3+UNJ9xjO90q4kBH4QwvpRffhEfU0yc4r6dMAq7VRUK0E8qD+yz/rve+34oqVMINXnqueVq3yCVQZdxinhkUjgixkzSXXo74tUiIsokZAcjwzuZARb9wxz7tTxSnpBGmAeTbCKjh6S6yQAgJfG22ZdPSvNmTJxJ3hvIxYwp5Te0fRMW502AFrn0arfv0GdqMWl15B9fmRc7w0Kzi2fYFyzYZ4N12M4jIvDNsRPrdN7Cj7tTB7nCcmuGE3HJLwbUcTNMxrWRGsKd46RlWioKuZoEgQuZhzxLaLQuZZ7xgRa6avHYH3W+MoT3hpGc5NDkGsVgQhy6qn1IvcsJxPhyVmzvy41P4P4xSxvxDMt4thNq9da8YHMapTnKaCy+R0B/1lZ276/jrG1KW43jzy2bb+oxOoicJFkg5zUGkS5bkMymF4IxbCmroxZ8FCxqs65FCgMpx9xyaKNAeM2/gX492pACX9XJzpUYu/0o+viz1snNjDdfTwH9zFKIplDAAA";
    private static final Log log = LogFactory.getLog(SelectCampaignUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected BeanComboBox<CampaignBean> campaignCombobox;
    protected JLabel campaignLabel;
    protected JButton editCampaignButton;
    protected JButton editSurveyButton;
    protected SelectCampaignUIHandler handler;
    protected SelectCampaignUI homePanel = this;
    protected SelectCampaignUIModel model;
    protected JButton newCampaignButton;
    protected JButton newSurveyButton;
    protected JButton showCatchesButton;
    protected BeanComboBox<SurveyBean> surveyCombobox;
    protected JLabel surveyLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiUIContext uiContext;
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectCampaignUI(TuttiUIContext context) {
        this.uiContext = context;
                SelectCampaignUIHandler handler = new SelectCampaignUIHandler(context, this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public SelectCampaignUI() {
        $initialize();
    }

    public SelectCampaignUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCampaignUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectCampaignUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCampaignUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectCampaignUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCampaignUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectCampaignUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__editCampaignButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showSelectedCampaign();
    }

    public void doActionPerformed__on__editSurveyButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showSelectedSurvey();
    }

    public void doActionPerformed__on__newCampaignButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showNewCampaign();
    }

    public void doActionPerformed__on__newSurveyButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showNewSurvey();
    }

    public void doActionPerformed__on__showCatchesButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showCatches();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanComboBox<CampaignBean> getCampaignCombobox() {
        return campaignCombobox;
    }

    public JLabel getCampaignLabel() {
        return campaignLabel;
    }

    public JButton getEditCampaignButton() {
        return editCampaignButton;
    }

    public JButton getEditSurveyButton() {
        return editSurveyButton;
    }

    public SelectCampaignUIHandler getHandler() {
        return handler;
    }

    public SelectCampaignUIModel getModel() {
        return model;
    }

    public JButton getNewCampaignButton() {
        return newCampaignButton;
    }

    public JButton getNewSurveyButton() {
        return newSurveyButton;
    }

    public JButton getShowCatchesButton() {
        return showCatchesButton;
    }

    public BeanComboBox<SurveyBean> getSurveyCombobox() {
        return surveyCombobox;
    }

    public JLabel getSurveyLabel() {
        return surveyLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createCampaignCombobox() {
        $objectMap.put("campaignCombobox", campaignCombobox = new BeanComboBox<CampaignBean>(this));
        
        campaignCombobox.setName("campaignCombobox");
        campaignCombobox.setI18nPrefix("tutti.property.");
        campaignCombobox.setProperty("campaign");
        campaignCombobox.setShowReset(true);
    }

    protected void createCampaignLabel() {
        $objectMap.put("campaignLabel", campaignLabel = new JLabel());
        
        campaignLabel.setName("campaignLabel");
        campaignLabel.setText(_("tutti.label.campaign"));
    }

    protected void createEditCampaignButton() {
        $objectMap.put("editCampaignButton", editCampaignButton = new JButton());
        
        editCampaignButton.setName("editCampaignButton");
        editCampaignButton.setText(_("tutti.action.edit"));
        editCampaignButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editCampaignButton"));
    }

    protected void createEditSurveyButton() {
        $objectMap.put("editSurveyButton", editSurveyButton = new JButton());
        
        editSurveyButton.setName("editSurveyButton");
        editSurveyButton.setText(_("tutti.action.edit"));
        editSurveyButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editSurveyButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SelectCampaignUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SelectCampaignUIModel.class));
    }

    protected void createNewCampaignButton() {
        $objectMap.put("newCampaignButton", newCampaignButton = new JButton());
        
        newCampaignButton.setName("newCampaignButton");
        newCampaignButton.setText(_("tutti.action.new"));
        newCampaignButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newCampaignButton"));
    }

    protected void createNewSurveyButton() {
        $objectMap.put("newSurveyButton", newSurveyButton = new JButton());
        
        newSurveyButton.setName("newSurveyButton");
        newSurveyButton.setText(_("tutti.action.new"));
        newSurveyButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newSurveyButton"));
    }

    protected void createShowCatchesButton() {
        $objectMap.put("showCatchesButton", showCatchesButton = new JButton());
        
        showCatchesButton.setName("showCatchesButton");
        showCatchesButton.setText(_("tutti.action.catches"));
        showCatchesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__showCatchesButton"));
    }

    protected void createSurveyCombobox() {
        $objectMap.put("surveyCombobox", surveyCombobox = new BeanComboBox<SurveyBean>(this));
        
        surveyCombobox.setName("surveyCombobox");
        surveyCombobox.setI18nPrefix("tutti.property.");
        surveyCombobox.setProperty("survey");
        surveyCombobox.setShowReset(true);
    }

    protected void createSurveyLabel() {
        $objectMap.put("surveyLabel", surveyLabel = new JLabel());
        
        surveyLabel.setName("surveyLabel");
        surveyLabel.setText(_("tutti.label.survey"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        // inline complete setup of $Table0
        $Table0.add(surveyLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(surveyCombobox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(campaignLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(campaignCombobox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(showCatchesButton, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(editSurveyButton);
        $JPanel0.add(newSurveyButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(editCampaignButton);
        $JPanel1.add(newCampaignButton);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        surveyCombobox.setBean(model);
        editSurveyButton.setIcon(SwingUtil.createActionIcon("edit"));
        newSurveyButton.setIcon(SwingUtil.createActionIcon("add"));
        campaignLabel.setLabelFor(campaignCombobox);
        campaignCombobox.setBean(model);
        editCampaignButton.setIcon(SwingUtil.createActionIcon("edit"));
        newCampaignButton.setIcon(SwingUtil.createActionIcon("add"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createSurveyLabel();
        createSurveyCombobox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createEditSurveyButton();
        createNewSurveyButton();
        createCampaignLabel();
        createCampaignCombobox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createEditCampaignButton();
        createNewCampaignButton();
        createShowCatchesButton();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SURVEY_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("survey", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    surveyCombobox.setSelectedItem(model.getSurvey());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("survey", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_SURVEY_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("surveyFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editSurveyButton.setEnabled(model.isSurveyFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("surveyFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CAMPAIGN_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("surveyFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    campaignCombobox.setEnabled(model.isSurveyFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("surveyFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CAMPAIGN_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("campaign", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    campaignCombobox.setSelectedItem(model.getCampaign());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("campaign", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CAMPAIGN_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("surveyFound", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("campaignFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editCampaignButton.setEnabled(model.isSurveyFound() && model.isCampaignFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("surveyFound", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("campaignFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_CAMPAIGN_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("surveyFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    newCampaignButton.setEnabled(model.isSurveyFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("surveyFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SHOW_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.addPropertyChangeListener("campaignContextFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (uiContext != null) {
                    showCatchesButton.setEnabled(uiContext.isCampaignContextFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.removePropertyChangeListener("campaignContextFilled", this);
                }
            }
        });
    }

}