/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.updater;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class MoveHelper {
    public static void move(Path sourceDirectory, Path targetDirectory, boolean dryRun) throws IOException {
        MoveTreeVisitor copyVisitor = new MoveTreeVisitor(sourceDirectory, targetDirectory, dryRun);
        Files.walkFileTree(sourceDirectory, copyVisitor);
    }

    static class MoveTreeVisitor
    extends SimpleFileVisitor<Path> {
        final Path sourceDirectory;
        final int sourcePathCount;
        final Path targetDirectory;
        final boolean dryRun;

        MoveTreeVisitor(Path sourceDirectory, Path targetDirectory, boolean dryRun) {
            this.sourceDirectory = sourceDirectory;
            this.targetDirectory = targetDirectory;
            this.dryRun = dryRun;
            this.sourcePathCount = sourceDirectory.getNameCount();
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path target;
            if (this.sourceDirectory.equals(dir)) {
                target = this.targetDirectory;
            } else {
                Path sourceRelativize = dir.subpath(this.sourcePathCount, dir.getNameCount());
                target = this.targetDirectory.resolve(sourceRelativize).toAbsolutePath();
            }
            System.out.println(String.format("Create directory: %s", target));
            if (!this.dryRun) {
                Files.createDirectories(target, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path subPath = file.subpath(this.sourcePathCount, file.getNameCount());
            Path target = this.targetDirectory.resolve(subPath).normalize().toAbsolutePath();
            System.out.println(String.format("Copy file from %s to %s", file, target));
            if (!this.dryRun) {
                Files.move(file, target, new CopyOption[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            System.out.println(String.format("Delete directory: %s", dir));
            if (!this.dryRun) {
                Files.delete(dir);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

