/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.updater;

import fr.ifremer.tutti.ui.swing.updater.DeleteHelper;
import fr.ifremer.tutti.ui.swing.updater.Module;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;

public class Updater {
    public static final String APPLICATION_UPDATER_TITLE = "Allegro Campaign UI Updater";
    public static final String NEW_DIR = "NEW";
    public static final String OLD_DIR = "OLD";
    public static final String LAUNCHER_DIR = "launcher";
    public static final String UPDATE_RUNTIME_CMD = "update_runtime";
    public static final String BATCH_WINDOWS_EXT = ".bat";
    public static final String BATCH_UNIX_EXT = ".sh";
    public static final String VERSION_FILE = "version.appup";
    public static final int NORMAL_EXIT_CODE = 0;
    public static final int ERROR_EXIT_CODE = 1;
    public static final int RUNTIME_UPDATE_EXIT_CODE = 90;
    private final Path baseDir = Paths.get(System.getProperty("user.dir"), new String[0]);
    private final String backupDate;
    private final boolean windowsOS;

    public static void main(String ... args) {
        Updater updater = new Updater();
        int exitCode = updater.execute();
        System.exit(exitCode);
    }

    public Updater() {
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        this.backupDate = df.format(now);
        this.windowsOS = System.getProperty("os.name").startsWith("Windows");
    }

    private Path getBackupDirectory() throws IOException {
        Path backupDirectory = this.baseDir.resolve(OLD_DIR);
        if (!Files.isDirectory(backupDirectory, new LinkOption[0])) {
            Files.createDirectory(backupDirectory, new FileAttribute[0]);
        }
        return backupDirectory;
    }

    public int execute() {
        int exitCode;
        System.out.println("updater started at " + new Date().toString());
        try {
            boolean runtimeUpdate = this.checkRuntimeUpdate();
            if (runtimeUpdate) {
                exitCode = 90;
            } else {
                this.launchUpdate();
                exitCode = 0;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            exitCode = 1;
        }
        System.out.println("updater ended   at " + new Date().toString());
        return exitCode;
    }

    protected boolean checkRuntimeUpdate() throws Exception {
        String scriptFilename = UPDATE_RUNTIME_CMD + (this.windowsOS ? BATCH_WINDOWS_EXT : BATCH_UNIX_EXT);
        Path runtimeUpdater = this.baseDir.resolve(scriptFilename);
        Files.deleteIfExists(runtimeUpdater);
        boolean mustUpdateRuntime = false;
        for (Module module : Module.values()) {
            boolean updateFound;
            if (!module.isRuntimeModule() || !(updateFound = this.updateRuntimeModule(module))) continue;
            mustUpdateRuntime = true;
        }
        if (mustUpdateRuntime) {
            URL resource = this.getClass().getResource("/" + scriptFilename);
            try (InputStream stream = resource.openStream();){
                Files.copy(stream, runtimeUpdater, StandardCopyOption.REPLACE_EXISTING);
            }
            this.makeExecutable(runtimeUpdater);
            String message = String.format("Runtime updates available.\nYou must execute '%s' manually to apply new runtime.", runtimeUpdater.getFileName());
            System.out.println(message);
            JOptionPane.showMessageDialog(null, message);
        }
        return mustUpdateRuntime;
    }

    protected void launchUpdate() throws IOException {
        for (Module module : Module.values()) {
            if (module.isRuntimeModule()) continue;
            this.updateModule(module);
        }
        this.cleanObsoleteFiles();
        DeleteHelper.deleteDirectory(this.baseDir.resolve(NEW_DIR));
    }

    protected boolean updateRuntimeModule(Module module) throws IOException {
        boolean updateFound;
        String moduleName = module.name();
        Path modulePath = this.baseDir.resolve(moduleName);
        String oldVersion = this.getVersion(modulePath);
        String moduleNameStr = module.getModuleLoggerName();
        System.out.println(String.format("%s Current version: %s", moduleNameStr, oldVersion));
        Path moduleNewPath = this.baseDir.resolve(NEW_DIR).resolve(moduleName);
        if (Files.isDirectory(moduleNewPath, new LinkOption[0])) {
            String newVersion = this.getVersion(moduleNewPath);
            System.out.println(String.format("%s New version detected %s", moduleNameStr, newVersion));
            Path backupDirectory = this.getBackupDirectory();
            System.out.println(String.format("%s Clean backup directory %s", moduleNameStr, backupDirectory + File.separator + moduleName + "-*"));
            DeleteHelper.deleteDirectories(backupDirectory, moduleName + "-*");
            updateFound = true;
        } else {
            System.out.println(String.format("%s No update found", moduleNameStr));
            updateFound = false;
        }
        return updateFound;
    }

    private void updateModule(Module module) throws IOException {
        String moduleName = module.name();
        Path modulePath = this.baseDir.resolve(moduleName);
        String oldVersion = this.getVersion(modulePath);
        String moduleNameStr = module.getModuleLoggerName();
        System.out.println(String.format("%s Current version: %s", moduleNameStr, oldVersion));
        Path moduleNewPath = this.baseDir.resolve(NEW_DIR).resolve(moduleName);
        if (Files.isDirectory(moduleNewPath, new LinkOption[0])) {
            String newVersion = this.getVersion(moduleNewPath);
            System.out.println(String.format("%s New version detected %s", moduleNameStr, newVersion));
            Path backupDirectory = this.getBackupDirectory();
            System.out.println(String.format("%s Clean backup directory %s", moduleNameStr, backupDirectory + File.separator + moduleName + "-*"));
            DeleteHelper.deleteDirectories(backupDirectory, moduleName + "-*");
            if (Files.isDirectory(modulePath, new LinkOption[0])) {
                Path moduleOldPath = backupDirectory.resolve(String.format("%s-%s-%s", moduleName, oldVersion, this.backupDate));
                System.out.println(String.format("%s Backup old version %s to %s", moduleNameStr, oldVersion, moduleOldPath.toString()));
                Files.move(modulePath, moduleOldPath, new CopyOption[0]);
            }
            System.out.println(String.format("%s Install new version %s", moduleNameStr, newVersion));
            Files.move(moduleNewPath, modulePath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            System.out.println(String.format("%s No update found", moduleNameStr));
        }
    }

    private String getVersion(Path path) throws IOException {
        Path versionFile = path.resolve(VERSION_FILE);
        List<String> lines = Files.readAllLines(versionFile, StandardCharsets.UTF_8);
        if (lines == null || lines.isEmpty()) {
            throw new IOException(versionFile.toString() + " is empty");
        }
        return lines.get(0);
    }

    protected void makeExecutable(Path path) throws IOException {
        if (!this.windowsOS) {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.GROUP_WRITE);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_READ);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
            Files.setPosixFilePermissions(path, perms);
        }
    }

    private void cleanObsoleteFiles() throws IOException {
        Path applicationDirectoryPath = this.baseDir.resolve(Module.tutti.name());
        if (this.windowsOS) {
            Files.deleteIfExists(this.baseDir.resolve("tutti.bat"));
            Files.deleteIfExists(applicationDirectoryPath.resolve("launch.bat"));
            DeleteHelper.deleteFiles(this.baseDir, "*.sh");
        } else {
            Files.deleteIfExists(applicationDirectoryPath.resolve("launch.sh"));
            DeleteHelper.deleteFiles(this.baseDir, "*.bat");
            DeleteHelper.deleteFiles(this.baseDir, "*.exe");
        }
        Files.deleteIfExists(applicationDirectoryPath.resolve("tutti.exe"));
        Files.deleteIfExists(applicationDirectoryPath.resolve("tutti.sh"));
        DeleteHelper.deleteDirectory(applicationDirectoryPath.resolve(LAUNCHER_DIR));
    }
}

