/*
 * *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.entity.ActivityCalendar;
import fr.ifremer.suiviobsmer.entity.ActivityMonth;
import fr.ifremer.suiviobsmer.entity.ActivityProfession;
import fr.ifremer.suiviobsmer.entity.ActivityZone;
import fr.ifremer.suiviobsmer.entity.Boat;
import fr.ifremer.suiviobsmer.services.ServiceBoat;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.nuiton.util.DateUtils;
import org.slf4j.Logger;

/**
 * ActivityCalendarPage
 *
 * Created: 14 déc. 2009
 *
 * @author fdesbois
 * @version $Revision: 330 $
 *
 * Mise a jour: $Date: 2010-02-05 15:04:29 +0100 (ven. 05 févr. 2010) $
 * par : $Author$
 */
@IncludeStylesheet("context:css/boats.css")
public class BoatActivityCalendar implements SuiviObsmerPage {

    @Inject
    private Logger log;
    
    @Inject
    private ServiceBoat serviceBoat;

    private ActivityCalendar activityCalendar;

//    @Property
//    private ActivityMonth activityMonth;

    @Property
    private int month;

    @Property
    private int professionIndex;

    @Property
    private int zoneIndex;

    @Persist
    private Boat boat;

    void setupRender() {
        
    }

    @Override
    public boolean isOnlyForAdmin() {
        return false;
    }

    public void setBoat(Boat boat) {
       this.boat = boat;
    }

    public Boat getBoat() {
        return this.boat;
    }

    public List<Boat> getBoats() {
        return Collections.singletonList(boat);
    }

    public ActivityCalendar getActivityCalendar() throws SuiviObsmerException {
        if (activityCalendar == null) {
            if (log.isInfoEnabled()) {
                log.info("BUSINESS REQUEST [getLastActivityCalendar]");
            }
            this.activityCalendar = serviceBoat.getLastActivityCalendar(getBoat());
        }
        return activityCalendar;
    }

    public ActivityMonth getActivityMonth() throws SuiviObsmerException {
        return getActivityCalendar().getActivityMonth(month);
    }

    public String getMonthName() {
        String libelle = DateUtils.getMonthLibelle(month);
        return StringUtils.capitalize(libelle);
    }

    public int getProfessionIndexMax() {
        int result = 0;
        for (ActivityMonth curr : activityCalendar.getActivityMonth()) {
            int nbProfessions = curr.sizeActivityProfession();
            if (nbProfessions > result) {
                result = nbProfessions;
            }
        }
        return result-1;
    }

    public boolean hasProfessions() {
        return getProfessionIndexMax() != -1;
    }

    public ActivityProfession getActivityProfession() throws SuiviObsmerException {
        if (getActivityMonth() == null) {
            return null;
        }
        if (professionIndex >= getActivityMonth().sizeActivityProfession()) {
            return null;
        }
        return getActivityMonth().getActivityProfession().get(professionIndex);
    }

    public int getZoneIndexMax() throws SuiviObsmerException {
        int result = 0;
        for (ActivityMonth activityMonth : activityCalendar.getActivityMonth()) {
            month = activityMonth.getMonth();
            ActivityProfession profession = getActivityProfession();
            if (profession != null) {
                int nbZones = profession.sizeActivityZone();
                if (nbZones > result) {
                    result = nbZones;
                }
            }
        }
        return result-1;
    }

    /** Hack for pagelink to Boats page
     *
     * @return null
     */
    public String getNorow() {
        return null;
    }

//    public boolean hasZones() {
//        return getZoneIndexMax() != -1;
//    }

    public ActivityZone getActivityZone() throws SuiviObsmerException {
        ActivityProfession profession = getActivityProfession();
        if (profession == null) {
            return null;
        }
        if (zoneIndex >= profession.sizeActivityZone()) {
            return null;
        }
        return profession.getActivityZone().get(zoneIndex);
    }
}
