/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.data;

import fr.ifremer.suiviobsmer.ui.data.ChartUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;

public class ChartUtils {
    public static JFreeChart createCategoryChart(String title, String axisName, String categoryName, ChartType type, Map<String, SortedMap<?, Integer>> input) {
        SimpleDateFormat format = new SimpleDateFormat("MM/yyyy");
        boolean dateType = false;
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int i = 0;
        for (Map.Entry<String, SortedMap<?, Integer>> map : input.entrySet()) {
            for (Map.Entry<?, Integer> data : map.getValue().entrySet()) {
                Object dataKey = data.getKey();
                String columnKey = "";
                if (Date.class.isAssignableFrom(dataKey.getClass())) {
                    columnKey = format.format((Date)dataKey);
                    dateType = true;
                } else {
                    columnKey = dataKey.toString();
                }
                dataset.setValue((Number)data.getValue(), (Comparable)((Object)map.getKey()), (Comparable)((Object)columnKey));
            }
            ++i;
        }
        CategoryAxis categoryAxis = new CategoryAxis(categoryName);
        if (dateType) {
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        }
        if (type.noCategoryMargin) {
            categoryAxis.setCategoryMargin(0.0);
        }
        NumberAxis valueAxis = new NumberAxis(axisName);
        valueAxis.setUpperMargin(0.15);
        AbstractCategoryItemRenderer renderer = type.createRenderer();
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setBaseItemLabelsVisible(Boolean.TRUE);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
    }
}

