/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.entity.News;
import fr.ifremer.suiviobsmer.entity.NewsImpl;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.services.ServiceNews;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.Asset2;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/news.css"})
public class Index
implements SuiviObsmerPage {
    @Inject
    private ServiceNews serviceNews;
    @Inject
    private Logger log;
    @SessionState
    @Property
    private User user;
    @Persist
    private List<News> newsList;
    @Property
    private News news;
    private DateFormat dateFormat;
    @Persist(value="flash")
    private String editedId;
    @Property
    private int rowIndex;
    @Property
    @Inject
    @Path(value="context:js/FCKConf.js")
    private Asset2 fckconf;

    public boolean isOnlyForAdmin() {
        return false;
    }

    @Log
    void setupRender() throws SuiviObsmerException {
        if (this.editedId == null || !"NEW".equals(this.editedId)) {
            this.newsList = null;
            this.getNewsList();
        }
    }

    public List<News> getNewsList() throws SuiviObsmerException {
        if (this.newsList == null) {
            this.newsList = this.serviceNews.getNews();
        }
        return this.newsList;
    }

    public boolean isEditionMode() {
        return this.isCreateMode() || this.news.getTopiaId().equals(this.editedId);
    }

    public boolean isCreateMode() {
        return this.news.getTopiaId() == null;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        }
        return this.dateFormat;
    }

    void onActionFromAddNews() throws SuiviObsmerException {
        this.news = new NewsImpl();
        ArrayList<News> list = new ArrayList<News>();
        list.add(this.news);
        list.addAll(this.getNewsList());
        this.newsList = list;
        this.editedId = "NEW";
    }

    void onActionFromEditNews(int rowIndex) throws SuiviObsmerException {
        this.news = (News)this.getNewsList().get(rowIndex);
        this.editedId = this.news.getTopiaId();
    }

    void onActionFromDeleteNews(int rowIndex) throws SuiviObsmerException {
        this.news = (News)this.getNewsList().get(rowIndex);
        this.serviceNews.saveNews(this.news, true);
    }

    void onActionFromCancelEdit() {
    }

    void onSelectedFromSaveNews(int rowIndex) throws SuiviObsmerException {
        this.news = (News)this.getNewsList().get(rowIndex);
    }

    void onSuccessFromNewsForm() throws SuiviObsmerException {
        this.serviceNews.saveNews(this.news, false);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.news.getContent());
        }
    }
}

