
package fr.ifremer.suiviobsmer.ui.data;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.BoatFilter;
import fr.ifremer.suiviobsmer.entity.Boat;
import fr.ifremer.suiviobsmer.services.ServiceBoat;
import java.util.Map;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.SortConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * BoatDataSource
 *
 * Created: 19 janv. 2010
 *
 * @author fdesbois
 * @version $Revision: 240 $
 *
 * Mise a jour: $Date: 2010-01-19 16:58:08 +0100 (mar., 19 janv. 2010) $
 * par : $Author$
 */
public class BoatDataSource extends AbstractMappedGridDataSource<Integer, Boat> {

    private static Logger log = LoggerFactory.getLogger(BoatDataSource.class);

    private BoatFilter filter;

    private ServiceBoat service;

    public BoatDataSource(BoatFilter filter, ServiceBoat service) {
        this.filter = filter;
        this.service = service;
    }


    @Override
    protected Map<Integer, Boat> execute(int startIndex, int endIndex, SortConstraint orderBy) throws SuiviObsmerException {
        if (log.isInfoEnabled()) {
            log.info("BUSINESS REQUEST [getBoatsByFilter]");
        }
        filter.setStartIndex(startIndex);
        filter.setEndIndex(endIndex);

        if (orderBy != null) {
            PropertyModel property = orderBy.getPropertyModel();
            String filterOrder = property.getPropertyName();

            ColumnSort sort = orderBy.getColumnSort();
            if (sort.equals(ColumnSort.DESCENDING)) {
                filterOrder += " desc";
            }

            if (log.isDebugEnabled()) {
                log.debug("Order : " + filterOrder);
            }
            filter.setOrderBy(filterOrder);
        }
        
        return service.getBoatsByFilter(filter);
    }

    @Override
    protected int count() throws SuiviObsmerException {
        if (log.isInfoEnabled()) {
            log.info("BUSINESS REQUEST [countBoatsByFilter]");
        }
        return service.countBoatsByFilter(filter);
    }

    @Override
    public Class<?> getRowType() {
        return Boat.class;
    }

}
